/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public final class SerializerLong
implements ISerializer<Long> {
    public static final ISerializer<Long> SERIALIZER = new SerializerLong();

    private SerializerLong() {
    }

    @Override
    public Long fromJSON(JsonElement json) {
        return json.getAsLong();
    }

    @Override
    public JsonElement toJSON(Long toWrite) {
        return new JsonPrimitive((Number)toWrite);
    }

    @Override
    public Long fromByteBuf(FriendlyByteBuf buffer) {
        return buffer.readLong();
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, Long toWrite) {
        buffer.writeLong(toWrite.longValue());
    }

    @Override
    public Tag toNBT(Long toWrite) {
        return LongTag.m_128882_((long)toWrite);
    }

    @Override
    public Long fromNBT(Tag nbt) {
        if (nbt instanceof NumericTag) {
            NumericTag longTag = (NumericTag)nbt;
            return longTag.m_7046_();
        }
        throw new NBTParseException("Expected NBT to be a number tag. Class was " + nbt.getClass() + " with ID " + nbt.m_7060_() + " instead.");
    }
}

