/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.__internal__.ApiSide;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

@ApiSide.ClientOnly
public class BarComponent
extends GuiComponent
implements ITooltipComponent {
    private static final int WIDTH = 100;
    private static final int HEIGHT = 11;
    private static final float U0 = 0.0859375f;
    private static final float U1 = 0.4765625f;
    private static final float V0_BG = 0.0f;
    private static final float V1_BG = 0.04296875f;
    private static final float V0_FG = 0.04296875f;
    private static final float V1_FG = 0.0859375f;
    private static final float UV_W = 0.390625f;
    private final float ratio;
    private final int color;
    private final Component text;

    public BarComponent(float ratio, int color) {
        this(ratio, color, CommonComponents.f_237098_);
    }

    public BarComponent(float ratio, int color, String text) {
        this(ratio, color, (Component)Component.m_237113_((String)text));
    }

    public BarComponent(float ratio, int color, Component text) {
        this.ratio = ratio;
        this.color = color;
        this.text = text;
    }

    @Override
    public int getWidth() {
        return Math.max(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.text), 100);
    }

    @Override
    public int getHeight() {
        return 11;
    }

    @Override
    public void render(PoseStack matrices, int x, int y, float delta) {
        BarComponent.renderBar(matrices, x, y, 100.0f, 0.0f, 0.4765625f, 0.04296875f, this.color);
        BarComponent.renderBar(matrices, x, y, 100.0f * this.ratio, 0.04296875f, 0.0859375f + 0.390625f * this.ratio, 0.0859375f, this.color);
        double luminance = WailaHelper.getLuminance(this.color);
        int overlay = 0;
        if (luminance < 0.25) {
            overlay = 0x8FFFFFF;
        } else if (luminance > 0.9) {
            overlay = Integer.MIN_VALUE;
        } else if (luminance > 0.8) {
            overlay = 0x70000000;
        } else if (luminance > 0.7) {
            overlay = 0x60000000;
        } else if (luminance > 0.6) {
            overlay = 0x50000000;
        } else if (luminance > 0.5) {
            overlay = 0x40000000;
        }
        if (overlay != 0) {
            BarComponent.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + 100), (int)(y + 11), (int)overlay);
        }
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.text);
        float textX = (float)x + Math.max((float)(100 - textWidth) / 2.0f, 0.0f);
        float textY = y + 2;
        Minecraft.m_91087_().f_91062_.m_92889_(matrices, this.text, textX, textY, -5592406);
    }

    private static void renderBar(PoseStack matrices, int x, int y, float w, float v0, float u1, float v1, int tint) {
        matrices.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WailaConstants.COMPONENT_TEXTURE);
        int a = WailaHelper.getAlpha(tint);
        int r = WailaHelper.getRed(tint);
        int g = WailaHelper.getGreen(tint);
        int b = WailaHelper.getBlue(tint);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_85982_(matrices.m_85850_().m_85861_(), (float)x, (float)(y + 11), 0.0f).m_6122_(r, g, b, a).m_7421_(0.0859375f, v1).m_5752_();
        buffer.m_85982_(matrices.m_85850_().m_85861_(), (float)x + w, (float)(y + 11), 0.0f).m_6122_(r, g, b, a).m_7421_(u1, v1).m_5752_();
        buffer.m_85982_(matrices.m_85850_().m_85861_(), (float)x + w, (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_(u1, v0).m_5752_();
        buffer.m_85982_(matrices.m_85850_().m_85861_(), (float)x, (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_(0.0859375f, v0).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        matrices.m_85849_();
    }
}

