/*
 * Decompiled with CFR 0.152.
 */
package squeek.wthitharvestability.helpers;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import squeek.wthitharvestability.helpers.ToolType;

public class ToolHelper {
    public static final List<Function<ItemStack, Tier>> TIER_GETTERS = new ArrayList<Function<ItemStack, Tier>>();
    private static final Supplier<Object2IntMap<Tier>> tiers = Suppliers.memoize(() -> {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int i = 0;
        for (Tier tier : TierSortingRegistry.getSortedTiers()) {
            map.put((Object)tier, i);
            ++i;
        }
        return map;
    });

    public static boolean isToolEffectiveAgainst(@Nonnull ItemStack tool, BlockState state, ToolType effectiveToolType) {
        return tool.m_41735_(state) || tool.canPerformAction(effectiveToolType.action());
    }

    public static boolean canToolHarvestLevel(@Nonnull ItemStack tool, Tier harvestTier) {
        Function<ItemStack, Tier> getter;
        if (tool.m_41619_()) {
            return false;
        }
        Tier tier = null;
        Iterator<Function<ItemStack, Tier>> iterator = TIER_GETTERS.iterator();
        while (iterator.hasNext() && (tier = (getter = iterator.next()).apply(tool)) == null) {
        }
        return tier != null && tiers.get().getInt(tier) >= tiers.get().getInt((Object)harvestTier);
    }

    public static boolean canToolHarvestBlock(@Nonnull ItemStack tool, BlockState blockState) {
        return !blockState.m_60834_() || tool.m_41735_(blockState);
    }

    static {
        TIER_GETTERS.add(stack -> {
            Tier tier;
            Item patt1127$temp = stack.m_41720_();
            if (patt1127$temp instanceof TieredItem) {
                TieredItem tiered = (TieredItem)patt1127$temp;
                tier = tiered.m_43314_();
            } else {
                tier = null;
            }
            return tier;
        });
    }
}

