/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.Spells;
import de.cas_ual_ty.spells.requirement.IRequirementType;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SpellTreeSerializer {
    private static byte TYPE_FINISH = 0;
    private static byte TYPE_SPELL = 1;
    private static byte TYPE_UP = (byte)2;

    public static void encodeTree(SpellTree spellTree, FriendlyByteBuf buf) {
        buf.m_130077_(spellTree.getId());
        buf.m_130083_(spellTree.getTitle());
        buf.writeRegistryId(Spells.SPELLS_REGISTRY.get(), (Object)spellTree.getIconSpell());
        SpellTreeSerializer.encodeRequirements(spellTree.getRequirements(), buf);
        SpellNode spellNode = spellTree.getRoot();
        SpellTreeSerializer.encodeNode(spellNode, buf);
        for (SpellNode child : spellNode.getChildren()) {
            SpellTreeSerializer.encodeTreeRec(child, buf);
        }
        buf.writeByte((int)TYPE_FINISH);
    }

    private static void encodeTreeRec(SpellNode spellNode, FriendlyByteBuf buf) {
        buf.writeByte((int)TYPE_SPELL);
        SpellTreeSerializer.encodeNode(spellNode, buf);
        for (SpellNode child : spellNode.getChildren()) {
            SpellTreeSerializer.encodeTreeRec(child, buf);
        }
        buf.writeByte((int)TYPE_UP);
    }

    private static void encodeRequirements(List<Requirement> list, FriendlyByteBuf buf) {
        buf.writeInt(list.size());
        list.forEach(requirement -> IRequirementType.writeToBuf(buf, requirement));
    }

    private static void encodeNode(SpellNode spellNode, FriendlyByteBuf buf) {
        buf.writeRegistryId(Spells.SPELLS_REGISTRY.get(), (Object)spellNode.getSpell());
        buf.writeInt(spellNode.getLevelCost());
        SpellTreeSerializer.encodeRequirements(spellNode.getRequirements(), buf);
        buf.writeShort(spellNode.getId());
    }

    public static SpellTree decodeTree(FriendlyByteBuf buf) {
        byte next;
        UUID id = buf.m_130259_();
        Component title = buf.m_130238_();
        ISpell icon = (ISpell)buf.readRegistryId();
        List<Requirement> requirements = SpellTreeSerializer.decodeRequirements(buf);
        SpellTree.Builder builder = SpellTree.builder(id, title, SpellTreeSerializer.decodeNode(buf));
        while ((next = buf.readByte()) != TYPE_FINISH) {
            if (next == TYPE_SPELL) {
                builder.add(SpellTreeSerializer.decodeNode(buf));
                continue;
            }
            if (next == TYPE_UP) {
                builder.leaf();
                continue;
            }
            throw new IllegalStateException();
        }
        return builder.icon(icon).finish().setRequirements(requirements);
    }

    private static List<Requirement> decodeRequirements(FriendlyByteBuf buf) {
        int size = buf.readInt();
        LinkedList<Requirement> list = new LinkedList<Requirement>();
        for (int i = 0; i < size; ++i) {
            list.add(IRequirementType.readFromBuf(buf));
        }
        return list;
    }

    public static SpellNode decodeNode(FriendlyByteBuf buf) {
        ISpell spell = (ISpell)buf.readRegistryId();
        int levelCost = buf.readInt();
        List<Requirement> requirements = SpellTreeSerializer.decodeRequirements(buf);
        short id = buf.readShort();
        return new SpellNode(spell, levelCost, requirements, id);
    }

    private static JsonObject nodeToJsonRec(SpellNode node) {
        JsonObject json = new JsonObject();
        json.addProperty("spell", SpellsUtil.getSpellKey(node.getSpell()).toString());
        json.addProperty("levelCost", (Number)node.getLevelCost());
        json.add("requirements", (JsonElement)SpellTreeSerializer.requirementsToJson(node.getRequirements()));
        JsonArray children = new JsonArray();
        node.getChildren().forEach(child -> children.add((JsonElement)SpellTreeSerializer.nodeToJsonRec(child)));
        json.add("children", (JsonElement)children);
        return json;
    }

    private static JsonArray requirementsToJson(List<Requirement> requirements) {
        JsonArray json = new JsonArray();
        requirements.forEach(requirement -> json.add((JsonElement)IRequirementType.writeToJson(requirement)));
        return json;
    }

    public static JsonObject treeToJson(SpellTree tree) {
        JsonObject json = new JsonObject();
        json.addProperty("id", tree.getId().toString());
        json.add("title", Component.Serializer.m_130716_((Component)tree.getTitle()));
        json.addProperty("icon_spell", SpellsUtil.getSpellKey(tree.getIconSpell()).toString());
        json.add("requirements", (JsonElement)SpellTreeSerializer.requirementsToJson(tree.getRequirements()));
        json.add("root_spell", (JsonElement)(tree.getRoot() != null ? SpellTreeSerializer.nodeToJsonRec(tree.getRoot()) : JsonNull.INSTANCE));
        return json;
    }

    private static SpellNode nodeFromJson(JsonObject json) {
        ISpell spell = SpellsFileUtil.jsonSpell(json, "spell");
        int levelCost = SpellsFileUtil.jsonInt(json, "levelCost");
        List<Requirement> requirements = SpellTreeSerializer.requirementsFromJson(SpellsFileUtil.jsonArray(json, "requirements"));
        SpellNode node = new SpellNode(spell, levelCost, requirements);
        JsonArray children = SpellsFileUtil.jsonArray(json, "children");
        children.forEach(e -> SpellTree.connect(node, SpellTreeSerializer.nodeFromJson(e.getAsJsonObject())));
        return node;
    }

    public static List<Requirement> requirementsFromJson(JsonArray json) {
        LinkedList<Requirement> requirements = new LinkedList<Requirement>();
        json.forEach(jsonElement -> {
            if (!jsonElement.isJsonObject()) {
                return;
            }
            Requirement requirement = IRequirementType.readFromJson(jsonElement.getAsJsonObject());
            if (requirement != null) {
                requirements.add(requirement);
            }
        });
        return requirements;
    }

    public static SpellTree treeFromJson(JsonObject json) {
        UUID id = UUID.fromString(SpellsFileUtil.jsonString(json, "id"));
        MutableComponent title = Component.Serializer.m_130691_((JsonElement)SpellsFileUtil.jsonElement(json, "title"));
        ISpell icon = SpellsFileUtil.jsonSpell(json, "icon_spell");
        List<Requirement> requirements = SpellTreeSerializer.requirementsFromJson(SpellsFileUtil.jsonArray(json, "requirements"));
        SpellNode root = SpellTreeSerializer.nodeFromJson(SpellsFileUtil.jsonObject(json, "root_spell"));
        return new SpellTree(id, root, (Component)title, icon).setRequirements(requirements);
    }
}

