/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.IProjectileSpell;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.spell.base.SpellProjectile;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class FireBallSpell
extends BaseIngredientsSpell
implements IProjectileSpell {
    public final int defaultFireSeconds;
    public final float defaultDamage;
    protected int fireSeconds;
    protected float damage;

    public FireBallSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, int fireSeconds, float damage) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.defaultFireSeconds = fireSeconds;
        this.defaultDamage = damage;
    }

    public FireBallSpell(float manaCost, ItemStack ingredient, int fireSeconds, float damage) {
        super(manaCost, ingredient);
        this.defaultFireSeconds = fireSeconds;
        this.defaultDamage = damage;
    }

    public FireBallSpell(float manaCost, int fireSeconds, float damage) {
        super(manaCost);
        this.defaultFireSeconds = fireSeconds;
        this.defaultDamage = damage;
    }

    public FireBallSpell() {
        this(5.0f, new ItemStack((ItemLike)Items.f_42593_), 2, 2.0f);
    }

    @Override
    public void projectileTick(SpellProjectile entity) {
        if (entity.f_19853_.f_46443_) {
            int i;
            double spread;
            Vec3 pos = entity.m_20182_();
            Random random = new Random();
            if (entity.f_19797_ % 2 == 0) {
                spread = 0.2;
                for (i = 0; i < 3; ++i) {
                    entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_ + random.nextGaussian() * 0.2, pos.f_82480_ + random.nextGaussian() * 0.2, pos.f_82481_ + random.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
                }
            }
            if (entity.f_19797_ % 4 == 0) {
                entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            spread = 0.1;
            for (i = 0; i < 2; ++i) {
                entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_ + random.nextGaussian() * 0.1, pos.f_82480_ + random.nextGaussian() * 0.1, pos.f_82481_ + random.nextGaussian() * 0.1, 0.0, 0.0, 0.0);
                entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_ + random.nextGaussian() * 0.1, pos.f_82480_ + random.nextGaussian() * 0.1, pos.f_82481_ + random.nextGaussian() * 0.1, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        this.shootStraight(manaHolder, 3.0f, (projectile, level) -> level.m_6269_(null, (Entity)manaHolder.getPlayer(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f));
    }

    @Override
    public void projectileHitEntity(SpellProjectile entity, EntityHitResult entityHitResult) {
        Entity hit = entityHitResult.m_82443_();
        if (hit instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hit;
            livingEntity.m_6469_(DamageSource.m_19367_((Entity)entity, (Entity)entity.m_37282_()), this.damage);
            livingEntity.m_20254_(this.fireSeconds);
        }
        IProjectileSpell.super.projectileHitEntity(entity, entityHitResult);
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("fireSeconds", (Number)this.defaultFireSeconds);
        json.addProperty("damage", (Number)Float.valueOf(this.defaultDamage));
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.fireSeconds = SpellsFileUtil.jsonInt(json, "fireSeconds");
        this.damage = SpellsFileUtil.jsonFloat(json, "damage");
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.fireSeconds = this.defaultFireSeconds;
        this.damage = this.defaultDamage;
    }
}

