/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.command.SpellArgument;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class SpellCommand {
    public static final String SPELLS_PROGRESSION_LEARN_SINGLE = "spells.progression.learn.success.single";
    public static final String SPELLS_PROGRESSION_LEARN_MULTIPLE = "spells.progression.learn.success.multiple";
    public static final String SPELLS_PROGRESSION_LEARN_ALL_SINGLE = "spells.progression.learn_all.success.single";
    public static final String SPELLS_PROGRESSION_LEARN_ALL_SINGLE_FAILED = "spells.progression.learn_all.failed.single";
    public static final String SPELLS_PROGRESSION_LEARN_ALL_MULTIPLE = "spells.progression.learn_all.success.multiple";
    public static final String SPELLS_PROGRESSION_FORGET_SINGLE = "spells.progression.forget.success.single";
    public static final String SPELLS_PROGRESSION_FORGET_MULTIPLE = "spells.progression.forget.success.multiple";
    public static final String SPELLS_PROGRESSION_FORGET_ALL_SINGLE = "spells.progression.forget_all.success.single";
    public static final String SPELLS_PROGRESSION_FORGET_ALL_SINGLE_FAILED = "spells.progression.forget_all.failed.single";
    public static final String SPELLS_PROGRESSION_FORGET_ALL_MULTIPLE = "spells.progression.forget_all.success.multiple";
    public static final String SPELLS_PROGRESSION_RESET_SINGLE = "spells.progression.reset.success.single";
    public static final String SPELLS_PROGRESSION_RESET_MULTIPLE = "spells.progression.reset.success.multiple";
    public static final String SPELLS_SLOT_REMOVE_SINGLE = "spells.slot.remove.success.single";
    public static final String SPELLS_SLOT_REMOVE_MULTIPLE = "spells.slot.remove.success.multiple";
    public static final String SPELLS_SLOT_SET_SINGLE = "spells.slot.set.success.single";
    public static final String SPELLS_SLOT_SET_MULTIPLE = "spells.slot.set.success.multiple";
    public static final String SPELLS_SLOT_CLEAR_SINGLE = "spells.slot.clear.success.single";
    public static final String SPELLS_SLOT_CLEAR_MULTIPLE = "spells.slot.clear.success.multiple";
    public static final String ARG_TARGETS = "targets";
    public static final String ARG_SPELL = "spell";
    public static final String ARG_SLOT = "slot";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext cbx) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spells").requires(css -> css.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"progression").then(Commands.m_82127_((String)"learn").then(((RequiredArgumentBuilder)Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_SPELL, (ArgumentType)SpellArgument.spell(cbx)).executes(SpellCommand::spellsProgressionLearn))).then(Commands.m_82129_((String)"all", (ArgumentType)StringArgumentType.string()).executes(SpellCommand::spellsProgressionLearnAll))))).then(Commands.m_82127_((String)"forget").then(((RequiredArgumentBuilder)Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_SPELL, (ArgumentType)SpellArgument.spell(cbx)).executes(SpellCommand::spellsProgressionForget))).then(Commands.m_82129_((String)"all", (ArgumentType)StringArgumentType.string()).executes(SpellCommand::spellsProgressionForgetAll))))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).executes(SpellCommand::spellsProgressionReset))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"slots").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_SLOT, (ArgumentType)IntegerArgumentType.integer((int)0, (int)5)).then(Commands.m_82129_((String)ARG_SPELL, (ArgumentType)SpellArgument.spell(cbx)).executes(SpellCommand::spellsSlotSet)))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_SLOT, (ArgumentType)IntegerArgumentType.integer((int)0, (int)5)).executes(SpellCommand::spellsSlotRemove))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).executes(SpellCommand::spellsSlotClear)))));
    }

    private static int spellsProgressionLearn(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        ISpell spell = SpellArgument.getSpell(context, ARG_SPELL);
        if (players.size() == 0) {
            return 0;
        }
        players.stream().map(SpellProgressionHolder::getSpellProgressionHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellProgressionHolder -> spellProgressionHolder.setSpellStatus(spell, SpellStatus.LEARNED)));
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_LEARN_SINGLE, (Object[])new Object[]{spell.getSpellName(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_LEARN_MULTIPLE, (Object[])new Object[]{spell.getSpellName(), players.size()}), true);
        }
        return players.size();
    }

    private static int spellsProgressionLearnAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.size() == 0) {
            return 0;
        }
        boolean single = players.size() == 1;
        AtomicInteger learned = new AtomicInteger(0);
        players.stream().map(SpellProgressionHolder::getSpellProgressionHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellProgressionHolder -> SpellsUtil.forEachSpell((key, spell) -> {
            if (single && spellProgressionHolder.getSpellStatus((ISpell)spell) != SpellStatus.LEARNED) {
                learned.getAndIncrement();
            }
            spellProgressionHolder.setSpellStatus((ISpell)spell, SpellStatus.LEARNED);
        })));
        if (players.size() == 1) {
            if (learned.get() > 0) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_LEARN_ALL_SINGLE, (Object[])new Object[]{learned.get(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_LEARN_ALL_SINGLE_FAILED, (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}));
            }
        } else {
            int amount = SpellsUtil.getSpellsAmount();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_LEARN_ALL_MULTIPLE, (Object[])new Object[]{amount, players.size()}), true);
        }
        return players.size();
    }

    private static int spellsProgressionForget(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        ISpell spell = SpellArgument.getSpell(context, ARG_SPELL);
        if (players.size() == 0) {
            return 0;
        }
        players.stream().map(SpellProgressionHolder::getSpellProgressionHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellProgressionHolder -> {
            if (spellProgressionHolder.getSpellStatus(spell) == SpellStatus.LEARNED) {
                spellProgressionHolder.setSpellStatus(spell, SpellStatus.FORGOTTEN);
            }
            SpellHolder.getSpellHolder(spellProgressionHolder.getPlayer()).ifPresent(spellHolder -> {
                boolean changed = false;
                for (int i = 0; i < spellHolder.getSlots(); ++i) {
                    if (spellHolder.getSpell(i) != spell) continue;
                    spellHolder.setSpell(i, null);
                    changed = true;
                }
                if (changed) {
                    spellHolder.sendSync();
                }
            });
        }));
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_FORGET_SINGLE, (Object[])new Object[]{spell.getSpellName(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_FORGET_MULTIPLE, (Object[])new Object[]{spell.getSpellName(), players.size()}), true);
        }
        return players.size();
    }

    private static int spellsProgressionForgetAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.size() == 0) {
            return 0;
        }
        boolean single = players.size() == 1;
        AtomicInteger forgotten = new AtomicInteger(0);
        players.stream().map(SpellProgressionHolder::getSpellProgressionHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellProgressionHolder -> {
            SpellsUtil.forEachSpell((key, spell) -> {
                if (spellProgressionHolder.getSpellStatus((ISpell)spell) == SpellStatus.LEARNED) {
                    spellProgressionHolder.setSpellStatus((ISpell)spell, SpellStatus.FORGOTTEN);
                    if (single) {
                        forgotten.getAndIncrement();
                    }
                }
            });
            SpellHolder.getSpellHolder(spellProgressionHolder.getPlayer()).ifPresent(spellHolder -> {
                spellHolder.clear();
                spellHolder.sendSync();
            });
        }));
        if (single) {
            if (forgotten.get() > 0) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_FORGET_ALL_SINGLE, (Object[])new Object[]{forgotten.get(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_FORGET_ALL_SINGLE_FAILED, (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}));
            }
        } else {
            int amount = SpellsUtil.getSpellsAmount();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_FORGET_ALL_MULTIPLE, (Object[])new Object[]{amount, players.size()}), true);
        }
        return players.size();
    }

    private static int spellsProgressionReset(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.size() == 0) {
            return 0;
        }
        players.stream().map(SpellProgressionHolder::getSpellProgressionHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellProgressionHolder -> {
            ((HashMap)spellProgressionHolder.getProgression()).clear();
            SpellHolder.getSpellHolder(spellProgressionHolder.getPlayer()).ifPresent(spellHolder -> {
                spellHolder.clear();
                spellHolder.sendSync();
            });
        }));
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_RESET_SINGLE, (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_RESET_MULTIPLE, (Object[])new Object[]{players.size()}), true);
        }
        return 0;
    }

    private static int spellsSlotSet(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        int slot = IntegerArgumentType.getInteger(context, (String)ARG_SLOT);
        ISpell spell = SpellArgument.getSpell(context, ARG_SPELL);
        if (players.size() == 0) {
            return 0;
        }
        players.stream().map(SpellHolder::getSpellHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellHolder -> {
            spellHolder.setSpell(slot, spell);
            spellHolder.sendSync();
        }));
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_SET_SINGLE, (Object[])new Object[]{slot, ((ServerPlayer)players.iterator().next()).m_5446_(), spell.getSpellName()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_SET_MULTIPLE, (Object[])new Object[]{slot, players.size(), spell.getSpellName()}), true);
        }
        return players.size();
    }

    private static int spellsSlotRemove(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        int slot = IntegerArgumentType.getInteger(context, (String)ARG_SLOT);
        if (players.size() == 0) {
            return 0;
        }
        players.stream().map(SpellHolder::getSpellHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellHolder -> {
            spellHolder.setSpell(slot, null);
            spellHolder.sendSync();
        }));
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_REMOVE_SINGLE, (Object[])new Object[]{slot, ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_REMOVE_MULTIPLE, (Object[])new Object[]{slot, players.size()}), true);
        }
        return players.size();
    }

    private static int spellsSlotClear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.size() == 0) {
            return 0;
        }
        players.stream().map(SpellHolder::getSpellHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellHolder -> {
            spellHolder.clear();
            spellHolder.sendSync();
        }));
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_CLEAR_SINGLE, (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_CLEAR_MULTIPLE, (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }
}

