/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client.progression;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.client.progression.SpellNodeWidget;
import de.cas_ual_ty.spells.client.progression.SpellProgressionScreen;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spell.base.SpellIcon;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class SpellTreeTab
extends GuiComponent {
    public static ResourceLocation background = new ResourceLocation("textures/block/obsidian.png");
    private final Minecraft minecraft;
    private final SpellProgressionScreen screen;
    private final int index;
    private final SpellNode spellNode;
    private final SpellIcon icon;
    public final SpellTree spellTree;
    public final SpellNodeWidget root;
    public final Map<SpellNode, SpellNodeWidget> widgets = Maps.newLinkedHashMap();
    private double scrollX;
    private double scrollY;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private float fade;
    private int page;

    public SpellTreeTab(Minecraft minecraft, SpellProgressionScreen mainScreen, int index, SpellTree spellTree) {
        this.minecraft = minecraft;
        this.screen = mainScreen;
        this.index = index;
        this.spellTree = spellTree;
        this.spellNode = spellTree.getRoot();
        this.icon = spellTree.getIcon();
        spellTree.forEach(spellNode -> this.addNode((SpellNode)spellNode, ((SpellProgressionMenu)mainScreen.m_6262_()).spellProgression.getOrDefault(spellNode.getSpell(), SpellStatus.LOCKED)));
        this.root = this.widgets.get(spellTree.getRoot());
        this.fixPositions();
        this.minX = 91;
        this.maxX = 143;
        this.minY = 30;
        this.maxY = 82;
        int x1 = this.widgets.values().stream().mapToInt(SpellNodeWidget::getX).min().orElse(0);
        int x2 = this.widgets.values().stream().mapToInt(SpellNodeWidget::getX).max().orElse(0) + 26;
        int y1 = this.widgets.values().stream().mapToInt(SpellNodeWidget::getY).min().orElse(0);
        int y2 = this.widgets.values().stream().mapToInt(SpellNodeWidget::getY).max().orElse(0) + 26;
        int w = x2 - x1;
        int h = y2 - y1;
        this.minX -= w / 2;
        this.maxX -= w / 2;
        this.minY -= h / 2;
        this.maxY -= h / 2;
        int offX = (234 - w) / 2;
        offX = w > 234 ? offX : -offX;
        this.minX += offX;
        this.maxX -= offX;
        int offY = (113 - h) / 2;
        offY = h > 113 ? offY : -offY;
        this.minY += offY;
        this.maxY -= offY;
        this.scrollX = (float)(this.minX + this.maxX) / 2.0f;
        this.scrollY = h > 113 ? 0.0 : (double)((float)(this.minY + this.maxY) / 2.0f);
        this.scroll(0.0, 0.0);
    }

    public SpellTreeTab(Minecraft mc, SpellProgressionScreen screen, int index, int page, SpellTree spellTree) {
        this(mc, screen, index, spellTree);
        this.page = page;
    }

    public int getPage() {
        return this.page;
    }

    public int getIndex() {
        return this.index;
    }

    public SpellNode getSpellNode() {
        return this.spellNode;
    }

    public Component getTitle() {
        return this.spellTree.getTitle();
    }

    public List<Component> getTooltip(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return this.spellTree.getTooltip(spellProgressionHolder, access);
    }

    public void drawTab(PoseStack poseStack, int x, int y, boolean selected) {
        int i = 0;
        if (this.index > 0) {
            i += 28;
        }
        if (this.index == 7) {
            i += 28;
        }
        int j = selected ? 32 : 0;
        this.m_93228_(poseStack, x + 32 * this.index, y - 28, i, j, 28, 32);
    }

    public void drawIcon(PoseStack poseStack, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.icon.getTexture());
        int offX = (18 - this.icon.getWidth()) / 2;
        int offY = (18 - this.icon.getHeight()) / 2;
        SpellTreeTab.m_93160_((PoseStack)poseStack, (int)(x + 32 * this.index + 5 + offX), (int)(y - 28 + 9 + offY), (int)this.icon.getWidth(), (int)this.icon.getHeight(), (float)this.icon.getU(), (float)this.icon.getV(), (int)this.icon.getWidth(), (int)this.icon.getHeight(), (int)this.icon.getTextureWidth(), (int)this.icon.getTextureHeight());
    }

    public void drawContents(PoseStack poseStack) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 950.0);
        RenderSystem.m_69482_();
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        SpellTreeTab.m_93172_((PoseStack)poseStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69456_((int)518);
        poseStack.m_85837_(0.0, 0.0, -950.0);
        SpellTreeTab.m_93172_((PoseStack)poseStack, (int)234, (int)113, (int)0, (int)0, (int)-16777216);
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)background);
        int scrollX = Mth.m_14107_((double)this.scrollX);
        int scrollY = Mth.m_14107_((double)this.scrollY);
        int scrollX16 = scrollX % 16;
        int scrollY16 = scrollY % 16;
        for (int bgX = -1; bgX <= 15; ++bgX) {
            for (int bgY = -1; bgY <= 8; ++bgY) {
                SpellTreeTab.m_93133_((PoseStack)poseStack, (int)(scrollX16 + 16 * bgX), (int)(scrollY16 + 16 * bgY), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
        if (this.root != null) {
            this.root.drawBackgroundConnectivity(poseStack, scrollX, scrollY);
            this.root.drawLinkedConnectivity(poseStack, scrollX, scrollY, -1, s -> true);
            this.root.drawLinkedConnectivity(poseStack, scrollX, scrollY, -14447946, s -> s.parent.spellStatus.isAvailable());
            this.root.drawLinkedConnectivity(poseStack, scrollX, scrollY, -2511028, s -> s.parent.spellStatus.isAvailable() && s.spellStatus.isAvailable());
            this.root.draw(poseStack, scrollX, scrollY);
        }
        poseStack.m_85837_(0.0, 0.0, -950.0);
        RenderSystem.m_69456_((int)518);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        SpellTreeTab.m_93172_((PoseStack)poseStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69456_((int)515);
        poseStack.m_85849_();
    }

    public void drawTooltips(PoseStack poseStack, int mouseX, int mouseY, int offX, int offY) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, -200.0);
        SpellTreeTab.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)234, (int)113, (int)(Mth.m_14143_((float)(this.fade * 255.0f)) << 24));
        boolean found = false;
        int scrollX = Mth.m_14107_((double)this.scrollX);
        int scrollY = Mth.m_14107_((double)this.scrollY);
        if (mouseX > 0 && mouseX < 234 && mouseY > 0 && mouseY < 113) {
            for (SpellNodeWidget w : this.widgets.values()) {
                if (!w.isMouseOver(scrollX, scrollY, mouseX, mouseY)) continue;
                found = true;
                w.drawHover(poseStack, scrollX, scrollY, offX, offY);
                break;
            }
        }
        poseStack.m_85849_();
        this.fade = found ? Mth.m_14036_((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : Mth.m_14036_((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
    }

    public boolean isMouseOver(int x, int y, double mouseX, double mouseY) {
        int minX = x + 32 * this.index;
        int minY = y - 28;
        return mouseX > (double)minX && mouseX < (double)(minX + 28) && mouseY > (double)minY && mouseY < (double)(minY + 32);
    }

    public void scroll(double scrollX, double scrollY) {
        this.scrollX = Mth.m_14008_((double)(this.scrollX + scrollX), (double)this.minX, (double)this.maxX);
        this.scrollY = Mth.m_14008_((double)(this.scrollY + scrollY), (double)this.minY, (double)this.maxY);
    }

    public void addNode(SpellNode spellNode, SpellStatus spellStatus) {
        SpellNodeWidget spellNodeWidget = new SpellNodeWidget(this, spellNode, spellStatus);
        this.addWidget(spellNodeWidget, spellNode);
    }

    private void addWidget(SpellNodeWidget spellNodeWidget, SpellNode spellNode) {
        this.widgets.put(spellNode, spellNodeWidget);
        spellNodeWidget.attachToParent();
    }

    @Nullable
    public SpellNodeWidget getWidget(SpellNode spellNode) {
        return this.widgets.get(spellNode);
    }

    public SpellProgressionScreen getScreen() {
        return this.screen;
    }

    private void fixPositions() {
        if (this.root == null) {
            return;
        }
        float size = 40.0f;
        this.fixLeafPositions(0, 0, 40.0f, 1, this.root);
    }

    private int fixLeafPositions(int x, int y, float size, int increment, SpellNodeWidget widget) {
        if (widget.children.isEmpty()) {
            widget.fixPosition(Mth.m_14143_((float)((float)x * size)), Mth.m_14143_((float)((float)y * size)));
            x += increment;
        } else {
            for (SpellNodeWidget child : widget.children) {
                x = this.fixLeafPositions(x, y + increment, size, increment, child);
            }
            widget.fixPosition((widget.children.getFirst().getX() + widget.children.getLast().getX()) / 2, Mth.m_14143_((float)((float)y * size)));
        }
        return x;
    }

    public double getScrollX() {
        return this.scrollX;
    }

    public double getScrollY() {
        return this.scrollY;
    }
}

