/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client.progression;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cas_ual_ty.spells.client.progression.SpellNodeWidget;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spell.base.SpellIcon;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.util.ProgressionHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class SelectedSpellWidget
extends GuiComponent {
    protected int x;
    protected int y;
    protected int w;
    public boolean active = true;
    public final Font font;
    public SpellNode spell;
    public SpellStatus spellStatus;
    public SpellIcon spellTexture;
    public int frameIcon;
    public int titleIcon;
    public FormattedCharSequence title;

    public SelectedSpellWidget(int x, int y, int w) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public void setContents(SpellNode spell, Map<ISpell, SpellStatus> progression, SpellStatus spellStatus, FormattedCharSequence title) {
        this.spell = spell;
        this.spellStatus = spellStatus;
        this.title = title;
        this.spellTexture = spell.getSpell().getIcon();
        this.frameIcon = spellStatus == SpellStatus.FORGOTTEN ? 1 : 0;
        this.titleIcon = spellStatus == SpellStatus.LEARNED ? 0 : (ProgressionHelper.isFullyLinked(spell, progression) ? 1 : 2);
    }

    public void setClickedWidget(SpellNodeWidget clickedWidget) {
        this.setContents(clickedWidget.spell, ((SpellProgressionMenu)clickedWidget.tab.getScreen().m_6262_()).spellProgression, clickedWidget.spellStatus, clickedWidget.title);
    }

    public void drawHover(PoseStack poseStack, float deltaTick) {
        if (this.active) {
            int w1 = 60;
            int w2 = this.w - 60;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)SpellNodeWidget.WIDGETS_LOCATION);
            RenderSystem.m_69478_();
            int x = this.x;
            int y = this.y;
            this.m_93228_(poseStack, x, y, 0, this.titleIcon * 26, w1, 26);
            this.m_93228_(poseStack, x + w1, y, 200 - w2, this.titleIcon * 26, w2, 26);
            this.m_93228_(poseStack, this.x + 3, this.y, this.frameIcon * 26, 128 + (this.spellStatus.isAvailable() ? 0 : 1) * 26, 26, 26);
            this.font.m_92744_(poseStack, this.title, (float)(this.x + 32), (float)(this.y + 9), -1);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.spellTexture.getTexture());
            RenderSystem.m_69478_();
            int offX = (18 - this.spellTexture.getWidth()) / 2;
            int offY = (18 - this.spellTexture.getHeight()) / 2;
            SelectedSpellWidget.m_93160_((PoseStack)poseStack, (int)(this.x + 7 + offX), (int)(this.y + 4 + offY), (int)this.spellTexture.getWidth(), (int)this.spellTexture.getHeight(), (float)this.spellTexture.getU(), (float)this.spellTexture.getV(), (int)this.spellTexture.getWidth(), (int)this.spellTexture.getHeight(), (int)this.spellTexture.getTextureWidth(), (int)this.spellTexture.getTextureHeight());
            RenderSystem.m_69461_();
        }
    }

    public void drawTooltip(PoseStack poseStack, int mouseX, int mouseY, Screen screen) {
        ISpell spell;
        if (this.active && mouseX >= this.x && mouseX < this.x + this.w && mouseY >= this.y && mouseY < this.y + 26 && (spell = this.spell.getSpell()) != null) {
            RenderSystem.m_69482_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 400.0);
            List<Component> tooltip = spell.getTooltip(null);
            Optional<TooltipComponent> tooltipComponent = spell.getTooltipComponent();
            screen.m_169388_(poseStack, tooltip, tooltipComponent, mouseX, mouseY);
            poseStack.m_85849_();
        }
    }
}

