/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.jigsaw.assembler;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.StructureTemplatePoolAccessor;
import com.yungnickyoung.minecraft.yungsapi.util.BoxOctree;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.PieceEntry;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.assembler.PieceContext;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.IMaxCountJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.YungJigsawSinglePoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableObject;

public class JigsawStructureAssembler {
    private final Settings settings;
    private final List<PieceEntry> pieces = new ArrayList<PieceEntry>();
    public Deque<PieceEntry> unprocessedPieceEntries = Queues.newArrayDeque();
    private final Map<String, Integer> pieceCounts = new HashMap<String, Integer>();
    private final Map<String, Integer> maxPieceCounts = new HashMap<String, Integer>();

    public JigsawStructureAssembler(Settings settings) {
        this.settings = settings;
    }

    public void assembleStructure(PoolElementStructurePiece startPiece, BoxOctree structureBounds) {
        PieceEntry startPieceEntry = new PieceEntry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)structureBounds), null, 0, null, null, null);
        this.pieces.add(startPieceEntry);
        this.unprocessedPieceEntries.addLast(startPieceEntry);
        while (!this.unprocessedPieceEntries.isEmpty()) {
            PieceEntry entry = this.unprocessedPieceEntries.removeFirst();
            this.addChildrenForPiece(entry);
        }
        this.applyModifications();
    }

    public void addAllPiecesToStructureBuilder(StructurePiecesBuilder structurePiecesBuilder) {
        this.pieces.forEach(pieceEntry -> structurePiecesBuilder.m_142679_((StructurePiece)pieceEntry.getPiece()));
    }

    private void addChildrenForPiece(PieceEntry pieceEntry) {
        PieceContext pieceContext;
        PoolElementStructurePiece piece = pieceEntry.getPiece();
        MutableObject parentOctree = new MutableObject();
        List pieceJigsawBlocks = piece.m_209918_().m_213638_(this.settings.structureTemplateManager, piece.m_72646_(), piece.m_6830_(), this.settings.rand);
        boolean generatedAtLeastOneChildPiece = false;
        for (StructureTemplate.StructureBlockInfo jigsawBlockInfo : pieceJigsawBlocks) {
            ResourceLocation fallbackPoolId;
            Optional<StructureTemplatePool> fallbackPool;
            ResourceLocation targetPoolId = new ResourceLocation(jigsawBlockInfo.f_74677_.m_128461_("pool"));
            Optional<StructureTemplatePool> targetPool = this.getPoolFromId(targetPoolId);
            if (targetPool.isEmpty() || (fallbackPool = this.getPoolFromId(fallbackPoolId = targetPool.get().m_210573_())).isEmpty()) continue;
            pieceContext = this.createPieceContextForJigsawBlock(jigsawBlockInfo, pieceEntry, (MutableObject<BoxOctree>)parentOctree);
            Optional<Object> newlyGeneratedPiece = Optional.empty();
            if (pieceEntry.getDepth() != this.settings.maxDepth) {
                pieceContext.candidatePoolElements = new ObjectArrayList(((StructureTemplatePoolAccessor)targetPool.get()).getRawTemplates());
                newlyGeneratedPiece = this.chooseCandidateFromPool(pieceContext);
            }
            if (newlyGeneratedPiece.isEmpty()) {
                pieceContext.candidatePoolElements = new ObjectArrayList(((StructureTemplatePoolAccessor)fallbackPool.get()).getRawTemplates());
                newlyGeneratedPiece = this.chooseCandidateFromPool(pieceContext);
            }
            if (!newlyGeneratedPiece.isPresent()) continue;
            generatedAtLeastOneChildPiece = true;
        }
        if (pieceEntry.hasDeadendPool() && !generatedAtLeastOneChildPiece && pieceJigsawBlocks.size() > 1) {
            ResourceLocation deadendPoolId = ((YungJigsawSinglePoolElement)piece.m_209918_()).getDeadendPool();
            Optional deadendPool = this.settings.poolRegistry.m_6612_(deadendPoolId);
            if (deadendPool.isEmpty()) {
                YungsApiCommon.LOGGER.error("Unable to find deadend pool {} for element {}", (Object)deadendPoolId, (Object)piece.m_209918_());
                return;
            }
            PieceEntry parentEntry = pieceEntry.getParentEntry();
            PieceContext newContext = pieceEntry.getSourcePieceContext().copy();
            newContext.candidatePoolElements = new ObjectArrayList(((StructureTemplatePoolAccessor)deadendPool.get()).getRawTemplates());
            AABB pieceAabb = pieceEntry.getPieceAabb();
            if (parentEntry != null && pieceAabb != null) {
                IMaxCountJigsawPoolElement maxCountJigsawPoolElement;
                Object pieceName;
                parentEntry.getPiece().m_72648_().remove(pieceEntry.getParentJunction());
                ((BoxOctree)pieceEntry.getBoxOctree().getValue()).removeBox(pieceAabb);
                this.pieces.remove(pieceEntry);
                pieceContext = pieceEntry.getPiece().m_209918_();
                if (pieceContext instanceof YungJigsawSinglePoolElement) {
                    YungJigsawSinglePoolElement yungSingleElement = (YungJigsawSinglePoolElement)((Object)pieceContext);
                    if (yungSingleElement.maxCount.isPresent() && yungSingleElement.name.isPresent() && this.pieceCounts.containsKey(yungSingleElement.name.get())) {
                        pieceName = yungSingleElement.name.get();
                        this.pieceCounts.put((String)pieceName, this.pieceCounts.get(pieceName) - 1);
                    }
                }
                if ((pieceName = pieceEntry.getPiece().m_209918_()) instanceof IMaxCountJigsawPoolElement && this.pieceCounts.containsKey((maxCountJigsawPoolElement = (IMaxCountJigsawPoolElement)pieceName).getName())) {
                    pieceName = maxCountJigsawPoolElement.getName();
                    this.pieceCounts.put((String)pieceName, this.pieceCounts.get(pieceName) - 1);
                }
                this.chooseCandidateFromPool(newContext);
            }
        }
    }

    private Optional<StructureTemplatePool> getPoolFromId(ResourceLocation id) {
        Optional pool = this.settings.poolRegistry.m_6612_(id);
        if (pool.isEmpty() || ((StructureTemplatePool)pool.get()).m_210590_() == 0 && !Objects.equals(id, Pools.f_127186_.m_135782_())) {
            YungsApiCommon.LOGGER.warn("Empty or nonexistent pool: {}", (Object)id);
            return Optional.empty();
        }
        return pool;
    }

    private PieceContext createPieceContextForJigsawBlock(StructureTemplate.StructureBlockInfo jigsawBlockInfo, PieceEntry pieceEntry, MutableObject<BoxOctree> parentOctree) {
        BoundingBox pieceBoundingBox = pieceEntry.getPiece().m_73547_();
        MutableObject<BoxOctree> pieceOctree = pieceEntry.getBoxOctree();
        Direction direction = JigsawBlock.m_54250_((BlockState)jigsawBlockInfo.f_74676_);
        BlockPos jigsawBlockTargetPos = jigsawBlockInfo.f_74675_.m_121945_(direction);
        boolean isTargetInsideCurrentPiece = pieceBoundingBox.m_71051_((Vec3i)jigsawBlockTargetPos);
        if (isTargetInsideCurrentPiece) {
            pieceOctree = parentOctree;
            if (parentOctree.getValue() == null) {
                parentOctree.setValue((Object)new BoxOctree(AABB.m_82321_((BoundingBox)pieceBoundingBox)));
            }
        }
        return new PieceContext(null, jigsawBlockInfo, jigsawBlockTargetPos, pieceBoundingBox.m_162396_(), jigsawBlockInfo.f_74675_, pieceOctree, pieceEntry, pieceEntry.getDepth());
    }

    private Optional<StructurePoolElement> chooseCandidateFromPool(PieceContext context) {
        ObjectArrayList<Pair<StructurePoolElement, Integer>> candidatePoolElements = context.candidatePoolElements;
        PoolElementStructurePiece piece = context.pieceEntry.getPiece();
        boolean isPieceRigid = piece.m_209918_().m_210539_() == StructureTemplatePool.Projection.RIGID;
        int jigsawBlockRelativeY = context.jigsawBlockPos.m_123342_() - context.pieceMinY;
        int surfaceHeight = -1;
        Util.m_214673_(candidatePoolElements, (RandomSource)this.settings.rand);
        int totalWeightSum = candidatePoolElements.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
        while (candidatePoolElements.size() > 0 && totalWeightSum > 0) {
            YungJigsawSinglePoolElement yungSingleElement;
            Pair chosenPoolElementPair = null;
            for (Pair candidatePiecePair : candidatePoolElements) {
                YungJigsawSinglePoolElement yungSingleElement2;
                StructurePoolElement candidatePiece = (StructurePoolElement)candidatePiecePair.getFirst();
                if (!(candidatePiece instanceof YungJigsawSinglePoolElement) || !(yungSingleElement2 = (YungJigsawSinglePoolElement)candidatePiece).isPriorityPiece()) continue;
                chosenPoolElementPair = candidatePiecePair;
                break;
            }
            if (chosenPoolElementPair == null) {
                Pair candidatePiecePair;
                int chosenWeight = this.settings.rand.m_188503_(totalWeightSum) + 1;
                candidatePiecePair = candidatePoolElements.iterator();
                while (candidatePiecePair.hasNext()) {
                    Pair candidate = (Pair)candidatePiecePair.next();
                    if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                    chosenPoolElementPair = candidate;
                    break;
                }
            }
            StructurePoolElement chosenPoolElement = (StructurePoolElement)chosenPoolElementPair.getFirst();
            int chosenPieceWeight = (Integer)chosenPoolElementPair.getSecond();
            if (chosenPoolElement == EmptyPoolElement.f_210175_) {
                return Optional.empty();
            }
            if (chosenPoolElement instanceof YungJigsawSinglePoolElement) {
                yungSingleElement = (YungJigsawSinglePoolElement)chosenPoolElement;
                if (yungSingleElement.maxCount.isPresent()) {
                    int pieceMaxCount = yungSingleElement.maxCount.get();
                    if (yungSingleElement.name.isEmpty()) {
                        YungsApiCommon.LOGGER.error("Found YUNG Jigsaw piece with max_count={} missing \"name\" property.", (Object)pieceMaxCount);
                        YungsApiCommon.LOGGER.error("Max count pieces must be named in order to work properly!");
                        YungsApiCommon.LOGGER.error("Ignoring max_count for this piece...");
                    } else {
                        String pieceName = yungSingleElement.name.get();
                        if (this.maxPieceCounts.containsKey(pieceName) && this.maxPieceCounts.get(pieceName) != pieceMaxCount) {
                            YungsApiCommon.LOGGER.error("YUNG Jigsaw Piece with name {} and max_count {} does not match stored max_count of {}!", (Object)pieceName, (Object)pieceMaxCount, (Object)this.maxPieceCounts.get(pieceName));
                            YungsApiCommon.LOGGER.error("This can happen when multiple pieces across pools use the same name, but have different max_count values.");
                            YungsApiCommon.LOGGER.error("Please change these max_count values to match. Using max_count={} for now...", (Object)pieceMaxCount);
                        }
                        this.maxPieceCounts.put(pieceName, pieceMaxCount);
                        if (this.pieceCounts.getOrDefault(pieceName, 0) >= pieceMaxCount) {
                            totalWeightSum -= chosenPieceWeight;
                            candidatePoolElements.remove((Object)chosenPoolElementPair);
                            continue;
                        }
                    }
                }
            }
            if (chosenPoolElement instanceof IMaxCountJigsawPoolElement) {
                String pieceName = ((IMaxCountJigsawPoolElement)chosenPoolElement).getName();
                int maxCount = ((IMaxCountJigsawPoolElement)chosenPoolElement).getMaxCount();
                if (this.maxPieceCounts.containsKey(pieceName) && this.maxPieceCounts.get(pieceName) != maxCount) {
                    YungsApiCommon.LOGGER.error("Max Count Jigsaw Piece with name {} and max_count {} does not match stored max_count of {}!", (Object)pieceName, (Object)maxCount, (Object)this.maxPieceCounts.get(pieceName));
                    YungsApiCommon.LOGGER.error("This can happen when multiple pieces across pools use the same name, but have different max_count values.");
                    YungsApiCommon.LOGGER.error("Please change these max_count values to match. Using max_count={} for now...", (Object)maxCount);
                }
                this.maxPieceCounts.put(pieceName, maxCount);
                if (this.pieceCounts.getOrDefault(pieceName, 0) >= maxCount) {
                    totalWeightSum -= ((Integer)chosenPoolElementPair.getSecond()).intValue();
                    candidatePoolElements.remove((Object)chosenPoolElementPair);
                    continue;
                }
            }
            if (chosenPoolElement instanceof YungJigsawSinglePoolElement && !(yungSingleElement = (YungJigsawSinglePoolElement)chosenPoolElement).isAtValidDepth(context.depth)) {
                totalWeightSum -= chosenPieceWeight;
                candidatePoolElements.remove((Object)chosenPoolElementPair);
                continue;
            }
            for (Rotation rotation : Rotation.m_221992_((RandomSource)this.settings.rand)) {
                List candidateJigsawBlocks = chosenPoolElement.m_213638_(this.settings.structureTemplateManager, BlockPos.f_121853_, rotation, this.settings.rand);
                BoundingBox tempCandidateBoundingBox = chosenPoolElement.m_214015_(this.settings.structureTemplateManager, BlockPos.f_121853_, rotation);
                int candidateHeightAdjustments = 0;
                if (this.settings.useExpansionHack && tempCandidateBoundingBox.m_71057_() <= 16) {
                    candidateHeightAdjustments = candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.m_71051_((Vec3i)pieceCandidateJigsawBlock.f_74675_.m_121945_(JigsawBlock.m_54250_((BlockState)pieceCandidateJigsawBlock.f_74676_)))) {
                            return 0;
                        }
                        ResourceLocation candidateTargetPool = new ResourceLocation(pieceCandidateJigsawBlock.f_74677_.m_128461_("pool"));
                        Optional candidateTargetPoolOptional = this.settings.poolRegistry.m_6612_(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(StructureTemplatePool2 -> this.settings.poolRegistry.m_6612_(StructureTemplatePool2.m_210573_()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(structureTemplatePool -> structureTemplatePool.m_227357_(this.settings.structureTemplateManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(structureTemplatePool -> structureTemplatePool.m_227357_(this.settings.structureTemplateManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0);
                }
                for (StructureTemplate.StructureBlockInfo candidateJigsawBlock : candidateJigsawBlocks) {
                    StructureContext ctx;
                    YungJigsawSinglePoolElement yungSingleElement3;
                    int candidateJigsawBlockY;
                    int adjustedCandidatePieceMinY;
                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)context.jigsawBlock, (StructureTemplate.StructureBlockInfo)candidateJigsawBlock)) continue;
                    BlockPos candidateJigsawBlockPos = candidateJigsawBlock.f_74675_;
                    BlockPos candidateJigsawBlockRelativePos = context.jigsawBlockTargetPos.m_121996_((Vec3i)candidateJigsawBlockPos);
                    BoundingBox rotatedCandidateBoundingBox = chosenPoolElement.m_214015_(this.settings.structureTemplateManager, candidateJigsawBlockRelativePos, rotation);
                    StructureTemplatePool.Projection candidateProjection = chosenPoolElement.m_210539_();
                    boolean isCandidateRigid = candidateProjection == StructureTemplatePool.Projection.RIGID;
                    int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.m_123342_();
                    int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + JigsawBlock.m_54250_((BlockState)context.jigsawBlock.f_74676_).m_122430_();
                    if (isPieceRigid && isCandidateRigid) {
                        adjustedCandidatePieceMinY = context.pieceMinY + candidateJigsawYOffsetNeeded;
                    } else {
                        if (surfaceHeight == -1) {
                            surfaceHeight = this.settings.chunkGenerator.m_223221_(context.jigsawBlockPos.m_123341_(), context.jigsawBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, this.settings.levelHeightAccessor, this.settings.randomState);
                        }
                        adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                    }
                    int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - rotatedCandidateBoundingBox.m_162396_();
                    BoundingBox adjustedCandidateBoundingBox = rotatedCandidateBoundingBox.m_71045_(0, candidatePieceYOffsetNeeded, 0);
                    BlockPos adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.m_7918_(0, candidatePieceYOffsetNeeded, 0);
                    if (candidateHeightAdjustments > 0) {
                        int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.m_162400_() - adjustedCandidateBoundingBox.m_162396_());
                        ((BoundingBoxAccessor)adjustedCandidateBoundingBox).setMaxY(adjustedCandidateBoundingBox.m_162396_() + k2);
                    }
                    if (this.settings.maxY.isPresent() && adjustedCandidateBoundingBox.m_162400_() > this.settings.maxY.get() || this.settings.minY.isPresent() && adjustedCandidateBoundingBox.m_162396_() < this.settings.minY.get()) continue;
                    AABB aabb = AABB.m_82321_((BoundingBox)adjustedCandidateBoundingBox);
                    AABB aabbDeflated = aabb.m_82406_(0.25);
                    boolean pieceIgnoresBounds = false;
                    if (chosenPoolElement instanceof YungJigsawSinglePoolElement) {
                        YungJigsawSinglePoolElement yungSingleElement4 = (YungJigsawSinglePoolElement)chosenPoolElement;
                        pieceIgnoresBounds = yungSingleElement4.ignoresBounds();
                    }
                    if (!pieceIgnoresBounds) {
                        boolean pieceIntersectsExistingPieces = ((BoxOctree)context.boxOctree.getValue()).intersectsAnyBox(aabbDeflated);
                        boolean pieceIsContainedWithinStructureBoundaries = ((BoxOctree)context.boxOctree.getValue()).boundaryContains(aabbDeflated);
                        if (pieceIntersectsExistingPieces || !pieceIsContainedWithinStructureBoundaries) continue;
                    }
                    int newPieceGroundLevelDelta = piece.m_72647_();
                    int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : chosenPoolElement.m_210540_();
                    if (isPieceRigid) {
                        candidateJigsawBlockY = context.pieceMinY + jigsawBlockRelativeY;
                    } else if (isCandidateRigid) {
                        candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                    } else {
                        if (surfaceHeight == -1) {
                            surfaceHeight = this.settings.chunkGenerator.m_223221_(context.jigsawBlockPos.m_123341_(), context.jigsawBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, this.settings.levelHeightAccessor, this.settings.randomState);
                        }
                        candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                    }
                    PoolElementStructurePiece newPiece = new PoolElementStructurePiece(this.settings.structureTemplateManager, chosenPoolElement, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                    JigsawJunction newJunctionOnParent = new JigsawJunction(context.jigsawBlockTargetPos.m_123341_(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, context.jigsawBlockTargetPos.m_123343_(), candidateJigsawYOffsetNeeded, candidateProjection);
                    PieceEntry newPieceEntry = new PieceEntry(newPiece, context.boxOctree, aabb, context.depth + 1, context.pieceEntry, context.copy(), newJunctionOnParent);
                    if (chosenPoolElement instanceof YungJigsawSinglePoolElement && !(yungSingleElement3 = (YungJigsawSinglePoolElement)chosenPoolElement).passesConditions(ctx = new StructureContext.Builder().structureTemplateManager(this.settings.structureTemplateManager).pieces(this.pieces).pieceEntry(newPieceEntry).pos(adjustedCandidateJigsawBlockRelativePos).rotation(rotation).pieceMinY(adjustedCandidateBoundingBox.m_162396_()).pieceMaxY(adjustedCandidateBoundingBox.m_162400_()).depth(context.depth + 1).random(this.settings.rand).build())) continue;
                    piece.m_209916_(newJunctionOnParent);
                    newPiece.m_209916_(new JigsawJunction(context.jigsawBlockPos.m_123341_(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, context.jigsawBlockPos.m_123343_(), -candidateJigsawYOffsetNeeded, piece.m_209918_().m_210539_()));
                    ((BoxOctree)context.boxOctree.getValue()).addBox(aabb);
                    this.pieces.add(newPieceEntry);
                    context.pieceEntry.addChildEntry(newPieceEntry);
                    if (context.depth + 1 <= this.settings.maxDepth) {
                        this.unprocessedPieceEntries.addLast(newPieceEntry);
                    }
                    if (chosenPoolElement instanceof YungJigsawSinglePoolElement) {
                        yungSingleElement3 = (YungJigsawSinglePoolElement)chosenPoolElement;
                        if (yungSingleElement3.maxCount.isPresent()) {
                            if (yungSingleElement3.name.isEmpty()) {
                                return Optional.of(chosenPoolElement);
                            }
                            String pieceName = yungSingleElement3.name.get();
                            this.pieceCounts.put(pieceName, this.pieceCounts.getOrDefault(pieceName, 0) + 1);
                        }
                    }
                    if (chosenPoolElement instanceof IMaxCountJigsawPoolElement) {
                        String pieceName = ((IMaxCountJigsawPoolElement)chosenPoolElement).getName();
                        this.pieceCounts.put(pieceName, this.pieceCounts.getOrDefault(pieceName, 0) + 1);
                    }
                    return Optional.of(chosenPoolElement);
                }
            }
            totalWeightSum -= chosenPieceWeight;
            candidatePoolElements.remove((Object)chosenPoolElementPair);
        }
        return Optional.empty();
    }

    private void applyModifications() {
        for (PieceEntry pieceEntry : this.pieces) {
            YungJigsawSinglePoolElement yungElement;
            StructurePoolElement structurePoolElement = pieceEntry.getPiece().m_209918_();
            if (!(structurePoolElement instanceof YungJigsawSinglePoolElement) || !(yungElement = (YungJigsawSinglePoolElement)structurePoolElement).hasModifiers()) continue;
            PoolElementStructurePiece piece = pieceEntry.getPiece();
            StructureContext structureContext = new StructureContext.Builder().pos(piece.m_72646_()).rotation(piece.m_6830_()).depth(pieceEntry.getDepth()).structureTemplateManager(this.settings.structureTemplateManager).pieceEntry(pieceEntry).pieces(this.pieces).pieceMaxY(piece.m_73547_().m_162400_()).pieceMinY(piece.m_73547_().m_162396_()).random(this.settings.rand).build();
            yungElement.modifiers.forEach(modifier -> modifier.apply(structureContext));
        }
        List<PieceEntry> delayedEntries = this.pieces.stream().filter(PieceEntry::isDelayGeneration).toList();
        this.pieces.removeAll(delayedEntries);
        this.pieces.addAll(delayedEntries);
    }

    public static class Settings {
        private Registry<StructureTemplatePool> poolRegistry;
        private int maxDepth;
        private ChunkGenerator chunkGenerator;
        private StructureTemplateManager structureTemplateManager;
        private LevelHeightAccessor levelHeightAccessor;
        private RandomSource rand;
        private boolean useExpansionHack;
        public RandomState randomState;
        private Optional<Integer> maxY;
        private Optional<Integer> minY;

        public Settings poolRegistry(Registry<StructureTemplatePool> poolRegistry) {
            this.poolRegistry = poolRegistry;
            return this;
        }

        public Settings maxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Settings chunkGenerator(ChunkGenerator chunkGenerator) {
            this.chunkGenerator = chunkGenerator;
            return this;
        }

        public Settings structureTemplateManager(StructureTemplateManager structureTemplateManager) {
            this.structureTemplateManager = structureTemplateManager;
            return this;
        }

        public Settings randomState(RandomState randomState) {
            this.randomState = randomState;
            return this;
        }

        public Settings rand(RandomSource rand) {
            this.rand = rand;
            return this;
        }

        public Settings useExpansionHack(boolean useExpansionHack) {
            this.useExpansionHack = useExpansionHack;
            return this;
        }

        public Settings levelHeightAccessor(LevelHeightAccessor levelHeightAccessor) {
            this.levelHeightAccessor = levelHeightAccessor;
            return this;
        }

        public Settings maxY(Optional<Integer> maxY) {
            this.maxY = maxY;
            return this;
        }

        public Settings minY(Optional<Integer> minY) {
            this.minY = minY;
            return this;
        }
    }
}

