/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterCreativeTab;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;

public class CreativeModeTabModuleForge {
    private static final Map<String, AutoRegisterCreativeTab> initializedTabs = new HashMap<String, AutoRegisterCreativeTab>();

    public static void processEntries() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.HIGHEST, CreativeModeTabModuleForge::initializeTabs);
    }

    private static void initializeTabs(RegisterEvent event) {
        event.register(Registry.f_122901_, helper -> AutoRegistrationManager.CREATIVE_MODE_TABS.stream().filter(data -> !data.processed()).forEach(CreativeModeTabModuleForge::initializeTab));
    }

    private static void initializeTab(AutoRegisterField data) {
        ResourceLocation resourceLocation = data.name();
        String name = String.format("%s.%s", resourceLocation.m_135827_(), resourceLocation.m_135815_());
        if (initializedTabs.containsKey(name)) {
            return;
        }
        AutoRegisterCreativeTab autoRegisterCreativeTab = (AutoRegisterCreativeTab)data.object();
        final Supplier<ItemStack> itemStackSupplier = autoRegisterCreativeTab.getIconItemStackSupplier();
        CreativeModeTab creativeModeTab = new CreativeModeTab(name){

            public ItemStack m_6976_() {
                return (ItemStack)itemStackSupplier.get();
            }
        };
        autoRegisterCreativeTab.setSupplier(() -> creativeModeTab);
        initializedTabs.put(name, autoRegisterCreativeTab);
        data.markProcessed();
    }
}

