/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DatagenLootTableManager
extends LootTables {
    private static final Gson GSON = Deserializers.m_78800_().create();
    private final ExistingFileHelper existingFileHelper;
    private final Map<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();

    public DatagenLootTableManager(@NotNull ExistingFileHelper existingFileHelper) {
        super(new PredicateManager());
        this.existingFileHelper = existingFileHelper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public LootTable m_79217_(@NotNull ResourceLocation location) {
        LootTable table = this.tables.get(location);
        if (table != null) {
            return table;
        }
        try {
            Resource resource = this.existingFileHelper.getResource(this.getPreparedPath(location), PackType.SERVER_DATA);
            try (InputStream inputstream = resource.m_215507_();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                JsonElement jsonobject = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                LootTable loottable = ForgeHooks.loadLootTable((Gson)GSON, (ResourceLocation)location, (JsonElement)jsonobject, (boolean)false, (LootTables)this);
                if (loottable == null) return LootTable.f_79105_;
                this.tables.put(location, loottable);
                LootTable lootTable = loottable;
                return lootTable;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return LootTable.f_79105_;
    }
}

