/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.datalistener.CitizenNameListener;
import com.minecolonies.coremod.datalistener.CrafterRecipeListener;
import com.minecolonies.coremod.datalistener.CustomVisitorListener;
import com.minecolonies.coremod.datalistener.ResearchListener;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.network.messages.client.ServerUUIDMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class FMLEventHandler {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        IColonyManager.getInstance().onServerTick(event);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        IColonyManager.getInstance().onClientTick(event);
    }

    @SubscribeEvent
    public static void onPlayerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            Network.getNetwork().sendToPlayer(new ServerUUIDMessage(), (ServerPlayer)event.getEntity());
            IColonyManager.getInstance().getIColonyByOwner((Level)((ServerPlayer)event.getEntity()).m_9236_(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onAddReloadListenerEvent(@NotNull AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new CrafterRecipeListener());
        event.addListener((PreparableReloadListener)new ResearchListener());
        event.addListener((PreparableReloadListener)new CustomVisitorListener());
        event.addListener((PreparableReloadListener)new CitizenNameListener());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        IColonyManager.getInstance().onWorldTick(event);
    }

    @SubscribeEvent
    public static void onServerAboutToStart(@NotNull ServerAboutToStartEvent event) {
        IColonyManager.getInstance().getRecipeManager().reset();
    }

    @SubscribeEvent
    public static void onServerStopped(@NotNull ServerStoppingEvent event) {
        Pathfinding.shutdown();
    }
}

