/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.SurfaceType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.entity.pathfinding.MNode;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobRandomPos
extends AbstractPathJob {
    @NotNull
    protected final BlockPos destination;
    protected final int minDistFromStart;
    private static final RandomSource random = RandomSource.m_216337_();
    private final int maxDistToDest;

    public PathJobRandomPos(Level world, @NotNull BlockPos start, int minDistFromStart, int range, LivingEntity entity) {
        super(world, start, start, range, new PathResult(), entity);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = -1;
        Tuple<Direction, Direction> dir = BlockPosUtil.getRandomDirectionTuple(random);
        this.destination = start.m_5484_((Direction)dir.m_14418_(), minDistFromStart).m_5484_((Direction)dir.m_14419_(), minDistFromStart);
    }

    public PathJobRandomPos(Level world, @NotNull BlockPos start, int minDistFromStart, int searchRange, int maxDistToDest, LivingEntity entity, @NotNull BlockPos dest) {
        super(world, start, dest, searchRange, new PathResult(), entity);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = maxDistToDest;
        this.destination = dest;
    }

    public PathJobRandomPos(Level world, @NotNull BlockPos start, int minDistFromStart, int range, LivingEntity entity, BlockPos startRestriction, BlockPos endRestriction, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        super(world, start, startRestriction, endRestriction, range, false, new PathResult(), entity, restrictionType);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = -1;
        Tuple<Direction, Direction> dir = BlockPosUtil.getRandomDirectionTuple(random);
        this.destination = start.m_5484_((Direction)dir.m_14418_(), minDistFromStart).m_5484_((Direction)dir.m_14419_(), minDistFromStart);
    }

    @Override
    @Nullable
    protected Path search() {
        if ((Integer)MineColonies.getConfig().getServer().pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] in the direction of [%d,%d,%d]", this.start.m_123341_(), this.start.m_123342_(), this.start.m_123343_(), this.destination.m_123341_(), this.destination.m_123342_(), this.destination.m_123343_()));
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        return Math.sqrt(this.destination.m_123331_((Vec3i)new BlockPos(pos.m_123341_(), this.destination.m_123342_(), pos.m_123343_())));
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        return random.m_188503_(10) == 0 && this.isInRestrictedArea(n.pos) && this.start.m_123331_((Vec3i)n.pos) > (double)(this.minDistFromStart * this.minDistFromStart) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.world.m_8055_(n.pos.m_7495_()), n.pos.m_7495_()) == SurfaceType.WALKABLE && (this.maxDistToDest == -1 || this.destination.m_123331_((Vec3i)n.pos) < (double)(this.maxDistToDest * this.maxDistToDest)) && !SurfaceType.isWater((BlockGetter)this.world, n.pos.m_7495_());
    }

    @Override
    protected double getNodeResultScore(@NotNull MNode n) {
        return 0.0;
    }

    public boolean posAndRangeMatch(int range, BlockPos pos) {
        return this.destination != null && pos != null && range == this.maxDistToDest && this.destination.equals((Object)pos);
    }
}

