/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.util;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingStructureHandler<J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder>
extends AbstractStructureHandler {
    private static final double XP_EACH_BLOCK = 0.05;
    private final AbstractEntityAIStructure<J, B> structureAI;
    private final Stage[] stages;
    private IBuilding building;
    private int stage;

    public BuildingStructureHandler(Level world, BlockPos worldPos, Future<Blueprint> blueprintFuture, PlacementSettings settings, AbstractEntityAIStructure<J, B> entityAIStructure, Stage[] stages) {
        super(world, worldPos, blueprintFuture, settings);
        this.setupBuilding();
        this.structureAI = entityAIStructure;
        this.stages = stages;
        this.stage = 0;
    }

    public BuildingStructureHandler(Level world, BlockPos worldPos, Blueprint blueprint, PlacementSettings settings, AbstractEntityAIStructure<J, B> entityAIStructure, Stage[] stages) {
        super(world, worldPos, blueprint, settings);
        this.setupBuilding();
        this.structureAI = entityAIStructure;
        this.stages = stages;
        this.stage = 0;
    }

    private void setupBuilding() {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(this.getWorld(), this.getWorldPos());
        if (colony != null) {
            this.building = colony.getBuildingManager().getBuilding(this.getWorldPos());
        }
    }

    @Nullable
    public Stage getStage() {
        if (this.stage >= this.stages.length) {
            return null;
        }
        return this.stages[this.stage];
    }

    public boolean nextStage() {
        return ++this.stage < this.stages.length;
    }

    public void setStage(Stage stage) {
        for (int i = 0; i < this.stages.length; ++i) {
            if (this.stages[i] != stage) continue;
            this.stage = i;
            return;
        }
    }

    public void prePlacementLogic(BlockPos worldPos, BlockState blockState, List<ItemStack> requiredItems) {
        WorkerUtil.faceBlock(worldPos, this.structureAI.getWorker());
        this.structureAI.getWorker().m_8061_(EquipmentSlot.MAINHAND, requiredItems.isEmpty() ? ItemStackUtils.EMPTY : requiredItems.get(0));
        if (Mth.m_14107_((double)this.structureAI.getWorker().m_20185_()) == worldPos.m_123341_() && Mth.m_14040_((int)(worldPos.m_123342_() - (int)this.structureAI.getWorker().m_20186_())) <= 1 && Mth.m_14107_((double)this.structureAI.getWorker().m_20189_()) == worldPos.m_123343_() && this.structureAI.getWorker().getNavigation().m_26571_()) {
            this.structureAI.getWorker().getNavigation().moveAwayFromXYZ(worldPos, 4.1, 1.0, true);
        }
        this.structureAI.getWorker().m_6674_(InteractionHand.MAIN_HAND);
    }

    @Nullable
    public IItemHandler getInventory() {
        return this.structureAI.getWorker().getInventoryCitizen();
    }

    public void triggerSuccess(BlockPos pos, List<ItemStack> list, boolean placement) {
        BlockPos worldPos = this.getProgressPosInWorld(pos);
        BlockState state = this.getBluePrint().getBlockState(pos);
        if (this.building != null) {
            this.building.registerBlockPosition(this.getBluePrint().getBlockState(pos), worldPos, this.getWorld());
        }
        if (placement) {
            this.structureAI.getWorker().getCitizenExperienceHandler().addExperience(0.05);
            for (ItemStack stack : list) {
                this.structureAI.reduceNeededResources(stack);
                this.structureAI.getWorker().getCitizenColonyHandler().getColony().getStatisticsManager().increment("blocks_placed");
            }
        }
        if (state.m_60734_() == ModBlocks.blockWayPoint) {
            this.structureAI.getWorker().getCitizenColonyHandler().getColony().addWayPoint(worldPos, state);
        }
    }

    public void triggerEntitySuccess(BlockPos blockPos, List<ItemStack> list, boolean placement) {
        if (placement) {
            this.structureAI.getWorker().getCitizenExperienceHandler().addExperience(0.05);
            for (ItemStack stack : list) {
                this.structureAI.reduceNeededResources(stack);
            }
        }
    }

    public boolean hasRequiredItems(@NotNull List<ItemStack> requiredItems) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (ItemStack stack : requiredItems) {
            if (ItemStackUtils.isTool(stack, ToolType.FLINT_N_STEEL) && this.structureAI.checkForToolOrWeapon(ToolType.FLINT_N_STEEL)) {
                return false;
            }
            itemList.add(stack);
        }
        return AbstractEntityAIStructure.hasListOfResInInvOrRequest(this.structureAI, itemList, itemList.size() > 1) == AbstractEntityAIStructure.ItemCheckResult.SUCCESS;
    }

    public boolean isCreative() {
        return Constants.BUILDER_INF_RESOURECES;
    }

    public int getStepsPerCall() {
        return 1;
    }

    public int getMaxBlocksCheckedPerCall() {
        return 10000;
    }

    public boolean isStackFree(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.m_41619_() || itemStack.m_204117_(ItemTags.f_13143_) || itemStack.m_41720_() == new ItemStack(ModBlocks.blockDecorationPlaceholder, 1).m_41720_();
    }

    public boolean allowReplace() {
        return this.getStage() != null && this.getStage() != Stage.CLEAR;
    }

    public ItemStack getHeldItem() {
        return this.structureAI.getWorker().m_21205_();
    }

    public BlockState getSolidBlockForPos(BlockPos blockPos) {
        return this.structureAI.getSolidSubstitution(blockPos);
    }

    public BlockState getSolidBlockForPos(BlockPos worldPos, @Nullable Function<BlockPos, BlockState> virtualBlocks) {
        return this.structureAI.getSolidSubstitution(worldPos);
    }

    public boolean replaceWithSolidBlock(BlockState blockState) {
        return !blockState.m_60767_().m_76333_() || this.structureAI.shallReplaceSolidSubstitutionBlock(blockState.m_60734_(), blockState);
    }

    public boolean fancyPlacement() {
        return true;
    }

    public boolean shouldBlocksBeConsideredEqual(BlockState state1, BlockState state2) {
        Block block1 = state1.m_60734_();
        Block block2 = state2.m_60734_();
        if (block1 == Blocks.f_50276_ || block2 == Blocks.f_50276_) {
            return block1 == block2;
        }
        return block1 == Blocks.f_50440_ && block2 == Blocks.f_50493_ || block2 == Blocks.f_50440_ && block1 == Blocks.f_50493_;
    }

    public static enum Stage {
        CLEAR,
        BUILD_SOLID,
        CLEAR_WATER,
        CLEAR_NON_SOLIDS,
        DECORATE,
        SPAWN,
        REMOVE,
        REMOVE_WATER;

    }
}

