/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinerLevel {
    private static final String TAG_DEPTH = "Depth";
    private static final String TAG_NODES = "Nodes";
    private static final String TAG_LADDERX = "LadderX";
    private static final String TAG_LADDERZ = "LadderZ";
    private static final String TAG_OPEN_NODES = "OpenNodes";
    private static final String TAG_LEVEL_SIGN = "LevelSign";
    private static final int ROTATE_ONCE = 1;
    private static final int ROTATE_TWICE = 2;
    private static final int ROTATE_THREE_TIMES = 3;
    private static final int MAX_ROTATIONS = 4;
    private static final Random rand = new Random();
    private static final int RANDOM_TYPES = 4;
    private static final int MINIMUM_NODES_FOR_RANDOM = 10;
    @NotNull
    private final Map<Vec2i, Node> nodes = new HashMap<Vec2i, Node>();
    @NotNull
    private final Queue<Node> openNodes = new ArrayDeque<Node>(11);
    private final int depth;
    private final Node ladderNode;
    @Nullable
    private BlockPos levelSign;
    private static final int BUILT_NODES_OFFSET = -2;

    public MinerLevel(@NotNull BuildingMiner buildingMiner, int depth, BlockPos levelSign) {
        this.depth = depth;
        this.levelSign = levelSign;
        int cobbleX = buildingMiner.getCobbleLocation().m_123341_();
        int cobbleZ = buildingMiner.getCobbleLocation().m_123343_();
        BlockPos vector = buildingMiner.getLadderLocation().m_121996_((Vec3i)buildingMiner.getCobbleLocation());
        @NotNull Vec2i cobbleCenter = new Vec2i(cobbleX - vector.m_123341_() * 3, cobbleZ - vector.m_123343_() * 3);
        @NotNull Vec2i ladderCenter = new Vec2i(cobbleX + vector.m_123341_() * 4, cobbleZ + vector.m_123343_() * 4);
        @NotNull Node cobbleNode = new Node(cobbleCenter.getX(), cobbleCenter.getZ(), ladderCenter);
        cobbleNode.setStyle(Node.NodeType.LADDER_BACK);
        cobbleNode.setStatus(Node.NodeStatus.COMPLETED);
        this.nodes.put(cobbleCenter, cobbleNode);
        this.ladderNode = new Node(ladderCenter.getX(), ladderCenter.getZ(), null);
        this.ladderNode.setStyle(Node.NodeType.SHAFT);
        this.ladderNode.setStatus(Node.NodeStatus.COMPLETED);
        this.nodes.put(ladderCenter, this.ladderNode);
        ArrayList<Vec2i> nodeCenterList = new ArrayList<Vec2i>(4);
        nodeCenterList.add(this.ladderNode.getNorthNodeCenter());
        nodeCenterList.add(this.ladderNode.getSouthNodeCenter());
        nodeCenterList.add(this.ladderNode.getEastNodeCenter());
        nodeCenterList.add(this.ladderNode.getWestNodeCenter());
        for (Vec2i pos : nodeCenterList) {
            if (cobbleCenter.equals(pos) || ladderCenter.equals(pos)) continue;
            Node tempNode = new Node(pos.getX(), pos.getZ(), ladderCenter);
            tempNode.setStyle(Node.NodeType.TUNNEL);
            this.nodes.put(pos, tempNode);
            this.openNodes.add(tempNode);
        }
    }

    public MinerLevel(@NotNull CompoundTag compound) {
        int ladderZ;
        int ladderX;
        this.depth = compound.m_128451_(TAG_DEPTH);
        this.levelSign = compound.m_128431_().contains(TAG_LEVEL_SIGN) ? BlockPosUtil.read(compound, TAG_LEVEL_SIGN) : null;
        ListTag nodeTagList = compound.m_128437_(TAG_NODES, 10);
        for (int i = 0; i < nodeTagList.size(); ++i) {
            @NotNull Node node = Node.createFromNBT(nodeTagList.m_128728_(i));
            this.nodes.put(new Vec2i(node.getX(), node.getZ()), node);
        }
        boolean hasDoubles = compound.m_128431_().contains(TAG_LADDERX);
        if (hasDoubles) {
            ladderX = (int)Math.floor(compound.m_128459_(TAG_LADDERX));
            ladderZ = (int)Math.floor(compound.m_128459_(TAG_LADDERZ));
        } else {
            ladderX = compound.m_128451_(TAG_LADDERX);
            ladderZ = compound.m_128451_(TAG_LADDERZ);
        }
        this.ladderNode = this.nodes.get(new Vec2i(ladderX, ladderZ));
        ListTag openNodeTagList = compound.m_128437_(TAG_OPEN_NODES, 10);
        for (int i = 0; i < openNodeTagList.size(); ++i) {
            @NotNull Node node = Node.createFromNBT(openNodeTagList.m_128728_(i));
            this.openNodes.add(node);
        }
    }

    public Node getRandomNode(@Nullable Node node) {
        Node nextNode = null;
        if (node == null || !this.nodes.containsKey(new Vec2i(node.getX(), node.getZ()))) {
            return this.openNodes.peek();
        }
        if (this.getNumberOfBuiltNodes() > 10 && rand.nextInt(4) > 0) {
            nextNode = node.getRandomNextNode(this, 0);
        }
        return nextNode == null ? this.openNodes.peek() : nextNode;
    }

    public BlockPos getRandomCompletedNode(BuildingMiner buildingMiner) {
        Object[] nodeSet = this.nodes.keySet().toArray();
        Node nextNode = this.nodes.get(nodeSet[rand.nextInt(nodeSet.length)]);
        while (nextNode.getStatus() != Node.NodeStatus.COMPLETED || nextNode.getStyle() == Node.NodeType.LADDER_BACK) {
            nextNode = this.getNode(nextNode.getParent());
        }
        if (nextNode == null || nextNode.getStyle() == Node.NodeType.SHAFT) {
            BlockPos vector = buildingMiner.getLadderLocation().m_121996_((Vec3i)buildingMiner.getCobbleLocation());
            return new BlockPos(this.ladderNode.getX() + 3 * vector.m_123341_(), this.getDepth() + 1, this.ladderNode.getZ() + 3 * vector.m_123343_());
        }
        return new BlockPos(nextNode.getX(), this.getDepth() + 1, nextNode.getZ());
    }

    public void closeNextNode(int rotation, Node node, Level world) {
        Node tempNode = node == null ? this.openNodes.peek() : node;
        ArrayList<Vec2i> nodeCenterList = new ArrayList<Vec2i>(3);
        if (tempNode == null) {
            return;
        }
        switch (tempNode.getStyle()) {
            case TUNNEL: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                break;
            }
            case BEND_RIGHT: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            case BEND_LEFT: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 1));
                break;
            }
            case CROSS_THREE_LEFT_RIGHT: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 1));
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            case CROSS_THREE_TOP_LEFT: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            case CROSS_THREE_TOP_RIGHT: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 1));
                break;
            }
            case CROSSROAD: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 0));
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 1));
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, 3));
                break;
            }
            case UNDEFINED: {
                Log.getLogger().error("Minecolonies node: " + node.getX() + ":" + node.getZ() + " style undefined creating children, Please tell the mod authors about this");
                return;
            }
            default: {
                return;
            }
        }
        for (Vec2i pos : nodeCenterList) {
            if (this.nodes.containsKey(pos) || !world.m_6425_(new BlockPos(pos.getX(), this.getDepth() + 2, pos.getZ())).m_76178_()) continue;
            Node tempNodeToAdd = new Node(pos.getX(), pos.getZ(), new Vec2i(tempNode.getX(), tempNode.getZ()));
            tempNodeToAdd.setStyle((Node.NodeType)((Object)Node.NodeType.SIDE_NODES.get(rand.nextInt(Node.NodeType.SIDE_NODES.size()))));
            this.nodes.put(pos, tempNodeToAdd);
            this.openNodes.add(tempNodeToAdd);
        }
        Node I = this.nodes.get(new Vec2i(tempNode.getX(), tempNode.getZ()));
        if (!tempNode.equals(I)) {
            Log.getLogger().warn("Minecolonies node: " + node.getX() + ":" + node.getZ() + " not equal to storage during close, Please tell the mod authors about this");
        }
        tempNode.setStatus(Node.NodeStatus.COMPLETED);
        this.openNodes.removeIf(tempNode::equals);
    }

    private static Vec2i getNextNodePositionFromNodeWithRotation(Node node, int rotation, int additionalRotation) {
        int realRotation = Math.floorMod(rotation + additionalRotation, 4);
        switch (realRotation) {
            case 1: {
                return node.getSouthNodeCenter();
            }
            case 2: {
                return node.getWestNodeCenter();
            }
            case 3: {
                return node.getNorthNodeCenter();
            }
        }
        return node.getEastNodeCenter();
    }

    @NotNull
    public String toString() {
        return "Level{depth=" + this.depth + ", nodes=" + this.nodes + ", ladderNode=" + this.ladderNode + "}";
    }

    public void write(@NotNull CompoundTag compound) {
        compound.m_128405_(TAG_DEPTH, this.depth);
        if (this.levelSign != null) {
            BlockPosUtil.write(compound, TAG_LEVEL_SIGN, this.levelSign);
        }
        @NotNull ListTag nodeTagList = new ListTag();
        for (Node node : this.nodes.values()) {
            @NotNull CompoundTag nodeCompound = new CompoundTag();
            node.write(nodeCompound);
            nodeTagList.add((Object)nodeCompound);
        }
        compound.m_128365_(TAG_NODES, (Tag)nodeTagList);
        compound.m_128405_(TAG_LADDERX, this.ladderNode.getX());
        compound.m_128405_(TAG_LADDERZ, this.ladderNode.getZ());
        @NotNull ListTag openNodeTagList = new ListTag();
        for (Node node : this.openNodes) {
            @NotNull CompoundTag nodeCompound = new CompoundTag();
            node.write(nodeCompound);
            openNodeTagList.add((Object)nodeCompound);
        }
        compound.m_128365_(TAG_OPEN_NODES, (Tag)openNodeTagList);
    }

    @NotNull
    public Map<Vec2i, Node> getNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public int getNumberOfBuiltNodes() {
        return this.nodes.size() - this.openNodes.size() + -2;
    }

    public int getDepth() {
        return this.depth;
    }

    @NotNull
    public Node getLadderNode() {
        return this.ladderNode;
    }

    public Node getNode(Vec2i key) {
        return this.nodes.get(key);
    }

    public Node getOpenNode(Vec2i key) {
        return this.nodes.get(key);
    }

    public BlockPos getLevelSign() {
        return this.levelSign;
    }
}

