/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.norsemenevent.NorsemenShipRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.PirateGroundRaidEvent;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandRaid
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.raidExecute(context, "");
    }

    public int onSpecificExecute(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.raidExecute(context, StringArgumentType.getString(context, (String)"raidtype"));
    }

    public int raidExecute(CommandContext<CommandSourceStack> context, String raidType) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        if (StringArgumentType.getString(context, (String)"raidtime").equals("now")) {
            colony.getRaiderManager().raiderEvent(raidType);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"com.minecolonies.command.raidnow.success", (Object[])new Object[]{colony.getName()}), true);
        } else if (StringArgumentType.getString(context, (String)"raidtime").equals("tonight")) {
            colony.getRaiderManager().setRaidNextNight(true, raidType);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"com.minecolonies.command.raidtonight.success", (Object[])new Object[]{colony.getName()}), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "raid";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        ArrayList<String> raidTypes = new ArrayList<String>();
        for (ColonyEventTypeRegistryEntry type : IMinecoloniesAPI.getInstance().getColonyEventRegistry().getValues()) {
            if (type.getRegistryName().m_135815_().equals(PirateGroundRaidEvent.PIRATE_GROUND_RAID_EVENT_TYPE_ID.m_135815_()) || type.getRegistryName().m_135815_().equals(NorsemenShipRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.m_135815_())) continue;
            raidTypes.add(type.getRegistryName().m_135815_());
        }
        String[] opt = new String[]{"now", "tonight"};
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("raidtime", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])opt, (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("raidtype", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_((Iterable)raidTypes, (SuggestionsBuilder)builder)).executes(this::onSpecificExecute))).executes(this::checkPreConditionAndExecute)));
    }
}

