/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.modules.CourierAssignmentModule;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeliverymenRequestResolver<R extends IRequestable>
extends AbstractRequestResolver<R> {
    public DeliverymenRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends R> requestToCheck) {
        if (manager.getColony().getWorld().f_46443_) {
            return false;
        }
        return !this.getResolveAbleDeliverymen(manager).isEmpty();
    }

    public List<ICitizenData> getResolveAbleDeliverymen(@NotNull IRequestManager manager) {
        ArrayList<ICitizenData> citizenList = new ArrayList<ICitizenData>();
        Colony colony = (Colony)manager.getColony();
        IWareHouse wareHouse = colony.getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation(), IWareHouse.class);
        if (wareHouse == null) {
            return citizenList;
        }
        for (ICitizenData data : wareHouse.getFirstModuleOccurance(CourierAssignmentModule.class).getAssignedCitizen()) {
            if (!data.isWorking()) continue;
            citizenList.add(data);
        }
        return citizenList;
    }

    @Override
    public int getSuitabilityMetric(@NotNull IRequest<? extends R> request) {
        return (int)BlockPosUtil.getDistance(request.getRequester().getLocation().getInDimensionLocation(), this.getLocation().getInDimensionLocation());
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
        if (manager.getColony().getWorld().f_46443_) {
            return null;
        }
        ICitizenData chosenCourier = null;
        Tuple<Double, Integer> bestScore = null;
        for (ICitizenData citizen : this.getResolveAbleDeliverymen(manager)) {
            if (!citizen.isWorking()) continue;
            Tuple<Double, Integer> localScore = ((JobDeliveryman)citizen.getJob()).getScoreForDelivery(request);
            if (bestScore != null && !(localScore.getA() < bestScore.getA())) continue;
            bestScore = localScore;
            chosenCourier = citizen;
        }
        if (chosenCourier == null) {
            return null;
        }
        return Lists.newArrayList();
    }

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) throws RuntimeException {
        ICitizenData chosenCourier = null;
        Tuple<Double, Integer> bestScore = null;
        for (ICitizenData citizen : this.getResolveAbleDeliverymen(manager)) {
            if (!citizen.isWorking()) continue;
            Tuple<Double, Integer> localScore = ((JobDeliveryman)citizen.getJob()).getScoreForDelivery(request);
            if (bestScore != null && !(localScore.getA() < bestScore.getA())) continue;
            bestScore = localScore;
            chosenCourier = citizen;
        }
        if (chosenCourier == null) {
            return;
        }
        JobDeliveryman job = (JobDeliveryman)chosenCourier.getJob();
        job.addRequest((IToken<?>)request.getId(), (Integer)bestScore.getB());
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> completedRequest) {
        return null;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
        if (!manager.getColony().getWorld().f_46443_) {
            Colony colony = (Colony)manager.getColony();
            ICitizenData freeDeliveryMan = colony.getCitizenManager().getCitizens().stream().filter(c -> c.getJob() instanceof JobDeliveryman && ((JobDeliveryman)c.getJob()).getTaskQueue().contains(request.getId())).findFirst().orElse(null);
            if (freeDeliveryMan == null) {
                Log.getLogger().error("Parent cancellation of delivery request failed! Unknown request: " + request.getId(), (Throwable)new Exception());
            } else {
                JobDeliveryman job = (JobDeliveryman)freeDeliveryMan.getJob();
                job.onTaskDeletion((IToken<?>)request.getId());
            }
        }
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        return Component.m_237115_((String)"com.minecolonies.coremod.job.deliveryman");
    }
}

