/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.AbstractInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.citizen.MainWindowCitizen;
import com.minecolonies.coremod.network.messages.server.colony.InteractionResponse;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class ServerCitizenInteraction
extends AbstractInteractionResponseHandler {
    private static final String TAG_DELAY = "delay";
    private static final String TAG_PARENT = "parent";
    private static final String TAG_PARENTS = "parents";
    private static final String TAG_VALIDATOR_ID = "validator";
    private int displayAtWorldTick = 0;
    private Predicate<ICitizenData> validator;
    protected Component validatorId;
    protected Set<Component> parents = new HashSet<Component>();

    @SafeVarargs
    public ServerCitizenInteraction(Component inquiry, boolean primary, IChatPriority priority, Predicate<ICitizenData> validator, Component validatorId, Tuple<Component, Component> ... responseTuples) {
        super(inquiry, primary, priority, responseTuples);
        this.validator = validator;
        this.validatorId = validatorId;
    }

    public ServerCitizenInteraction(ICitizen data) {
    }

    @Override
    public boolean isVisible(Level world) {
        return this.displayAtWorldTick == 0 || (long)this.displayAtWorldTick < world.m_46467_();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        return this.validator == null && !this.parents.isEmpty() || this.validator != null && this.validator.test(citizen);
    }

    public void addParent(Component parent) {
        this.parents.add(parent);
    }

    @Override
    public void removeParent(Component oldParent) {
        this.parents.remove(oldParent);
    }

    @Override
    public void onServerResponseTriggered(Component response, Player player, ICitizenData data) {
        if (response.m_214077_() instanceof TranslatableContents) {
            if (((TranslatableContents)response.m_214077_()).m_237508_().equals("com.minecolonies.coremod.gui.chat.remindmelater")) {
                this.displayAtWorldTick = (int)(player.f_19853_.m_46467_() + 12000L);
            } else if (((TranslatableContents)response.m_214077_()).m_237508_().equals("com.minecolonies.coremod.gui.chat.ignore")) {
                this.displayAtWorldTick = (int)(player.f_19853_.m_46467_() + 24000L);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(Component response, Player player, ICitizenDataView data, BOWindow window) {
        if (((TranslatableContents)response.m_214077_()).m_237508_().equals("com.minecolonies.coremod.gui.chat.skipchitchat")) {
            MainWindowCitizen windowCitizen = new MainWindowCitizen(data);
            windowCitizen.open();
        }
        Network.getNetwork().sendToServer(new InteractionResponse(data.getColonyId(), data.getId(), (ResourceKey<Level>)player.f_19853_.m_46472_(), this.getInquiry(), response));
        return true;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = super.serializeNBT();
        compoundNBT.m_128405_(TAG_DELAY, this.displayAtWorldTick);
        ListTag list = new ListTag();
        for (Component element : this.parents) {
            CompoundTag elementTag = new CompoundTag();
            elementTag.m_128359_(TAG_PARENT, Component.Serializer.m_130703_((Component)element));
            list.add((Object)elementTag);
        }
        compoundNBT.m_128365_(TAG_PARENTS, (Tag)list);
        compoundNBT.m_128359_(TAG_VALIDATOR_ID, Component.Serializer.m_130703_((Component)this.validatorId));
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag compoundNBT) {
        super.deserializeNBT(compoundNBT);
        this.displayAtWorldTick = compoundNBT.m_128451_(TAG_DELAY);
        this.parents.clear();
        ListTag list = compoundNBT.m_128437_(TAG_PARENTS, 10);
        for (int i = 0; i < list.size(); ++i) {
            this.parents.add((Component)Component.Serializer.m_130701_((String)compoundNBT.m_128461_(TAG_PARENT)));
        }
        this.validatorId = Component.Serializer.m_130701_((String)compoundNBT.m_128461_(TAG_VALIDATOR_ID));
        this.loadValidator();
    }

    protected void loadValidator() {
        this.validator = InteractionValidatorRegistry.getStandardInteractionValidatorPredicate(this.validatorId);
    }
}

