/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render.worldevent;

import com.ldtteam.structurize.util.WorldRenderMacros;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.coremod.client.render.worldevent.ColonyBlueprintRenderer;
import com.minecolonies.coremod.client.render.worldevent.ColonyBorderRenderer;
import com.minecolonies.coremod.client.render.worldevent.ColonyPatrolPointRenderer;
import com.minecolonies.coremod.client.render.worldevent.ColonyWaypointRenderer;
import com.minecolonies.coremod.client.render.worldevent.GuardTowerRallyBannerRenderer;
import com.minecolonies.coremod.client.render.worldevent.HighlightManager;
import com.minecolonies.coremod.client.render.worldevent.PathfindingDebugRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.Nullable;

public class WorldEventContext {
    public static final WorldEventContext INSTANCE = new WorldEventContext();
    MultiBufferSource.BufferSource bufferSource;
    PoseStack poseStack;
    float partialTicks;
    ClientLevel clientLevel;
    LocalPlayer clientPlayer;
    ItemStack mainHandItem;
    @Nullable
    IColonyView nearestColony;
    int clientRenderDist;

    private WorldEventContext() {
    }

    public void renderWorldLastEvent(RenderLevelStageEvent event) {
        this.bufferSource = WorldRenderMacros.getBufferSource();
        this.poseStack = event.getPoseStack();
        this.partialTicks = event.getPartialTick();
        this.clientLevel = Minecraft.m_91087_().f_91073_;
        this.clientPlayer = Minecraft.m_91087_().f_91074_;
        this.mainHandItem = this.clientPlayer.m_21205_();
        this.nearestColony = IColonyManager.getInstance().getClosestColonyView((Level)this.clientLevel, this.clientPlayer.m_20183_());
        this.clientRenderDist = (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_();
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        this.poseStack.m_85836_();
        this.poseStack.m_85837_(-cameraPos.m_7096_(), -cameraPos.m_7098_(), -cameraPos.m_7094_());
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_MIPPED_BLOCKS_BLOCKS) {
            ColonyBorderRenderer.render(this);
            ColonyBlueprintRenderer.render(this);
            ColonyWaypointRenderer.render(this);
            ColonyPatrolPointRenderer.render(this);
            GuardTowerRallyBannerRenderer.render(this);
            PathfindingDebugRenderer.render(this);
            this.bufferSource.m_109911_();
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            HighlightManager.render(this);
        }
        this.poseStack.m_85849_();
    }

    boolean hasNearestColony() {
        return this.nearestColony != null;
    }
}

