/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.coremod.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WindowStatsPage
extends AbstractWindowTownHall {
    private static final LinkedHashMap<String, Integer> INTERVAL = new LinkedHashMap();
    private DropDownList intervalDropdown;
    public String selectedInterval = "com.minecolonies.coremod.gui.interval.yesterday";

    public WindowStatsPage(BuildingTownHall.View townHall) {
        super(townHall, "layoutstats.xml");
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateHappiness();
        this.updateStats();
    }

    private void updateHappiness() {
        HashMap<String, Double> happinessMap = new HashMap<String, Double>();
        for (ICitizenDataView data : ((ITownHallView)this.building).getColony().getCitizens().values()) {
            for (String modifier : data.getHappinessHandler().getModifiers()) {
                happinessMap.put(modifier, happinessMap.getOrDefault(modifier, 0.0) + data.getHappinessHandler().getModifier(modifier).getFactor());
            }
        }
        View pane = (View)this.findPaneOfTypeByID("happinesspage", View.class);
        Text titleLabel = new Text();
        titleLabel.setSize(136, 11);
        titleLabel.setPosition(25, 42);
        titleLabel.setColors(WindowBuilderResModule.BLACK);
        titleLabel.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.currenthappiness"));
        pane.addChild((Pane)titleLabel);
        int yPos = 60;
        for (Map.Entry entry : happinessMap.entrySet()) {
            double value = (Double)entry.getValue() / (double)((ITownHallView)this.building).getColony().getCitizenCount();
            Image image = new Image();
            image.setSize(11, 11);
            image.setPosition(0, yPos);
            Text label = new Text();
            label.setSize(136, 11);
            label.setPosition(25, yPos);
            label.setColors(WindowBuilderResModule.BLACK);
            label.setText(Component.m_237115_((String)("com.minecolonies.coremod.gui.townhall.happiness." + (String)entry.getKey())));
            if (value > 1.0) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/green_icon.png"), false);
            } else if (value == 1.0) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/blue_icon.png"), false);
            } else if (value > 0.75) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/yellow_icon.png"), false);
            } else {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/red_icon.png"), false);
            }
            pane.addChild((Pane)image);
            pane.addChild((Pane)label);
            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)label).append(Component.m_237115_((String)("com.minecolonies.coremod.gui.townhall.happiness.desc." + (String)entry.getKey())))).build();
            yPos += 12;
        }
    }

    private void updateStats() {
        final @NotNull ArrayList<String> stats = new ArrayList<String>(((ITownHallView)this.building).getColony().getStatisticsManager().getStatTypes());
        ((ScrollingList)this.findPaneOfTypeByID("stats", ScrollingList.class)).setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return stats.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                int stat = ((ITownHallView)WindowStatsPage.this.building).getColony().getStatisticsManager().getStatTotal((String)stats.get(index));
                int interval = INTERVAL.get(WindowStatsPage.this.selectedInterval);
                if (interval > 0) {
                    stat = ((ITownHallView)WindowStatsPage.this.building).getColony().getStatisticsManager().getStatsInPeriod((String)stats.get(index), ((ITownHallView)WindowStatsPage.this.building).getColony().getDay() - interval, ((ITownHallView)WindowStatsPage.this.building).getColony().getDay());
                }
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("desc", Text.class);
                resourceLabel.setText(Component.m_237110_((String)("com.minecolonies.coremod.gui.townhall.stats." + (String)stats.get(index)), (Object[])new Object[]{stat}));
            }
        });
        this.intervalDropdown = (DropDownList)this.findPaneOfTypeByID("intervals", DropDownList.class);
        this.intervalDropdown.setHandler(this::onDropDownListChanged);
        this.intervalDropdown.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return INTERVAL.size();
            }

            public String getLabel(int index) {
                return Component.m_237115_((String)((String)INTERVAL.keySet().toArray()[index])).getString();
            }
        });
        this.intervalDropdown.setSelectedIndex(new ArrayList<String>(INTERVAL.keySet()).indexOf(this.selectedInterval));
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        String temp = (String)INTERVAL.keySet().toArray()[dropDownList.getSelectedIndex()];
        if (!temp.equals(this.selectedInterval)) {
            this.selectedInterval = temp;
            this.updateStats();
        }
    }

    @Override
    protected String getWindowId() {
        return "happiness";
    }

    static {
        INTERVAL.put("com.minecolonies.coremod.gui.interval.yesterday", 1);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.lastweek", 7);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.100days", 100);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.alltime", -1);
    }
}

