/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.MinerLevelManagementModuleView;
import com.minecolonies.coremod.network.messages.server.colony.building.miner.MinerRepairLevelMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.miner.MinerSetLevelMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WindowHutMinerModule
extends AbstractModuleWindow {
    private static final String LIST_LEVELS = "levels";
    private static final String BUTTON_CURRENTLEVEL = "changeToLevel";
    private static final String BUTTON_REPAIR = "repair";
    private static final String HUT_MINER_RESOURCE_SUFFIX = ":gui/layouthuts/layoutminermodule.xml";
    private final MinerLevelManagementModuleView miner;
    private List<Tuple<Integer, Integer>> levelsInfo;
    private ScrollingList levelList;

    public WindowHutMinerModule(IBuildingView building, MinerLevelManagementModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutminermodule.xml");
        this.miner = moduleView;
        this.pullLevelsFromHut();
        this.registerButton(BUTTON_CURRENTLEVEL, this::currentLevelClicked);
        this.registerButton(BUTTON_REPAIR, this::repairClicked);
    }

    private void repairClicked(Button button) {
        int row = this.levelList.getListElementIndexByPane((Pane)button);
        Network.getNetwork().sendToServer(new MinerRepairLevelMessage(this.buildingView, row));
        MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.miner.repair.enqueued", new Object[0]).sendTo(new Player[]{Minecraft.m_91087_().f_91074_});
    }

    private void currentLevelClicked(Button button) {
        int row = this.levelList.getListElementIndexByPane((Pane)button);
        if (row != this.miner.current && row >= 0 && row < this.levelsInfo.size()) {
            this.miner.current = row;
            Network.getNetwork().sendToServer(new MinerSetLevelMessage(this.buildingView, row));
        }
    }

    private void pullLevelsFromHut() {
        if (this.miner.getColony().getBuilding(this.buildingView.getID()) != null) {
            this.levelsInfo = this.miner.levelsInfo;
        }
    }

    public void onOpened() {
        super.onOpened();
        this.levelList = (ScrollingList)this.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class);
        this.levelList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutMinerModule.this.levelsInfo.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                if (index == WindowHutMinerModule.this.miner.current) {
                    ((Text)rowPane.findPaneOfTypeByID("lvl", Text.class)).setColors(Color.getByName((String)"red", (int)0));
                } else {
                    ((Text)rowPane.findPaneOfTypeByID("lvl", Text.class)).setColors(Color.getByName((String)"black", (int)0));
                }
                if (WindowHutMinerModule.this.miner.doesWorkOrderExist(index)) {
                    ((Button)rowPane.findPaneOfTypeByID(WindowHutMinerModule.BUTTON_REPAIR, Button.class)).disable();
                }
                ((Text)rowPane.findPaneOfTypeByID("lvl", Text.class)).setText(Component.m_237113_((String)Integer.toString(index)));
                ((Text)rowPane.findPaneOfTypeByID("nONodes", Text.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.minernode").m_130946_(": ").m_130946_(String.valueOf(WindowHutMinerModule.this.levelsInfo.get(index).m_14418_())));
                ((Text)rowPane.findPaneOfTypeByID("yLevel", Text.class)).setText(Component.m_237113_((String)("Y: " + ((Integer)WindowHutMinerModule.this.levelsInfo.get(index).m_14419_() + 1))));
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        this.pullLevelsFromHut();
    }
}

