/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.map;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.views.View;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ZoomDragMap
extends View {
    public double scrollX = 0.0;
    public double scrollY = 0.0;
    private double scale = 1.0;
    protected int contentHeight = 0;
    protected int contentWidth = 0;
    private double dragFactor = 1.0;
    private boolean dragEnabled = true;
    private double zoomFactor = 1.1;
    private boolean zoomEnabled = true;
    private double minScale = 0.02;
    private double maxScale = 6.0;

    public ZoomDragMap() {
    }

    public ZoomDragMap(PaneParams params) {
        super(params);
        this.dragFactor = params.getDouble("dragfactor", this.dragFactor);
        this.dragEnabled = params.getBoolean("dragenabled", this.dragEnabled);
        this.zoomFactor = params.getDouble("zoomfactor", this.zoomFactor);
        this.zoomEnabled = params.getBoolean("zoomenabled", this.zoomEnabled);
        this.minScale = params.getDouble("minscale", this.minScale);
        this.maxScale = params.getDouble("maxscale", this.maxScale);
    }

    protected boolean childIsVisible(@NotNull Pane child) {
        return this.calcInverseAbsoluteX(child.getX()) < (double)this.getInteriorWidth() && this.calcInverseAbsoluteY(child.getY()) < (double)this.getInteriorHeight() && this.calcInverseAbsoluteX(child.getX() + child.getWidth()) >= 0.0 && this.calcInverseAbsoluteY(child.getY() + child.getHeight()) >= 0.0;
    }

    private double calcInverseAbsoluteX(double xIn) {
        return xIn * this.scale - this.scrollX;
    }

    private double calcInverseAbsoluteY(double yIn) {
        return yIn * this.scale - this.scrollY;
    }

    private double calcRelativeX(double xIn) {
        return (xIn - (double)this.x + this.scrollX) / this.scale + (double)this.x;
    }

    private double calcRelativeY(double yIn) {
        return (yIn - (double)this.y + this.scrollY) / this.scale + (double)this.y;
    }

    public void parseChildren(PaneParams params) {
        super.parseChildren(params);
        this.computeContentSize();
    }

    public void addChild(Pane child) {
        super.addChild(child);
        this.computeContentSize();
    }

    public void addChildFirst(Pane child) {
        child.setWindow(this.getWindow());
        this.children.add(0, child);
        this.adjustChild(child);
        child.setParentView((View)this);
        this.computeContentSize();
    }

    protected void computeContentSize() {
        this.contentHeight = 0;
        this.contentWidth = 0;
        for (Pane child : this.children) {
            if (child == null) continue;
            this.contentHeight = Math.max(this.contentHeight, child.getY() + child.getHeight());
            this.contentWidth = Math.max(this.contentWidth, child.getX() + child.getWidth());
        }
        this.setScrollY(this.scrollY);
        this.setScrollX(this.scrollX);
    }

    public void drawSelf(PoseStack ms, double mx, double my) {
        this.scissorsStart(ms, this.contentWidth, this.contentHeight);
        ms.m_85836_();
        ms.m_85837_(-this.scrollX, -this.scrollY, 0.0);
        ms.m_85837_((1.0 - this.scale) * (double)this.x, (1.0 - this.scale) * (double)this.y, 0.0);
        float renderScale = (float)Mth.m_14008_((double)this.scale, (double)0.26219988382999904, (double)6.0);
        ms.m_85841_(renderScale, renderScale, 1.0f);
        super.drawSelf(ms, this.calcRelativeX(mx), this.calcRelativeY(my));
        ms.m_85849_();
        this.scissorsEnd(ms);
    }

    public void drawSelfLast(PoseStack ms, double mx, double my) {
        this.scissorsStart(ms, this.contentWidth, this.contentHeight);
        ms.m_85836_();
        ms.m_85837_(-this.scrollX, -this.scrollY, 0.0);
        ms.m_85837_((1.0 - this.scale) * (double)this.x, (1.0 - this.scale) * (double)this.y, 0.0);
        float renderScale = (float)Mth.m_14008_((double)this.scale, (double)0.26219988382999904, (double)6.0);
        ms.m_85841_(renderScale, renderScale, 1.0f);
        super.drawSelfLast(ms, this.calcRelativeX(mx), this.calcRelativeY(my));
        ms.m_85849_();
        this.scissorsEnd(ms);
    }

    private void setScrollY(double offset) {
        this.scrollY = offset;
    }

    private void setScrollX(double offset) {
        this.scrollX = offset;
    }

    public boolean onMouseDrag(double startX, double startY, int speed, double x, double y) {
        boolean childResult = super.onMouseDrag(startX, startY, speed, this.calcRelativeX(x), this.calcRelativeY(y));
        if (!childResult && this.dragEnabled) {
            this.setScrollX(this.scrollX - x * this.dragFactor);
            this.setScrollY(this.scrollY - y * this.dragFactor);
            return true;
        }
        return childResult;
    }

    public boolean scrollInput(double wheel, double mx, double my) {
        boolean childResult = super.scrollInput(wheel, ((double)this.width - this.scrollX) / 2.0, ((double)this.height - this.scrollY) / 2.0);
        if (!childResult && this.zoomEnabled) {
            double childX = ((double)this.width - this.scrollX) / 2.0;
            double childY = ((double)this.height - this.scrollY) / 2.0;
            double oldX = (childX + this.scrollX) / this.scale;
            double oldY = (childY + this.scrollY) / this.scale;
            this.scale = wheel < 0.0 ? this.scale / this.zoomFactor : this.scale * this.zoomFactor;
            this.scale = Mth.m_14008_((double)this.scale, (double)this.minScale, (double)this.maxScale);
            this.setScrollX(oldX * this.scale - childX);
            this.setScrollY(oldY * this.scale - childY);
            return true;
        }
        return childResult;
    }

    public double getScale() {
        return this.scale;
    }
}

