/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.containers;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class WindowFurnaceCrafting
extends AbstractContainerScreen<ContainerCraftingFurnace> {
    private static final ResourceLocation CRAFTING_FURNACE = new ResourceLocation("minecolonies", "textures/gui/furnace.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private final ContainerCraftingFurnace container;
    private final AbstractBuildingView building;
    private final CraftingModuleView module;

    public WindowFurnaceCrafting(ContainerCraftingFurnace container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.container = container;
        this.building = (AbstractBuildingView)IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)playerInventory.f_35978_.f_19853_.m_46472_(), container.getPos());
        this.module = this.building.getModuleViewMatching(CraftingModuleView.class, v -> v.getId().equals(container.getModuleId()));
    }

    @NotNull
    public AbstractBuildingView getBuildingView() {
        return this.building;
    }

    protected void m_7856_() {
        super.m_7856_();
        MutableComponent buttonDisplay = Component.m_237115_((String)(this.module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get()) ? "gui.done" : "com.minecolonies.coremod.gui.recipe.full"));
        Button doneButton = new Button(this.f_97735_ + 1, this.f_97736_ + 170, 150, 20, (Component)buttonDisplay, (Button.OnPress)new OnButtonPress());
        this.m_142416_((GuiEventListener)doneButton);
        if (!this.module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get())) {
            doneButton.f_93623_ = false;
        }
    }

    protected void m_7286_(@NotNull PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CRAFTING_FURNACE);
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_6305_(@NotNull PoseStack stack, int x, int y, float z) {
        this.m_7333_(stack);
        super.m_6305_(stack, x, y, z);
        this.m_7025_(stack, x, y);
    }

    public class OnButtonPress
    implements Button.OnPress {
        public void m_93750_(@NotNull Button button) {
            if (WindowFurnaceCrafting.this.module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get())) {
                ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
                input.add(new ItemStorage(((Slot)WindowFurnaceCrafting.this.container.f_38839_.get(0)).m_7993_()));
                ItemStack primaryOutput = ((Slot)WindowFurnaceCrafting.this.container.f_38839_.get(1)).m_7993_().m_41777_();
                if (!ItemStackUtils.isEmpty(primaryOutput).booleanValue()) {
                    Network.getNetwork().sendToServer(new AddRemoveRecipeMessage((IBuildingView)WindowFurnaceCrafting.this.building, input, 1, primaryOutput, false, Blocks.f_50094_, WindowFurnaceCrafting.this.module.getId()));
                }
            }
        }
    }
}

