/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.container.CofferContainer;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.CofferSyncCrowButtonToServer;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Clearable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CofferTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
Clearable {
    public final ItemStackHandler itemStackHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemStackHandler);
    public int degreesOpened;
    public int buttonToggled = 0;
    public static final int lidOpenAmount = 112;
    public int dyeColor = 4337438;
    public Component customName;
    public ItemStack self = null;
    private static final int[] SLOTS = IntStream.range(0, 36).toArray();

    public CofferTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public CofferTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.COFFER_TILE.get(), blockPos, blockState);
    }

    public BlockEntityType<?> m_58903_() {
        return super.m_58903_();
    }

    public void readInventory(CompoundTag compound) {
        this.itemStackHandler.deserializeNBT(compound);
    }

    public void setDyeColor(int dyeColor) {
        this.dyeColor = dyeColor;
    }

    public int getDyeColor() {
        DyeColor dye = HexereiUtil.getDyeColorNamed(this.m_5446_().getString());
        if (dye != null) {
            return HexereiUtil.getColorValue(dye);
        }
        return this.dyeColor;
    }

    protected NonNullList<ItemStack> m_7086_() {
        NonNullList items = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemStackHandler.getStackInSlot(i));
        }
        return items;
    }

    public ItemStack m_7407_(int p_59613_, int p_59614_) {
        ItemStack itemstack;
        this.m_59640_(null);
        ItemStack itemStack = itemstack = p_59613_ >= 0 && p_59613_ < this.itemStackHandler.getSlots() && !this.itemStackHandler.getStackInSlot(p_59613_).m_41619_() && p_59614_ > 0 ? ((ItemStack)this.m_7086_().get(p_59613_)).m_41620_(p_59614_) : ItemStack.f_41583_;
        if (!itemstack.m_41619_()) {
            this.sync();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int p_59630_) {
        this.m_59640_(null);
        if (p_59630_ >= 0 && p_59630_ < this.itemStackHandler.getSlots()) {
            this.itemStackHandler.setStackInSlot(p_59630_, ItemStack.f_41583_);
            return this.itemStackHandler.getStackInSlot(p_59630_);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8020_(int p_59611_) {
        this.m_59640_(null);
        return this.itemStackHandler.getStackInSlot(p_59611_);
    }

    public void m_6836_(int p_59616_, ItemStack p_59617_) {
        this.m_59640_(null);
        this.itemStackHandler.setStackInSlot(p_59616_, p_59617_);
        if (p_59617_.m_41613_() > this.m_6893_()) {
            p_59617_.m_41764_(this.m_6893_());
        }
        this.sync();
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        for (int i = 0; i < Math.min(itemsIn.size(), this.itemStackHandler.getSlots()); ++i) {
            this.itemStackHandler.setStackInSlot(i, (ItemStack)itemsIn.get(i));
        }
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.self != null) {
            Item item;
            CompoundTag tag = this.self.m_41784_();
            CompoundTag inv = this.itemStackHandler.serializeNBT();
            boolean flag = false;
            for (int i = 0; i < 36; ++i) {
                if (this.itemStackHandler.getStackInSlot(i).m_41619_()) continue;
                flag = true;
                break;
            }
            if (flag) {
                tag.m_128365_("Inventory", (Tag)inv);
            }
            if ((item = this.self.m_41720_()) instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeableLeatherItem = (DyeableLeatherItem)item;
                dyeableLeatherItem.m_41115_(this.self, this.dyeColor);
            }
            tag.m_128405_("ButtonToggled", this.buttonToggled);
            Component customName = this.m_7770_();
            if (customName != null && customName.getString().length() > 0) {
                this.self.m_41714_(customName);
            }
        }
    }

    public void m_5856_(Player p_18955_) {
        super.m_5856_(p_18955_);
    }

    public void m_5785_(Player p_18954_) {
        super.m_5785_(p_18954_);
    }

    public boolean m_7013_(int p_18952_, ItemStack stack) {
        String id = HexereiUtil.getRegistryName(stack.m_41720_()).toString();
        if (((List)HexConfig.COFFER_BLACKLIST.get()).contains(id)) {
            return false;
        }
        return super.m_7013_(p_18952_, stack);
    }

    public int m_18947_(Item p_18948_) {
        return super.m_18947_(p_18948_);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.hexerei.coffer");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new CofferContainer(id, this.f_58857_, this.f_58858_, player, player.f_35978_);
    }

    public void m_6211_() {
        super.m_6211_();
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            this.itemStackHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
        return aabb;
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
    }

    @NotNull
    public ModelData getModelData() {
        return super.getModelData();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public CompoundTag save(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inv", (Tag)this.itemStackHandler.serializeNBT());
        tag.m_128405_("ButtonToggled", this.buttonToggled);
        tag.m_128405_("DyeColor", this.dyeColor);
        return tag;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("inv", (Tag)this.itemStackHandler.serializeNBT());
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128405_("ButtonToggled", this.buttonToggled);
        compound.m_128405_("DyeColor", this.dyeColor);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.itemStackHandler.deserializeNBT(compoundTag.m_128469_("inv"));
        if (compoundTag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compoundTag.m_128461_("CustomName"));
        }
        if (compoundTag.m_128441_("ButtonToggled")) {
            this.buttonToggled = compoundTag.m_128451_("ButtonToggled");
        }
        if (compoundTag.m_128441_("DyeColor")) {
            this.dyeColor = compoundTag.m_128451_("DyeColor");
            if (this.dyeColor == 0) {
                this.dyeColor = 4337438;
            }
        }
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @javax.annotation.Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public void sync() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
            }
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(36){

            protected void onContentsChanged(int slot) {
                CofferTile.this.sync();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return !((List)HexConfig.COFFER_BLACKLIST.get()).contains(HexereiUtil.getRegistryName(stack.m_41720_()).toString());
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap);
    }

    public ItemStack getItemStackInSlot(int slot) {
        return this.itemStackHandler.getStackInSlot(slot);
    }

    public int getNumberOfItems() {
        int num = 0;
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (this.itemStackHandler.getStackInSlot(i) == ItemStack.f_41583_) continue;
            ++num;
        }
        return num;
    }

    public boolean hasItem(Item item) {
        if (this.itemStackHandler != null) {
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                if (!this.itemStackHandler.getStackInSlot(i).m_150930_(item)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasNonMaxStackItemStack(ItemStack item) {
        if (this.itemStackHandler != null) {
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                if (this.itemStackHandler.getStackInSlot(i) != item || this.itemStackHandler.getStackInSlot(i).m_41613_() >= this.itemStackHandler.getStackInSlot(i).m_41741_()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean m_7983_() {
        if (this.itemStackHandler != null) {
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                if (this.itemStackHandler.getStackInSlot(i).m_41619_()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20185_() - (double)pos.m_123341_();
        double deltaY = entity.m_20186_() - (double)pos.m_123342_();
        double deltaZ = entity.m_20189_() - (double)pos.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public Component m_5446_() {
        return this.customName != null ? this.customName : Component.m_237113_((String)"");
    }

    public Component m_7770_() {
        return this.customName;
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    public Component m_7755_() {
        return this.customName;
    }

    public int getDegreesOpened() {
        return this.degreesOpened;
    }

    public void setDegreesOpened(int degrees) {
        this.degreesOpened = degrees;
    }

    public void setButtonToggled(int buttonToggled) {
        this.buttonToggled = buttonToggled;
        if (this.f_58857_.f_46443_) {
            HexereiPacketHandler.sendToServer(new CofferSyncCrowButtonToServer(this, buttonToggled));
        }
    }

    public int getButtonToggled() {
        return this.buttonToggled;
    }

    public void tick() {
        int distanceFromSide;
        boolean flag = false;
        Player playerEntity = this.f_58857_.m_45924_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 5.0, false);
        if (playerEntity != null && Math.floor(CofferTile.getDistanceToEntity((Entity)playerEntity, this.f_58858_)) < 4.0) {
            distanceFromSide = 56 - Math.abs(56 - this.degreesOpened);
            flag = true;
            this.degreesOpened = (double)this.degreesOpened + Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0 < 112.0 ? (int)((double)this.degreesOpened + (Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0)) : 112;
        }
        if (!flag) {
            distanceFromSide = 56 - Math.abs(56 - this.degreesOpened);
            if ((double)this.degreesOpened + Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0 > 0.0) {
                this.degreesOpened = (int)((double)this.degreesOpened - (Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0));
                if (this.degreesOpened < 0) {
                    this.degreesOpened = 0;
                }
            } else {
                this.degreesOpened = 0;
            }
        }
    }

    public int m_6643_() {
        return 0;
    }

    public int m_6893_() {
        return super.m_6893_();
    }

    public int[] m_7071_(Direction pSide) {
        return SLOTS;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.itemStackHandler.isItemValid(pIndex, pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }
}

