/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.container.ModContainers;
import net.joefoxe.hexerei.data.recipes.WoodcutterRecipe;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WoodcutterContainer
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<WoodcutterRecipe> recipes = Lists.newArrayList();
    private WoodcutterRecipe lastUsedRecipe = null;
    private int recipesSize = 0;
    private ItemStack input = ItemStack.f_41583_;
    private ItemStack lastNonAirInput = ItemStack.f_41583_;
    private ItemStack lastInput = ItemStack.f_41583_;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            WoodcutterContainer.this.m_6199_((Container)this);
            WoodcutterContainer.this.slotUpdateListener.run();
        }
    };
    public final ResultContainer resultContainer = new ResultContainer();

    public WoodcutterContainer(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public WoodcutterContainer(int pContainerId, Inventory pPlayerInventory, final ContainerLevelAccess pAccess) {
        super((MenuType)ModContainers.WOODCUTTER_CONTAINER.get(), pContainerId);
        this.access = pAccess;
        this.level = pPlayerInventory.f_35978_.f_19853_;
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 26, 44));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 142, 56){

            public boolean m_5857_(ItemStack p_40362_) {
                return false;
            }

            public boolean m_8010_(Player pPlayer) {
                if (WoodcutterContainer.this.selectedRecipeIndex.m_6501_() == -1 || WoodcutterContainer.this.recipes.isEmpty() || WoodcutterContainer.this.container.m_8020_(0).m_41613_() < WoodcutterContainer.this.recipes.get((int)WoodcutterContainer.this.selectedRecipeIndex.m_6501_()).ingredientCount) {
                    return false;
                }
                return super.m_8010_(pPlayer);
            }

            public void m_142406_(Player p_150672_, ItemStack p_150673_) {
                p_150673_.m_41678_(p_150672_.f_19853_, p_150672_, p_150673_.m_41613_());
                WoodcutterContainer.this.resultContainer.m_8015_(p_150672_);
                ItemStack itemstack = WoodcutterContainer.this.inputSlot.m_6201_(WoodcutterContainer.this.recipes.get((int)WoodcutterContainer.this.selectedRecipeIndex.m_6501_()).ingredientCount);
                if (!itemstack.m_41619_()) {
                    WoodcutterContainer.this.setupResultSlot();
                }
                pAccess.m_39292_((p_40364_, p_40365_) -> {
                    long l = p_40364_.m_46467_();
                    if (WoodcutterContainer.this.lastSoundTime != l) {
                        p_40364_.m_5594_((Player)null, p_40365_, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        WoodcutterContainer.this.lastSoundTime = l;
                    }
                });
                WoodcutterContainer.this.m_6199_(WoodcutterContainer.this.container);
                super.m_142406_(p_150672_, p_150673_);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18 + 4, 84 + i * 18 + 31));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)pPlayerInventory, k, 8 + k * 18 + 4, 173));
        }
        this.m_38895_(this.selectedRecipeIndex);
        this.selectedRecipeIndex.m_6422_(-1);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<WoodcutterRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player pPlayer) {
        return WoodcutterContainer.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)ModBlocks.WILLOW_WOODCUTTER.get())) || WoodcutterContainer.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)ModBlocks.MAHOGANY_WOODCUTTER.get()));
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.selectedRecipeIndex.m_6422_(pId);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    public void m_6199_(Container pInventory) {
        ItemStack itemstack = this.inputSlot.m_7993_();
        this.setupRecipeList(pInventory, itemstack);
        this.input = itemstack.m_41777_();
    }

    private void setupRecipeList(Container pContainer, ItemStack pStack) {
        this.recipes = new ArrayList<WoodcutterRecipe>();
        if (!this.input.m_41656_(pStack)) {
            if (!(this.input.m_150930_(Items.f_41852_) || this.input.m_150930_(this.lastInput.m_41720_()) || this.lastInput.m_150930_(Items.f_41852_))) {
                this.selectedRecipeIndex.m_6422_(-1);
            }
            if (!this.input.m_150930_(this.lastInput.m_41720_())) {
                this.lastInput = this.input;
            }
        }
        if (!pStack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_((RecipeType)WoodcutterRecipe.Type.INSTANCE, pContainer, this.level);
            this.recipes = this.recipes.stream().filter(craftingRecipe -> this.container.m_8020_(0).m_41613_() >= craftingRecipe.ingredientCount).toList();
        }
        if (this.recipesSize != this.recipes.size() && this.selectedRecipeIndex.m_6501_() != -1) {
            for (int i = 0; i < this.recipes.size(); ++i) {
                if (this.recipes.get(i) != this.lastUsedRecipe) continue;
                this.selectedRecipeIndex.m_6422_(i);
                break;
            }
        }
        this.recipesSize = this.recipes.size();
        if (!this.input.m_41656_(pStack) || pStack.m_41613_() != this.input.m_41613_()) {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
            if (this.lastInput.m_150930_(Items.f_41852_)) {
                this.setupResultSlot();
            }
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            WoodcutterRecipe woodcutterrecipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            this.resultContainer.m_6029_((Recipe)woodcutterrecipe);
            this.lastUsedRecipe = woodcutterrecipe;
            this.resultSlot.m_5852_(woodcutterrecipe.m_5874_(this.container));
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.lastNonAirInput = this.input;
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)ModContainers.WOODCUTTER_CONTAINER.get();
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.resultContainer && super.m_5882_(pStack, pSlot);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 1) {
                item.m_7836_(itemstack1, pPlayer.f_19853_, pPlayer);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.level.m_7465_().m_44015_((RecipeType)WoodcutterRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.m_38903_(itemstack1, 0, 1, false) : (pIndex >= 2 && pIndex < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : pIndex >= 29 && pIndex < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((p_40313_, p_40314_) -> this.m_150411_(pPlayer, this.container));
    }
}

