/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.connected.Waxed;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;

public class ConnectingCarpet
extends CarpetBlock
implements Waxed {
    VoxelShape TOP = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    VoxelShape CORNER = Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0);
    VoxelShape CORNER_90 = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0);
    VoxelShape CORNER_180 = Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0);
    VoxelShape CORNER_270 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0);
    VoxelShape INSIDE_CORNER = Stream.of(Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0), Block.m_49796_((double)11.0, (double)6.0, (double)1.0, (double)16.0, (double)9.0, (double)4.0), Block.m_49796_((double)12.0, (double)6.0, (double)0.0, (double)15.0, (double)9.0, (double)5.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    VoxelShape INSIDE_CORNER_90 = Stream.of(Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)12.0, (double)6.0, (double)11.0, (double)15.0, (double)9.0, (double)16.0), Block.m_49796_((double)11.0, (double)6.0, (double)12.0, (double)16.0, (double)9.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    VoxelShape INSIDE_CORNER_180 = Stream.of(Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)5.0, (double)9.0, (double)15.0), Block.m_49796_((double)1.0, (double)6.0, (double)11.0, (double)4.0, (double)9.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    VoxelShape INSIDE_CORNER_270 = Stream.of(Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)6.0, (double)0.0, (double)4.0, (double)9.0, (double)5.0), Block.m_49796_((double)0.0, (double)6.0, (double)1.0, (double)5.0, (double)9.0, (double)4.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    VoxelShape END = Block.m_49796_((double)0.0, (double)6.0, (double)1.0, (double)16.0, (double)9.0, (double)4.0);
    VoxelShape END_90 = Block.m_49796_((double)12.0, (double)6.0, (double)0.0, (double)15.0, (double)9.0, (double)16.0);
    VoxelShape END_180 = Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)16.0, (double)9.0, (double)15.0);
    VoxelShape END_270 = Block.m_49796_((double)1.0, (double)6.0, (double)0.0, (double)4.0, (double)9.0, (double)16.0);
    public static BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final EnumProperty<North> NORTH = EnumProperty.m_61587_((String)"north", North.class);
    public static final EnumProperty<South> SOUTH = EnumProperty.m_61587_((String)"south", South.class);

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos blockpos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        Item item = player.m_21120_(pHand).m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            DyeColor dyecolor = dyeItem.m_41089_();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, blockpos, player.m_21120_(pHand));
            }
            BlockState newBlockstate = ConnectingCarpet.getBlockByColor(dyecolor).m_49966_();
            if (!player.m_7500_()) {
                player.m_21120_(pHand).m_41774_(1);
            }
            if (!player.m_7500_() && pState.m_60734_() == ModBlocks.INFUSED_FABRIC_CARPET_ORNATE.get()) {
                Block.m_49840_((Level)pLevel, (BlockPos)blockpos, (ItemStack)new ItemStack((ItemLike)Items.f_42587_));
            }
            pLevel.m_46597_(blockpos, newBlockstate);
            pLevel.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newBlockstate));
            pLevel.m_5898_(player, 3003, blockpos, 0);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (player.m_21120_(pHand).m_41720_() == Items.f_42587_) {
            if (pState.m_60734_() == ModBlocks.INFUSED_FABRIC_CARPET_ORNATE.get()) {
                return InteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, blockpos, player.m_21120_(pHand));
            }
            BlockState newBlockstate = ((ConnectingCarpet)ModBlocks.INFUSED_FABRIC_CARPET_ORNATE.get()).m_49966_();
            if (!player.m_7500_()) {
                player.m_21120_(pHand).m_41774_(1);
            }
            pLevel.m_46597_(blockpos, newBlockstate);
            pLevel.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newBlockstate));
            pLevel.m_5898_(player, 3004, blockpos, 0);
            pLevel.m_5594_(player, blockpos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, blockpos, player, pHand, pHit);
    }

    public static Block getBlockByColor(@Nullable DyeColor pColor) {
        if (pColor == null) {
            return Blocks.f_50456_;
        }
        switch (pColor) {
            case WHITE: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_WHITE.get();
            }
            case ORANGE: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_ORANGE.get();
            }
            case MAGENTA: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_MAGENTA.get();
            }
            case LIGHT_BLUE: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_LIGHT_BLUE.get();
            }
            case YELLOW: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_YELLOW.get();
            }
            case LIME: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_LIME.get();
            }
            case PINK: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_PINK.get();
            }
            case GRAY: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_GRAY.get();
            }
            case LIGHT_GRAY: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_LIGHT_GRAY.get();
            }
            case CYAN: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_CYAN.get();
            }
            default: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_PURPLE.get();
            }
            case BLUE: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_BLUE.get();
            }
            case BROWN: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_BROWN.get();
            }
            case GREEN: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_GREEN.get();
            }
            case RED: {
                return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_RED.get();
            }
            case BLACK: 
        }
        return (Block)ModBlocks.INFUSED_FABRIC_CARPET_DYED_BLACK.get();
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        return this.getUnWaxed(state, context, toolAction);
    }

    public ConnectingCarpet(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_(NORTH, (Comparable)((Object)North.NONE))).m_61124_(SOUTH, (Comparable)((Object)South.NONE)));
    }

    protected BlockState updateCorners(BlockGetter world, BlockPos pos, BlockState state) {
        BlockState bs_north = world.m_8055_(pos.m_122012_());
        BlockState bs_north_east = world.m_8055_(pos.m_122012_().m_122029_());
        BlockState bs_north_west = world.m_8055_(pos.m_122012_().m_122024_());
        BlockState bs_east = world.m_8055_(pos.m_122029_());
        BlockState bs_south = world.m_8055_(pos.m_122019_());
        BlockState bs_south_east = world.m_8055_(pos.m_122019_().m_122029_());
        BlockState bs_south_west = world.m_8055_(pos.m_122019_().m_122024_());
        BlockState bs_west = world.m_8055_(pos.m_122024_());
        North north = North.NONE;
        South south = South.NONE;
        if (bs_north.m_60734_() == this) {
            north = North.JUST_NORTH;
            if (bs_north_west.m_60734_() == this && bs_north_east.m_60734_() != this) {
                north = North.NORTH_AND_NORTH_WEST;
            }
            if (bs_north_west.m_60734_() != this && bs_north_east.m_60734_() == this) {
                north = North.NORTH_AND_NORTH_EAST;
            }
            if (bs_north_west.m_60734_() == this && bs_north_east.m_60734_() == this) {
                north = North.ALL;
            }
        } else {
            if (bs_north_west.m_60734_() == this && bs_north_east.m_60734_() != this) {
                north = North.JUST_NORTH_WEST;
            }
            if (bs_north_west.m_60734_() != this && bs_north_east.m_60734_() == this) {
                north = North.JUST_NORTH_EAST;
            }
        }
        if (bs_south.m_60734_() == this) {
            south = South.JUST_SOUTH;
            if (bs_south_west.m_60734_() == this && bs_south_east.m_60734_() != this) {
                south = South.SOUTH_AND_SOUTH_WEST;
            }
            if (bs_south_west.m_60734_() != this && bs_south_east.m_60734_() == this) {
                south = South.SOUTH_AND_SOUTH_EAST;
            }
            if (bs_south_west.m_60734_() == this && bs_south_east.m_60734_() == this) {
                south = South.ALL;
            }
        } else {
            if (bs_south_west.m_60734_() == this && bs_south_east.m_60734_() != this) {
                south = South.JUST_SOUTH_WEST;
            }
            if (bs_south_west.m_60734_() != this && bs_south_east.m_60734_() == this) {
                south = South.JUST_SOUTH_EAST;
            }
        }
        boolean east = bs_east.m_60734_() == this;
        boolean west = bs_west.m_60734_() == this;
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_(SOUTH, (Comparable)((Object)south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return this.updateCorners((BlockGetter)iblockreader, blockpos, super.m_5573_(context));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WEST, EAST, NORTH, SOUTH});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : this.updateCorners((BlockGetter)world, pos, state);
    }

    public static enum North implements StringRepresentable
    {
        JUST_NORTH,
        NORTH_AND_NORTH_WEST,
        NORTH_AND_NORTH_EAST,
        JUST_NORTH_WEST,
        JUST_NORTH_EAST,
        NORTH_EAST_AND_NORTH_WEST,
        ALL,
        NONE;


        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case JUST_NORTH -> "north";
                case NORTH_AND_NORTH_WEST -> "north_and_north_west";
                case NORTH_AND_NORTH_EAST -> "north_and_north_east";
                case JUST_NORTH_WEST -> "north_west";
                case JUST_NORTH_EAST -> "north_east";
                case NORTH_EAST_AND_NORTH_WEST -> "north_east_and_north_west";
                case ALL -> "all";
                case NONE -> "none";
            };
        }
    }

    public static enum South implements StringRepresentable
    {
        JUST_SOUTH,
        SOUTH_AND_SOUTH_WEST,
        SOUTH_AND_SOUTH_EAST,
        JUST_SOUTH_WEST,
        JUST_SOUTH_EAST,
        SOUTH_EAST_AND_SOUTH_WEST,
        ALL,
        NONE;


        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case JUST_SOUTH -> "south";
                case SOUTH_AND_SOUTH_WEST -> "south_and_south_west";
                case SOUTH_AND_SOUTH_EAST -> "south_and_south_east";
                case JUST_SOUTH_WEST -> "south_west";
                case JUST_SOUTH_EAST -> "south_east";
                case SOUTH_EAST_AND_SOUTH_WEST -> "south_east_and_south_west";
                case ALL -> "all";
                case NONE -> "none";
            };
        }
    }
}

