/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.impl.TurtleRefuelHandlers;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;

public class TurtleRefuelCommand
implements ITurtleCommand {
    private final int limit;

    public TurtleRefuelCommand(int limit) {
        this.limit = limit;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        int slot = turtle.getSelectedSlot();
        ItemStack stack = turtle.getInventory().m_8020_(slot);
        if (stack.m_41619_()) {
            return TurtleCommandResult.failure("No items to combust");
        }
        OptionalInt refuelled = TurtleRefuelHandlers.refuel(turtle, stack, slot, this.limit);
        if (refuelled.isEmpty()) {
            return TurtleCommandResult.failure("Items not combustible");
        }
        int newFuel = refuelled.getAsInt();
        if (newFuel != 0) {
            turtle.addFuel(newFuel);
            turtle.playAnimation(TurtleAnimation.WAIT);
        }
        return TurtleCommandResult.success();
    }
}

