/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.methods;

import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.generic.methods.ArgumentHelpers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class InventoryMethods
implements GenericPeripheral {
    @Override
    @Nonnull
    public PeripheralType getType() {
        return PeripheralType.ofAdditional("inventory");
    }

    @Override
    @Nonnull
    public ResourceLocation id() {
        return new ResourceLocation("computercraft", "inventory");
    }

    @LuaFunction(mainThread=true)
    public static int size(IItemHandler inventory) {
        return inventory.getSlots();
    }

    @LuaFunction(mainThread=true)
    public static Map<Integer, Map<String, ?>> list(IItemHandler inventory) {
        HashMap result = new HashMap();
        int size = inventory.getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            result.put(i + 1, VanillaDetailRegistries.ITEM_STACK.getBasicDetails(stack));
        }
        return result;
    }

    @Nullable
    @LuaFunction(mainThread=true)
    public static Map<String, ?> getItemDetail(IItemHandler inventory, int slot) throws LuaException {
        ArgumentHelpers.assertBetween(slot, 1, inventory.getSlots(), "Slot out of range (%s)");
        ItemStack stack = inventory.getStackInSlot(slot - 1);
        return stack.m_41619_() ? null : VanillaDetailRegistries.ITEM_STACK.getDetails(stack);
    }

    @LuaFunction(mainThread=true)
    public static int getItemLimit(IItemHandler inventory, int slot) throws LuaException {
        ArgumentHelpers.assertBetween(slot, 1, inventory.getSlots(), "Slot out of range (%s)");
        return inventory.getSlotLimit(slot - 1);
    }

    @LuaFunction(mainThread=true)
    public static int pushItems(IItemHandler from, IComputerAccess computer, String toName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IItemHandler to = InventoryMethods.extractHandler(location.getTarget());
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween(fromSlot, 1, from.getSlots(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween(toSlot.get(), 1, to.getSlots(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return InventoryMethods.moveItem(from, fromSlot - 1, to, toSlot.orElse(0) - 1, actualLimit);
    }

    @LuaFunction(mainThread=true)
    public static int pullItems(IItemHandler to, IComputerAccess computer, String fromName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IItemHandler from = InventoryMethods.extractHandler(location.getTarget());
        if (from == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween(fromSlot, 1, from.getSlots(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween(toSlot.get(), 1, to.getSlots(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return InventoryMethods.moveItem(from, fromSlot - 1, to, toSlot.orElse(0) - 1, actualLimit);
    }

    @Nullable
    private static IItemHandler extractHandler(@Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        int inserted;
        ItemStack extracted = from.extractItem(fromSlot, limit, true);
        if (extracted.m_41619_()) {
            return 0;
        }
        int extractCount = Math.min(extracted.m_41613_(), limit);
        extracted.m_41764_(extractCount);
        ItemStack remainder = toSlot < 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false) : to.insertItem(toSlot, extracted, false);
        int n = inserted = remainder.m_41619_() ? extractCount : extractCount - remainder.m_41613_();
        if (inserted <= 0) {
            return 0;
        }
        from.extractItem(fromSlot, inserted, false);
        return inserted;
    }
}

