/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.inventory;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class IEItemStackHandler
extends ItemStackHandler
implements ICapabilityProvider {
    @Nonnull
    private Runnable onChange = () -> {};
    private final LazyOptional<IItemHandler> thisOpt = CapabilityUtils.constantOptional(this);

    public IEItemStackHandler(ItemStack stack) {
        int idealSize = ((InternalStorageItem)stack.m_41720_()).getSlotCount();
        NonNullList newList = NonNullList.m_122780_((int)idealSize, (Object)ItemStack.f_41583_);
        for (int i = 0; i < Math.min(this.stacks.size(), idealSize); ++i) {
            newList.set(i, (Object)((ItemStack)this.stacks.get(i)));
        }
        this.stacks = newList;
    }

    public void setTile(BlockEntity tile) {
        this.onChange = tile != null ? () -> ((BlockEntity)tile).m_6596_() : () -> {};
    }

    public void setInventoryForUpdate(Container inv) {
        this.onChange = inv != null ? () -> ((Container)inv).m_6596_() : () -> {};
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.onChange.run();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(capability, this.thisOpt);
    }

    public NonNullList<ItemStack> getContainedItems() {
        return this.stacks;
    }
}

