/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.client.utils.FontUtils;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.entities.RevolvershotFlareEntity;
import blusunrize.immersiveengineering.common.entities.RevolvershotHomingEntity;
import blusunrize.immersiveengineering.common.entities.WolfpackShotEntity;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;

public class BulletItem
extends IEBaseItem
implements IEItemInterfaces.IColouredItem {
    public static final ResourceLocation CASULL = new ResourceLocation("immersiveengineering", "casull");
    public static final ResourceLocation ARMOR_PIERCING = new ResourceLocation("immersiveengineering", "armor_piercing");
    public static final ResourceLocation BUCKSHOT = new ResourceLocation("immersiveengineering", "buckshot");
    public static final ResourceLocation HIGH_EXPLOSIVE = new ResourceLocation("immersiveengineering", "he");
    public static final ResourceLocation SILVER = new ResourceLocation("immersiveengineering", "silver");
    public static final ResourceLocation DRAGONS_BREATH = new ResourceLocation("immersiveengineering", "dragons_breath");
    public static final ResourceLocation POTION = new ResourceLocation("immersiveengineering", "potion");
    public static final ResourceLocation FLARE = new ResourceLocation("immersiveengineering", "flare");
    public static final ResourceLocation FIREWORK = new ResourceLocation("immersiveengineering", "firework");
    public static final ResourceLocation HOMING = new ResourceLocation("immersiveengineering", "homing");
    public static final ResourceLocation WOLFPACK = new ResourceLocation("immersiveengineering", "wolfpack");
    public static final ResourceLocation WOLFPACK_PART = new ResourceLocation("immersiveengineering", "wolfpack_part");
    private final BulletHandler.IBullet type;

    public BulletItem(BulletHandler.IBullet type) {
        this.type = type;
    }

    public static void initBullets() {
        BulletHandler.registerBullet(CASULL, new BulletHandler.DamagingBullet((projectile, shooter, hit) -> IEDamageSources.causeCasullDamage((RevolvershotEntity)projectile, shooter), () -> ((ForgeConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Casull).get(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing.m_5456_().m_7968_()), new ResourceLocation("immersiveengineering:item/bullet_casull")));
        BulletHandler.registerBullet(ARMOR_PIERCING, new BulletHandler.DamagingBullet((projectile, shooter, hit) -> IEDamageSources.causePiercingDamage((RevolvershotEntity)projectile, shooter), () -> ((ForgeConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_AP).get(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing.m_5456_().m_7968_()), new ResourceLocation("immersiveengineering:item/bullet_armor_piercing")));
        BulletHandler.registerBullet(BUCKSHOT, new BulletHandler.DamagingBullet((projectile, shooter, hit) -> IEDamageSources.causeBuckshotDamage((RevolvershotEntity)projectile, shooter), () -> ((ForgeConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Buck).get(), true, false, () -> BulletHandler.emptyShell.m_5456_().m_7968_(), new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_buckshot")}){

            @Override
            public int getProjectileCount(Player shooter) {
                return 10;
            }
        });
        BulletHandler.registerBullet(HIGH_EXPLOSIVE, new BulletHandler.DamagingBullet(null, 0.0f, () -> BulletHandler.emptyCasing.m_5456_().m_7968_(), new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_he")}){

            @Override
            public void onHitTarget(Level world, HitResult target, UUID shooterId, Entity projectile, boolean headshot) {
                Player shooter = null;
                if (shooterId != null) {
                    shooter = world.m_46003_(shooterId);
                }
                world.m_46511_((Entity)shooter, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), 2.0f, Explosion.BlockInteraction.NONE);
            }

            @Override
            public Entity getProjectile(@Nullable Player shooter, ItemStack cartridge, Entity projectile, boolean charged) {
                if (projectile instanceof RevolvershotEntity) {
                    ((RevolvershotEntity)projectile).setGravity(0.05f);
                    ((RevolvershotEntity)projectile).setMovementDecay(0.9f);
                }
                return projectile;
            }

            @Override
            public SoundEvent getSound() {
                return (SoundEvent)IESounds.revolverFireThump.get();
            }
        });
        BulletHandler.registerBullet(SILVER, new BulletHandler.DamagingBullet((projectile, shooter, hit) -> IEDamageSources.causeSilverDamage((RevolvershotEntity)projectile, shooter), () -> ((ForgeConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Silver).get(), () -> BulletHandler.emptyCasing.m_5456_().m_7968_(), new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_silver")}){

            @Override
            protected float getDamage(Entity hitEntity, boolean headshot) {
                float dmg = super.getDamage(hitEntity, headshot);
                if (hitEntity instanceof LivingEntity && ((LivingEntity)hitEntity).m_21222_()) {
                    dmg = (float)((double)dmg * 1.5);
                }
                return dmg;
            }
        });
        BulletHandler.registerBullet(DRAGONS_BREATH, new BulletHandler.DamagingBullet((projectile, shooter, hit) -> IEDamageSources.causeDragonsbreathDamage((RevolvershotEntity)projectile, shooter), () -> ((ForgeConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Dragon).get(), true, true, () -> BulletHandler.emptyShell.m_5456_().m_7968_(), new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_dragons_breath")}){

            @Override
            public int getProjectileCount(Player shooter) {
                return 30;
            }

            @Override
            public Entity getProjectile(Player shooter, ItemStack cartridge, Entity projectile, boolean electro) {
                ((RevolvershotEntity)projectile).setTickLimit(10);
                projectile.m_20254_(3);
                return projectile;
            }
        });
        BulletHandler.registerBullet(POTION, new PotionBullet());
        BulletHandler.registerBullet(FLARE, new FlareBullet());
        BulletHandler.registerBullet(FIREWORK, new FireworkBullet());
        BulletHandler.registerBullet(HOMING, new HomingBullet(() -> ((ForgeConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Homing).get(), new ResourceLocation("immersiveengineering:item/bullet_homing")));
        BulletHandler.registerBullet(WOLFPACK, new WolfpackBullet());
        BulletHandler.registerBullet(WOLFPACK_PART, new WolfpackPartBullet());
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        this.type.addTooltip(stack, world, list, flag);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Object s = "item.immersiveengineering.bullet.";
        String key = Registry.f_122827_.m_7981_((Object)this).m_135815_();
        s = (String)s + key;
        s = this.type.getTranslationKey(stack, (String)s);
        return Component.m_237115_((String)s);
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        return this.type.getColour(stack, pass);
    }

    public BulletHandler.IBullet getType() {
        return this.type;
    }

    public static class PotionBullet
    extends BulletHandler.DamagingBullet {
        public PotionBullet() {
            super((Entity projectile, Entity shooter, Entity hit) -> IEDamageSources.causePotionDamage((RevolvershotEntity)projectile, shooter), () -> ((ForgeConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Potion).get(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing.m_5456_().m_7968_()), new ResourceLocation("immersiveengineering:item/bullet_potion"), new ResourceLocation("immersiveengineering:item/bullet_potion_layer"));
        }

        @Override
        public String getTranslationKey(ItemStack cartridge, String baseName) {
            ItemStack pot = ItemNBTHelper.getItemStack(cartridge, "potion");
            if (!pot.m_41619_()) {
                if (pot.m_41720_() instanceof LingeringPotionItem) {
                    baseName = (String)baseName + ".linger";
                } else if (pot.m_41720_() instanceof SplashPotionItem) {
                    baseName = (String)baseName + ".splash";
                }
            }
            return baseName;
        }

        @Override
        public Entity getProjectile(Player shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            ((RevolvershotEntity)projectile).bulletPotion = ItemNBTHelper.getItemStack(cartridge, "potion");
            return projectile;
        }

        @Override
        public void onHitTarget(Level world, HitResult target, UUID shooterUUID, Entity projectile, boolean headshot) {
            super.onHitTarget(world, target, shooterUUID, projectile, headshot);
            RevolvershotEntity bullet = (RevolvershotEntity)projectile;
            if (!bullet.bulletPotion.m_41619_() && bullet.bulletPotion.m_41782_()) {
                Potion potionType = PotionUtils.m_43579_((ItemStack)bullet.bulletPotion);
                List effects = PotionUtils.m_43547_((ItemStack)bullet.bulletPotion);
                Player shooter = null;
                if (shooterUUID != null) {
                    shooter = world.m_46003_(shooterUUID);
                }
                if (effects != null) {
                    if (bullet.bulletPotion.m_41720_() instanceof LingeringPotionItem) {
                        AreaEffectCloud entityareaeffectcloud = new AreaEffectCloud(bullet.f_19853_, bullet.m_20185_(), bullet.m_20186_(), bullet.m_20189_());
                        entityareaeffectcloud.m_19718_((LivingEntity)shooter);
                        entityareaeffectcloud.m_19712_(3.0f);
                        entityareaeffectcloud.m_19732_(-0.5f);
                        entityareaeffectcloud.m_19740_(10);
                        entityareaeffectcloud.m_19738_(-entityareaeffectcloud.m_19743_() / (float)entityareaeffectcloud.m_19748_());
                        entityareaeffectcloud.m_19722_(potionType);
                        for (MobEffectInstance potioneffect : effects) {
                            entityareaeffectcloud.m_19716_(new MobEffectInstance(potioneffect.m_19544_(), potioneffect.m_19557_(), potioneffect.m_19564_()));
                        }
                        bullet.f_19853_.m_7967_((Entity)entityareaeffectcloud);
                    } else if (bullet.bulletPotion.m_41720_() instanceof SplashPotionItem) {
                        List livingEntities = bullet.f_19853_.m_45976_(LivingEntity.class, bullet.m_20191_().m_82377_(4.0, 2.0, 4.0));
                        if (livingEntities != null && !livingEntities.isEmpty()) {
                            for (LivingEntity living : livingEntities) {
                                double dist;
                                if (!living.m_5801_() || !((dist = bullet.m_20280_((Entity)living)) < 16.0)) continue;
                                double dist2 = 1.0 - Math.sqrt(dist) / 4.0;
                                if (target instanceof EntityHitResult && living == ((EntityHitResult)target).m_82443_()) {
                                    dist2 = 1.0;
                                }
                                for (MobEffectInstance p : effects) {
                                    if (p.m_19544_().m_8093_()) {
                                        p.m_19544_().m_19461_((Entity)bullet, (Entity)shooter, living, p.m_19564_(), dist2);
                                        continue;
                                    }
                                    int j = (int)(dist2 * (double)p.m_19557_() + 0.5);
                                    if (j <= 20) continue;
                                    living.m_7292_(new MobEffectInstance(p.m_19544_(), j, p.m_19564_()));
                                }
                            }
                        }
                    } else if (target instanceof EntityHitResult && ((EntityHitResult)target).m_82443_() instanceof LivingEntity) {
                        for (MobEffectInstance p : effects) {
                            if (p.m_19557_() < 1) {
                                p = new MobEffectInstance(p.m_19544_(), 1);
                            }
                            ((LivingEntity)((EntityHitResult)target).m_82443_()).m_7292_(p);
                        }
                    }
                }
                world.m_46796_(2002, bullet.m_20183_(), PotionUtils.m_43559_((Potion)potionType));
            }
        }

        @Override
        public void addTooltip(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
            ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
            if (!pot.m_41619_() && pot.m_41720_() instanceof PotionItem) {
                PotionUtils.m_43555_((ItemStack)pot, list, (float)1.0f);
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            if (layer == 1) {
                ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
                return pot.m_41619_() ? -13083194 : PotionUtils.m_43564_((Collection)PotionUtils.m_43547_((ItemStack)pot));
            }
            return -1;
        }
    }

    public static class FlareBullet
    implements BulletHandler.IBullet {
        static ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_flare"), new ResourceLocation("immersiveengineering:item/bullet_flare_layer")};

        @Override
        public Entity getProjectile(Player shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            RevolvershotFlareEntity flare = shooter != null ? new RevolvershotFlareEntity(projectile.f_19853_, (LivingEntity)shooter, projectile.m_20184_().f_82479_ * 1.5, projectile.m_20184_().f_82480_ * 1.5, projectile.m_20184_().f_82481_ * 1.5, this, cartridge) : new RevolvershotFlareEntity(projectile.f_19853_, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), 0.0, 0.0, 0.0, this);
            flare.m_20256_(projectile.m_20184_());
            flare.bulletElectro = electro;
            flare.colour = this.getColour(cartridge, 1);
            flare.setColourSynced();
            return flare;
        }

        @Override
        public void onHitTarget(Level world, HitResult target, UUID shooter, Entity projectile, boolean headshot) {
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return BulletHandler.emptyShell.m_5456_().m_7968_();
        }

        @Override
        public ResourceLocation[] getTextures() {
            return textures;
        }

        @Override
        public void addTooltip(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
            if (stack.m_41720_() instanceof IEItemInterfaces.IColouredItem) {
                int color = ((IEItemInterfaces.IColouredItem)stack.m_41720_()).getColourForIEItem(stack, 1);
                list.add((Component)FontUtils.withAppendColoredColour(Component.m_237115_((String)"desc.immersiveengineering.info.bullet.flareColour"), color));
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            if (layer != 1) {
                return -1;
            }
            return ItemNBTHelper.hasKey(stack, "flareColour") ? ItemNBTHelper.getInt(stack, "flareColour") : 13381126;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }
    }

    public static class FireworkBullet
    implements BulletHandler.IBullet {
        static ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_firework")};

        @Override
        public Entity getProjectile(Player shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            ItemStack fireworkStack = new ItemStack((ItemLike)Items.f_42688_);
            fireworkStack.m_41751_(cartridge.m_41782_() ? cartridge.m_41783_().m_6426_() : null);
            FireworkRocketEntity firework = new FireworkRocketEntity(projectile.f_19853_, fireworkStack, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), true);
            Vec3 vector = projectile.m_20184_();
            firework.m_6686_(vector.m_7096_(), vector.m_7098_(), vector.m_7094_(), 1.6f, 1.0f);
            return firework;
        }

        @Override
        public SoundEvent getSound() {
            return (SoundEvent)IESounds.revolverFireThump.get();
        }

        @Override
        public void onHitTarget(Level world, HitResult target, UUID shooter, Entity projectile, boolean headshot) {
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return BulletHandler.emptyShell.m_5456_().m_7968_();
        }

        @Override
        public ResourceLocation[] getTextures() {
            return textures;
        }

        @Override
        public void addTooltip(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
            Items.f_42688_.m_7373_(stack, world, list, flag);
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }
    }

    public static class HomingBullet
    extends BulletHandler.DamagingBullet {
        public HomingBullet(DoubleSupplier damage, ResourceLocation ... textures) {
            super((Entity projectile, Entity shooter, Entity hit) -> IEDamageSources.causeHomingDamage((RevolvershotEntity)projectile, shooter), damage, (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing.m_5456_().m_7968_()), textures);
        }

        @Override
        public Entity getProjectile(Player shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            RevolvershotHomingEntity shot = shooter != null ? new RevolvershotHomingEntity(projectile.f_19853_, (LivingEntity)shooter, projectile.m_20184_().f_82479_ * 1.5, projectile.m_20184_().f_82480_ * 1.5, projectile.m_20184_().f_82481_ * 1.5, this) : new RevolvershotHomingEntity(projectile.f_19853_, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), 0.0, 0.0, 0.0, this);
            shot.m_20256_(projectile.m_20184_());
            shot.bulletElectro = electro;
            return shot;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class WolfpackBullet
    extends BulletHandler.DamagingBullet {
        public WolfpackBullet() {
            super((Entity projectile, Entity shooter, Entity hit) -> IEDamageSources.causeWolfpackDamage((RevolvershotEntity)projectile, shooter), () -> ((ForgeConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Wolfpack).get(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyShell.m_5456_().m_7968_()), new ResourceLocation("immersiveengineering:item/bullet_wolfpack"));
        }

        @Override
        public void onHitTarget(Level world, HitResult target, UUID shooter, Entity projectile, boolean headshot) {
            super.onHitTarget(world, target, shooter, projectile, headshot);
            Vec3 v = projectile.m_20184_().m_82490_(-1.0);
            int split = 6;
            for (int i = 0; i < split; ++i) {
                EntityHitResult eTarget;
                float angle = (float)i * (360.0f / (float)split);
                Matrix4 matrix = new Matrix4();
                matrix.rotate(angle, v.f_82479_, v.f_82480_, v.f_82481_);
                Vec3 vecDir = new Vec3(0.0, 1.0, 0.0);
                vecDir = matrix.apply(vecDir);
                Player player = shooter != null ? world.m_46003_(shooter) : null;
                WolfpackShotEntity bullet = player != null ? new WolfpackShotEntity(world, (LivingEntity)player, vecDir.f_82479_ * 1.5, vecDir.f_82480_ * 1.5, vecDir.f_82481_ * 1.5, this) : new WolfpackShotEntity(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this);
                if (target instanceof EntityHitResult && (eTarget = (EntityHitResult)target).m_82443_() instanceof LivingEntity) {
                    bullet.targetOverride = (LivingEntity)eTarget.m_82443_();
                }
                bullet.m_6034_(target.m_82450_().f_82479_ + vecDir.f_82479_, target.m_82450_().f_82480_ + vecDir.f_82480_, target.m_82450_().f_82481_ + vecDir.f_82481_);
                bullet.m_20256_(vecDir.m_82490_(0.375));
                world.m_7967_((Entity)bullet);
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class WolfpackPartBullet
    extends BulletHandler.DamagingBullet {
        public WolfpackPartBullet() {
            super((Entity projectile, Entity shooter, Entity hit) -> IEDamageSources.causeWolfpackDamage((RevolvershotEntity)projectile, shooter), () -> ((ForgeConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_WolfpackPart).get(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing.m_5456_().m_7968_()), new ResourceLocation("immersiveengineering:item/bullet_wolfpack"));
        }

        @Override
        public boolean isProperCartridge() {
            return false;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }
}

