/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;

public class RailgunShotEntity
extends IEProjectileEntity {
    private ItemStack ammo = ItemStack.f_41583_;
    private static final EntityDataAccessor<ItemStack> dataMarker_ammo = SynchedEntityData.m_135353_(RailgunShotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private RailgunHandler.IRailgunProjectile ammoProperties;

    public RailgunShotEntity(EntityType<RailgunShotEntity> type, Level world) {
        super(type, world);
        this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
    }

    public RailgunShotEntity(Level world, @Nonnull LivingEntity living, float velocity, float accuracy, ItemStack ammo) {
        super((EntityType<? extends IEProjectileEntity>)((EntityType)IEEntityTypes.RAILGUN_SHOT.get()), world, living, velocity, accuracy);
        this.ammo = ammo;
        this.setAmmoSynced();
        this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(dataMarker_ammo, (Object)ItemStack.f_41583_);
    }

    @Override
    @Nonnull
    protected ItemStack m_7941_() {
        return this.ammo;
    }

    public void setAmmoSynced() {
        if (!this.getAmmo().m_41619_()) {
            this.f_19804_.m_135381_(dataMarker_ammo, (Object)this.getAmmo());
        }
    }

    public ItemStack getAmmoSynced() {
        return (ItemStack)this.f_19804_.m_135370_(dataMarker_ammo);
    }

    public ItemStack getAmmo() {
        return this.ammo;
    }

    public RailgunHandler.IRailgunProjectile getProjectileProperties() {
        if (this.ammoProperties == null && !this.ammo.m_41619_()) {
            this.ammoProperties = RailgunHandler.getProjectile(this.ammo);
        }
        return this.ammoProperties;
    }

    @Override
    public double getGravity() {
        return 0.005 * (this.getProjectileProperties() != null ? this.getProjectileProperties().getGravity() : 1.0);
    }

    @Override
    public int getMaxTicksInGround() {
        return 500;
    }

    public void m_6075_() {
        if (this.getAmmo().m_41619_() && this.f_19853_.f_46443_) {
            this.ammo = this.getAmmoSynced();
        }
        super.m_6075_();
    }

    @Override
    public void m_6532_(HitResult mop) {
        if (!this.f_19853_.f_46443_ && !this.getAmmo().m_41619_()) {
            RailgunHandler.IRailgunProjectile projectileProperties = this.getProjectileProperties();
            if (projectileProperties != null) {
                double breakRoll;
                Entity shooter = this.m_37282_();
                UUID shooterUuid = this.getShooterUUID();
                if (mop instanceof EntityHitResult) {
                    Entity hit = ((EntityHitResult)mop).m_82443_();
                    double damage = projectileProperties.getDamage(this.f_19853_, hit, shooterUuid, (Entity)this);
                    DamageSource source = projectileProperties.getDamageSource(this.f_19853_, hit, shooterUuid, (Entity)this);
                    if (source == null) {
                        source = IEDamageSources.causeRailgunDamage(this, shooter);
                    }
                    hit.m_6469_(source, (float)(damage * (Double)IEServerConfig.TOOLS.railgun_damage.get()));
                } else if (mop instanceof BlockHitResult && (breakRoll = this.f_19796_.m_188500_()) <= this.getProjectileProperties().getBreakChance(shooterUuid, this.ammo)) {
                    this.m_146870_();
                }
                projectileProperties.onHitTarget(this.f_19853_, mop, shooterUuid, (Entity)this);
            }
            if (mop instanceof BlockHitResult) {
                this.m_8060_((BlockHitResult)mop);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (!this.ammo.m_41619_()) {
            nbt.m_128365_("ammo", (Tag)this.ammo.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.ammo = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ammo"));
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

