/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;

public class BlueprintCraftingRecipeSerializer
extends IERecipeSerializer<BlueprintCraftingRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.WoodenDevices.WORKBENCH);
    }

    @Override
    public BlueprintCraftingRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        String category = GsonHelper.m_13906_((JsonObject)json, (String)"category");
        Lazy<ItemStack> output = BlueprintCraftingRecipeSerializer.readOutput(json.get("result"));
        JsonArray inputs = json.getAsJsonArray("inputs");
        IngredientWithSize[] ingredients = new IngredientWithSize[inputs.size()];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = IngredientWithSize.deserialize(inputs.get(i));
        }
        return IEServerConfig.MACHINES.autoWorkbenchConfig.apply(new BlueprintCraftingRecipe(recipeId, category, output, ingredients));
    }

    @Nullable
    public BlueprintCraftingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String category = buffer.m_130277_();
        Lazy<ItemStack> output = BlueprintCraftingRecipeSerializer.readLazyStack(buffer);
        int inputCount = buffer.readInt();
        IngredientWithSize[] ingredients = new IngredientWithSize[inputCount];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = IngredientWithSize.read(buffer);
        }
        return new BlueprintCraftingRecipe(recipeId, category, output, ingredients);
    }

    public void toNetwork(FriendlyByteBuf buffer, BlueprintCraftingRecipe recipe) {
        buffer.m_130070_(recipe.blueprintCategory);
        BlueprintCraftingRecipeSerializer.writeLazyStack(buffer, recipe.output);
        buffer.writeInt(recipe.inputs.length);
        for (IngredientWithSize ingredient : recipe.inputs) {
            ingredient.write(buffer);
        }
    }
}

