/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.metal.SampleDrillBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.world.level.block.state.BlockState;

public class SampleDrillRenderer
extends IEBlockEntityRenderer<SampleDrillBlockEntity> {
    public static final String NAME = "sample_drill";
    public static DynamicModel DRILL;

    public void render(SampleDrillBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.getLevelNonnull().m_46805_(tile.m_58899_())) {
            return;
        }
        BlockState state = tile.getLevelNonnull().m_8055_(tile.m_58899_());
        if (state.m_60734_() != IEBlocks.MetalDevices.SAMPLE_DRILL.get()) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        int max = (Integer)IEServerConfig.MACHINES.coredrill_time.get();
        if (tile.process > 0 && tile.process < max) {
            float currentProcess = tile.process;
            if (tile.isRunning) {
                currentProcess += partialTicks;
            }
            matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), currentProcess * 22.5f % 360.0f, true));
            float push = (float)tile.process / (float)max;
            if (tile.process > max / 2) {
                push = 1.0f - push;
            }
            matrixStack.m_85837_(0.0, (double)(-2.8f * push), 0.0);
        }
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        List<BakedQuad> quads = DRILL.getNullQuads();
        RenderUtils.renderModelTESRFast(quads, bufferIn.m_6299_(RenderType.m_110451_()), matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.m_85849_();
    }
}

