/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.world;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.item.AstrolabeItem;

public final class AstrolabePreviewHandler {
    public static void onWorldRenderLast(PoseStack ms, RenderBuffers buffers, Level level) {
        MultiBufferSource.BufferSource bufferSource = buffers.m_110104_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderHelper.ASTROLABE_PREVIEW);
        for (Player player : level.m_6907_()) {
            Block block;
            ItemStack currentStack = player.m_21205_();
            if (currentStack.m_41619_() || !(currentStack.m_41720_() instanceof AstrolabeItem)) {
                currentStack = player.m_21206_();
            }
            if (currentStack.m_41619_() || !(currentStack.m_41720_() instanceof AstrolabeItem) || (block = AstrolabeItem.getBlock(currentStack)) == Blocks.f_50016_) continue;
            AstrolabePreviewHandler.renderPlayerLook(ms, buffer, player, currentStack);
        }
        bufferSource.m_109912_(RenderHelper.ASTROLABE_PREVIEW);
    }

    private static void renderPlayerLook(PoseStack ms, VertexConsumer buffer, Player player, ItemStack stack) {
        List<BlockPos> coords = AstrolabeItem.getBlocksToPlace(stack, player);
        if (AstrolabeItem.hasBlocks(stack, player, coords)) {
            BlockState state = AstrolabeItem.getBlockState(stack);
            for (BlockPos coord : coords) {
                AstrolabePreviewHandler.renderBlockAt(ms, buffer, state, coord);
            }
        }
    }

    private static void renderBlockAt(PoseStack ms, VertexConsumer buffer, BlockState state, BlockPos pos) {
        double renderPosX = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_().m_7096_();
        double renderPosY = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_().m_7098_();
        double renderPosZ = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_().m_7094_();
        ms.m_85836_();
        ms.m_85837_(-renderPosX, -renderPosY, -renderPosZ);
        BlockRenderDispatcher brd = Minecraft.m_91087_().m_91289_();
        ms.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        BakedModel model = brd.m_110910_(state);
        int color = Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        brd.m_110937_().m_111067_(ms.m_85850_(), buffer, state, model, r, g, b, 0xF000F0, OverlayTexture.f_118083_);
        ms.m_85849_();
    }
}

