/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.Parsers;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public final class Color {
    private static final Map<String, Integer> nameToColorMap = new HashMap<String, Integer>();

    private static void putRGB(String colorName, int colorRGB) {
        nameToColorMap.put(colorName, 0xFF000000 | colorRGB);
    }

    private Color() {
    }

    public static int parse(String color, int def) {
        Integer result = Parsers.COLOR.apply(color);
        return result != null ? result : def;
    }

    public static int getByName(String name, int def) {
        Integer color = Color.getByName(name);
        return color != null ? color : def;
    }

    @Nullable
    public static Integer getByName(String name) {
        return nameToColorMap.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static int rgbaToInt(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int rgbaToInt(Matcher m) {
        int r = Mth.m_14045_((int)Integer.parseInt(m.group(1)), (int)0, (int)255);
        int g = Mth.m_14045_((int)Integer.parseInt(m.group(2)), (int)0, (int)255);
        int b = Mth.m_14045_((int)Integer.parseInt(m.group(3)), (int)0, (int)255);
        int a = m.groupCount() > 4 ? Mth.m_14045_((int)((int)Double.parseDouble(m.group(4)) * 255), (int)0, (int)255) : 255;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static TextColor toVanilla(int color) {
        return TextColor.m_131266_((int)color);
    }

    static {
        Color.putRGB("aqua", 65535);
        Color.putRGB("black", 0);
        Color.putRGB("blue", 255);
        Color.putRGB("cyan", 65535);
        Color.putRGB("fuchsia", 0xFF00FF);
        Color.putRGB("green", 32768);
        Color.putRGB("ivory", 0xFFFFF0);
        Color.putRGB("lime", 65280);
        Color.putRGB("magenta", 0xFF00FF);
        Color.putRGB("orange", 16753920);
        Color.putRGB("orangered", 16729344);
        Color.putRGB("purple", 0x800080);
        Color.putRGB("red", 0xFF0000);
        Color.putRGB("white", 0xFFFFFF);
        Color.putRGB("yellow", 0xFFFF00);
        Color.putRGB("gray", 0x808080);
        Color.putRGB("darkgray", 0xA9A9A9);
        Color.putRGB("dimgray", 0x696969);
        Color.putRGB("lightgray", 0xD3D3D3);
        Color.putRGB("slategray", 7372944);
        Color.putRGB("darkgreen", 25600);
    }
}

