/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.networking.IGrid;
import appeng.blockentity.networking.EnergyCellBlockEntity;
import appeng.blockentity.storage.SkyStoneTankBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.items.parts.PartItem;
import appeng.me.service.P2PService;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.MEP2PTunnelPart;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.parts.reporting.AbstractPanelPart;
import appeng.parts.reporting.PanelPart;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import appeng.util.SettingsFrom;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.mutable.MutableShort;

public class P2PTestPlots {
    @TestPlot(value="p2p_me")
    public static void me(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PTestPlots.placeTunnel(plot, AEParts.ME_P2P_TUNNEL);
        plot.cable(origin.m_122024_().m_122024_()).part(Direction.WEST, AEParts.IMPORT_BUS);
        plot.chest(origin.m_122024_().m_122024_().m_122024_(), new ItemStack((ItemLike)Items.f_41829_));
        plot.cable(origin.m_122029_().m_122029_()).part(Direction.EAST, AEParts.STORAGE_BUS);
        plot.chest(origin.m_122029_().m_122029_().m_122029_(), new ItemStack[0]);
        plot.part(origin, Direction.UP, AEParts.STORAGE_BUS, storageBus -> storageBus.setPriority(1));
        plot.chest(origin.m_7494_(), new ItemStack[0]);
        plot.cable(origin.m_122029_().m_7494_());
        plot.cable(origin.m_122029_().m_122029_().m_7494_()).part(Direction.WEST, AEParts.QUARTZ_FIBER);
        plot.test(helper -> helper.m_177361_(() -> {
            helper.m_177440_(origin.m_122024_().m_122024_().m_122024_());
            helper.m_177242_(origin.m_122029_().m_122029_().m_122029_(), Items.f_41829_);
        }));
    }

    @TestPlot(value="p2p_items")
    public static void item(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PTestPlots.placeTunnel(plot, AEParts.ITEM_P2P_TUNNEL);
        plot.hopper(origin.m_122024_().m_122024_(), Direction.EAST, new ItemStack((ItemLike)Items.f_41829_));
        BlockPos chestPos = origin.m_122029_().m_122029_();
        plot.chest(chestPos, new ItemStack[0]);
        plot.test(helper -> helper.m_177361_(() -> helper.m_177242_(chestPos, Items.f_41829_)));
    }

    @TestPlot(value="p2p_fluids")
    public static void fluid(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PTestPlots.placeTunnel(plot, AEParts.FLUID_P2P_TUNNEL);
        BlockPos outputPos = origin.m_122029_().m_122029_();
        plot.block(outputPos, AEBlocks.SKY_STONE_TANK);
        plot.cable(origin.m_122024_().m_122024_()).part(Direction.EAST, AEParts.EXPORT_BUS, part -> part.getConfig().addFilter((Fluid)Fluids.f_76193_));
        plot.creativeEnergyCell(origin.m_122024_().m_122024_().m_7495_());
        plot.drive(origin.m_122024_().m_122024_().m_7494_()).addCreativeCell().add((Fluid)Fluids.f_76193_);
        plot.test(helper -> helper.m_177361_(() -> {
            SkyStoneTankBlockEntity tank = (SkyStoneTankBlockEntity)helper.m_177347_(outputPos);
            IFluidTank storage = tank.getStorage();
            helper.check(new FluidStack((Fluid)Fluids.f_76193_, 1).isFluidEqual(storage.getFluid()), "No water stored");
            helper.check(storage.getFluidAmount() > 0, "No amount >0 stored");
        }));
    }

    @TestPlot(value="p2p_energy")
    public static void energy(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PTestPlots.placeTunnel(plot, AEParts.FE_P2P_TUNNEL);
        plot.block(origin.m_122024_().m_122024_(), AEBlocks.DEBUG_ENERGY_GEN);
        plot.block(origin.m_122029_().m_122029_(), AEBlocks.ENERGY_ACCEPTOR);
        BlockPos cellPos = origin.m_122029_().m_122029_().m_7494_();
        plot.block(cellPos, AEBlocks.ENERGY_CELL);
        MutableDouble cellEnergy = new MutableDouble(0.0);
        plot.test(helper -> helper.m_177425_().m_177544_(10).m_177552_(() -> {
            EnergyCellBlockEntity cell = (EnergyCellBlockEntity)helper.m_177347_(cellPos);
            cellEnergy.setValue(cell.getAECurrentPower());
        }).m_177544_(10).m_177552_(() -> {
            EnergyCellBlockEntity cell = (EnergyCellBlockEntity)helper.m_177347_(cellPos);
            helper.check(cell.getAECurrentPower() > cellEnergy.getValue(), "Cell should start charging through the P2P tunnel");
        }).m_177543_());
    }

    @TestPlot(value="p2p_light")
    public static void light(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PTestPlots.placeTunnel(plot, AEParts.LIGHT_P2P_TUNNEL);
        plot.block(origin.m_122024_().m_122024_(), Blocks.f_50261_);
        BlockPos leverPos = origin.m_122024_().m_122024_().m_7494_();
        plot.block(leverPos, Blocks.f_50164_);
        BlockPos outputPos = origin.m_122029_().m_122029_();
        plot.test(helper -> {
            MutableInt lightLevel = new MutableInt(0);
            helper.m_177425_().m_177544_(20).m_177562_(() -> {
                lightLevel.setValue(helper.m_177100_().m_45517_(LightLayer.BLOCK, helper.m_177449_(outputPos)));
                helper.m_177421_(leverPos);
            }).m_177552_(() -> {
                int newLightLevel = helper.m_177100_().m_45517_(LightLayer.BLOCK, helper.m_177449_(outputPos));
                helper.check(newLightLevel > lightLevel.getValue(), "Light-Level didn't increase");
            }).m_177562_(() -> helper.m_177421_(leverPos)).m_177552_(() -> {
                int newLightLevel = helper.m_177100_().m_45517_(LightLayer.BLOCK, helper.m_177449_(outputPos));
                helper.check(newLightLevel <= lightLevel.getValue(), "Light-Level didn't reset");
            }).m_177543_();
        });
    }

    @TestPlot(value="p2p_channel_reconnect_behavior")
    public static void testOutOfChannelReconnectBehavior(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.creativeEnergyCell(origin.m_7495_());
        plot.block(origin, AEBlocks.CONTROLLER);
        plot.cable(origin.m_122024_()).part(Direction.WEST, AEParts.ME_P2P_TUNNEL);
        plot.cable(origin.m_122024_().m_122012_());
        plot.cable(origin.m_122024_().m_122012_().m_122024_());
        plot.cable(origin.m_122024_().m_122012_().m_122024_().m_122019_()).part(Direction.NORTH, AEParts.QUARTZ_FIBER);
        plot.cable(origin.m_122029_()).part(Direction.NORTH, AEParts.TERMINAL).part(Direction.SOUTH, AEParts.TERMINAL).part(Direction.UP, AEParts.TERMINAL).part(Direction.DOWN, AEParts.TERMINAL);
        plot.cable(origin.m_122029_().m_122029_()).part(Direction.NORTH, AEParts.TERMINAL).part(Direction.UP, AEParts.TERMINAL).part(Direction.DOWN, AEParts.TERMINAL).part(Direction.SOUTH, AEParts.TOGGLE_BUS);
        BlockPos leverPos = origin.m_122029_().m_122029_().m_122012_();
        plot.block(leverPos, Blocks.f_50261_);
        plot.leverOn(leverPos.m_7494_().m_7494_(), Direction.DOWN);
        plot.cable(origin.m_122029_().m_122029_().m_122019_()).part(Direction.UP, AEParts.TERMINAL);
        plot.cable(origin.m_122029_().m_122029_().m_122029_()).part(Direction.EAST, AEParts.CABLE_ANCHOR);
        plot.cable(origin.m_122029_().m_122029_().m_122029_().m_122012_());
        plot.cable(origin.m_122029_().m_122029_().m_122029_().m_122012_().m_122029_()).part(Direction.EAST, AEParts.CABLE_ANCHOR);
        plot.cable(origin.m_122029_().m_122029_().m_122029_().m_122012_().m_122029_().m_122019_());
        plot.cable(origin.m_122029_().m_122029_().m_122029_().m_122012_().m_122029_().m_122019_().m_122029_());
        BlockPos p2pOutputPos = origin.m_122029_().m_122029_().m_122029_().m_122012_().m_122029_().m_122019_().m_122029_().m_122012_();
        plot.cable(p2pOutputPos).part(Direction.EAST, AEParts.ME_P2P_TUNNEL);
        plot.cable(p2pOutputPos.m_122029_()).part(Direction.UP, AEParts.MONITOR);
        plot.test(helper -> {
            MutableShort freq = new MutableShort();
            MutableObject lightPanel = new MutableObject();
            helper.m_177425_().m_177552_(() -> helper.getGrid(origin)).m_177562_(() -> {
                lightPanel.setValue((Object)helper.getPart(p2pOutputPos.m_122029_(), Direction.UP, PanelPart.class));
                IGrid grid = helper.getGrid(origin);
                BlockPos inputPos = helper.m_177449_(origin.m_122024_());
                BlockPos outputPos = helper.m_177449_(p2pOutputPos);
                freq.setValue(P2PTestPlots.linkTunnels(grid, MEP2PTunnelPart.class, inputPos, outputPos));
            }).m_177552_(() -> helper.check(((AbstractPanelPart)lightPanel.getValue()).getMainNode().isOnline(), "The panel should initially be on")).m_177562_(() -> helper.m_177421_(leverPos.m_7494_())).m_177552_(() -> {
                MEP2PTunnelPart inputTunnel = helper.getPart(p2pOutputPos, Direction.EAST, MEP2PTunnelPart.class);
                if (inputTunnel.getMainNode().isOnline()) {
                    helper.m_177289_("should be offline", p2pOutputPos);
                }
            }).m_177552_(() -> {
                if (((AbstractPanelPart)lightPanel.getValue()).getMainNode().isOnline()) {
                    helper.m_177289_("should be offline", p2pOutputPos.m_122029_());
                }
            }).m_177562_(() -> helper.m_177421_(leverPos.m_7494_())).m_177552_(() -> {
                MEP2PTunnelPart inputTunnel = helper.getPart(p2pOutputPos, Direction.EAST, MEP2PTunnelPart.class);
                if (!inputTunnel.getMainNode().isOnline()) {
                    helper.m_177289_("should be online", p2pOutputPos);
                }
            }).m_177552_(() -> {
                if (!((AbstractPanelPart)lightPanel.getValue()).getMainNode().isOnline()) {
                    helper.m_177289_("should be online", p2pOutputPos.m_122029_());
                }
            }).m_177543_();
        });
    }

    private static <T extends P2PTunnelPart<?>> void placeTunnel(PlotBuilder plot, ItemDefinition<PartItem<T>> tunnel) {
        BlockPos origin = BlockPos.f_121853_;
        plot.creativeEnergyCell(origin.m_7495_());
        plot.cable(origin);
        plot.cable(origin.m_122024_()).part(Direction.WEST, tunnel);
        plot.cable(origin.m_122029_()).part(Direction.EAST, tunnel);
        plot.afterGridInitAt(origin, (grid, gridNode) -> {
            BlockPos absOrigin = ((AEBasePart)gridNode.getOwner()).getBlockEntity().m_58899_();
            P2PTestPlots.linkTunnels(grid, ((PartItem)tunnel.m_5456_()).getPartClass(), absOrigin.m_122024_(), absOrigin.m_122029_());
        });
    }

    private static <T extends P2PTunnelPart<?>> short linkTunnels(IGrid grid, Class<T> tunnelType, BlockPos inputPos, BlockPos outputPos) {
        P2PService p2p = P2PService.get(grid);
        P2PTunnelPart inputTunnel = null;
        P2PTunnelPart outputTunnel = null;
        for (P2PTunnelPart p2pPart : grid.getMachines(tunnelType)) {
            if (p2pPart.getBlockEntity().m_58899_().equals((Object)inputPos)) {
                inputTunnel = p2pPart;
                continue;
            }
            if (!p2pPart.getBlockEntity().m_58899_().equals((Object)outputPos)) continue;
            outputTunnel = p2pPart;
        }
        Objects.requireNonNull(inputTunnel, "inputTunnel");
        Objects.requireNonNull(outputTunnel, "outputTunnel");
        inputTunnel.setFrequency(p2p.newFrequency());
        p2p.updateFreq(inputTunnel, inputTunnel.getFrequency());
        CompoundTag settings = new CompoundTag();
        inputTunnel.exportSettings(SettingsFrom.MEMORY_CARD, settings);
        outputTunnel.importSettings(SettingsFrom.MEMORY_CARD, settings, null);
        return inputTunnel.getFrequency();
    }
}

