/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.api.features.IPlayerRegistry;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.items.storage.SpatialStorageCellItem;
import appeng.server.ISubCommand;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStoragePlotManager;
import appeng.spatial.TransitionInfo;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SpatialStorageCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"info").executes(ctx -> {
            SpatialStorageCommand.showPlotInfo((CommandSourceStack)ctx.getSource(), SpatialStorageCommand.getCurrentPlot((CommandSourceStack)ctx.getSource()));
            return 1;
        })).then(Commands.m_82129_((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            SpatialStorageCommand.showPlotInfo((CommandSourceStack)ctx.getSource(), SpatialStorageCommand.getPlot(plotId));
            return 1;
        })));
        builder.then(Commands.m_82127_((String)"tp").then(Commands.m_82129_((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            SpatialStorageCommand.teleportToPlot((CommandSourceStack)ctx.getSource(), plotId);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"tpback").executes(ctx -> {
            this.teleportBack((CommandSourceStack)ctx.getSource());
            return 1;
        })).then(Commands.m_82129_((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            this.teleportBack((CommandSourceStack)ctx.getSource(), SpatialStorageCommand.getPlot(plotId));
            return 1;
        })));
        builder.then(Commands.m_82127_((String)"givecell").then(Commands.m_82129_((String)"plotId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int plotId = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"plotId");
            this.giveCell((CommandSourceStack)ctx.getSource(), plotId);
            return 1;
        })));
    }

    private void teleportBack(CommandSourceStack source) {
        if (source.m_81372_().m_46472_() != SpatialStorageDimensionIds.WORLD_ID) {
            throw new CommandRuntimeException((Component)PlayerMessages.NotInSpatialStorageLevel.text());
        }
        BlockPos playerPos = new BlockPos(source.m_81371_());
        int x = playerPos.m_123341_();
        int z = playerPos.m_123343_();
        for (SpatialStoragePlot plot : SpatialStoragePlotManager.INSTANCE.getPlots()) {
            BlockPos origin = plot.getOrigin();
            BlockPos size = plot.getSize();
            if (x < origin.m_123341_() || x > origin.m_123341_() + size.m_123341_() || z < origin.m_123343_() || z > origin.m_123343_() + size.m_123343_()) continue;
            this.teleportBack(source, plot);
            return;
        }
        throw new CommandRuntimeException((Component)PlayerMessages.PlotNotFoundForCurrentPosition.text());
    }

    private void teleportBack(CommandSourceStack source, SpatialStoragePlot plot) {
        TransitionInfo lastTransition = plot.getLastTransition();
        if (lastTransition == null) {
            throw new CommandRuntimeException((Component)PlayerMessages.NoLastTransition.text());
        }
        String command = SpatialStorageCommand.getTeleportCommand(lastTransition.getWorldId(), lastTransition.getMin().m_7918_(0, 1, 0));
        SpatialStorageCommand.runCommandFor(source, command);
    }

    private static void showPlotInfo(CommandSourceStack source, SpatialStoragePlot plot) {
        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.PlotID.text(), String.valueOf(plot.getId()));
        int playerId = plot.getOwner();
        if (playerId != -1) {
            MinecraftServer server = source.m_81377_();
            UUID profileId = IPlayerRegistry.getMapping(server).getProfileId(playerId);
            if (profileId == null) {
                SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Owner.text(), (Component)PlayerMessages.UnknownAE2Player.text(playerId));
            } else {
                ServerPlayer player = server.m_6846_().m_11259_(profileId);
                if (player != null) {
                    SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Owner.text(), (Component)PlayerMessages.PlayerConnected.text(player.m_36316_().getName()));
                } else {
                    Optional cachedProfile = server.m_129927_().m_11002_(profileId);
                    if (cachedProfile.isPresent()) {
                        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Owner.text(), (Component)PlayerMessages.PlayerDisconnected.text(((GameProfile)cachedProfile.get()).getName()));
                    } else {
                        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Owner.text(), (Component)PlayerMessages.MinecraftProfile.text(profileId));
                    }
                }
            }
        } else {
            SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Owner.text(), (Component)PlayerMessages.Unknown.text());
        }
        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Size.text(), SpatialStorageCommand.formatBlockPos(plot.getSize(), "x"));
        String teleportToPlotCommand = SpatialStorageCommand.getTeleportCommand(SpatialStorageDimensionIds.WORLD_ID.m_135782_(), plot.getOrigin());
        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Origin.text(), (Component)Component.m_237113_((String)SpatialStorageCommand.formatBlockPos(plot.getOrigin(), ",")).m_130938_(SpatialStorageCommand.makeCommandLink(teleportToPlotCommand, PlayerMessages.ClickToTeleport.text())));
        SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.RegionFile.text(), plot.getRegionFilename());
        TransitionInfo lastTransition = plot.getLastTransition();
        if (lastTransition != null) {
            source.m_81354_((Component)PlayerMessages.LastTransition.text().m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.BOLD}), true);
            String sourceWorldId = lastTransition.getWorldId().toString();
            MutableComponent sourceLink = PlayerMessages.SourceLink.text(sourceWorldId, SpatialStorageCommand.formatBlockPos(lastTransition.getMin(), ","), SpatialStorageCommand.formatBlockPos(lastTransition.getMax(), ","));
            String tpCommand = SpatialStorageCommand.getTeleportCommand(lastTransition.getWorldId(), lastTransition.getMin().m_7918_(0, 1, 0));
            sourceLink.m_130938_(SpatialStorageCommand.makeCommandLink(tpCommand, PlayerMessages.ClickToTeleport.text()));
            SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.Source.text(), (Component)sourceLink);
            SpatialStorageCommand.sendKeyValuePair(source, PlayerMessages.When.text(), lastTransition.getTimestamp().toString());
        } else {
            source.m_81354_((Component)PlayerMessages.LastTransitionUnknown.text(), true);
        }
    }

    private static void teleportToPlot(CommandSourceStack source, int plotId) {
        SpatialStoragePlot plot = SpatialStorageCommand.getPlot(plotId);
        String teleportCommand = SpatialStorageCommand.getTeleportCommand(SpatialStorageDimensionIds.WORLD_ID.m_135782_(), plot.getOrigin());
        SpatialStorageCommand.runCommandFor(source, teleportCommand);
    }

    private void giveCell(CommandSourceStack source, int plotId) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        SpatialStoragePlot plot = SpatialStorageCommand.getPlot(plotId);
        int longestSide = SpatialStorageCommand.getLongestSide(plot.getSize());
        ItemStack cell = longestSide <= 2 ? AEItems.SPATIAL_CELL2.stack() : (longestSide <= 16 ? AEItems.SPATIAL_CELL16.stack() : AEItems.SPATIAL_CELL128.stack());
        Item item = cell.m_41720_();
        if (!(item instanceof SpatialStorageCellItem)) {
            throw new CommandRuntimeException((Component)PlayerMessages.NotStorageCell.text());
        }
        SpatialStorageCellItem spatialCellItem = (SpatialStorageCellItem)item;
        spatialCellItem.setStoredDimension(cell, plotId, plot.getSize());
        player.m_36356_(cell);
    }

    private static int getLongestSide(BlockPos size) {
        return Math.max(size.m_123341_(), Math.max(size.m_123342_(), size.m_123343_()));
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSourceStack> ctx, CommandSourceStack sender) {
        try {
            SpatialStoragePlotManager.INSTANCE.getLevel();
        }
        catch (IllegalStateException e) {
            sender.m_81354_((Component)PlayerMessages.NoSpatialIOLevel.text(e.getMessage()), true);
            return;
        }
        ArrayList<SpatialStoragePlot> plots = new ArrayList<SpatialStoragePlot>(SpatialStoragePlotManager.INSTANCE.getPlots());
        if (plots.isEmpty()) {
            sender.m_81354_((Component)PlayerMessages.NoSpatialIOPlots.text(), true);
            return;
        }
        plots.sort(Comparator.comparing(plot -> {
            TransitionInfo lastTransition = plot.getLastTransition();
            if (lastTransition != null) {
                return lastTransition.getTimestamp();
            }
            return Instant.MIN;
        }).reversed());
        for (int i = 0; i < Math.min(5, plots.size()); ++i) {
            SpatialStoragePlot plot2 = (SpatialStoragePlot)plots.get(i);
            String size = SpatialStorageCommand.formatBlockPos(plot2.getSize(), "x");
            BlockPos originPos = plot2.getOrigin();
            String origin = SpatialStorageCommand.formatBlockPos(originPos, ",");
            MutableComponent infoLink = PlayerMessages.Plot.text().m_130946_(" #" + plot2.getId()).m_130938_(SpatialStorageCommand.makeCommandLink("/ae2 spatial info " + plot2.getId(), PlayerMessages.ClickToShowDetails.text()));
            MutableComponent tpLink = PlayerMessages.Origin.text().m_130946_(": " + origin).m_130938_(SpatialStorageCommand.makeCommandLink("/ae2 spatial tp " + plot2.getId(), PlayerMessages.ClickToTeleport.text()));
            MutableComponent message = Component.m_237113_((String)"").m_7220_((Component)infoLink).m_130946_(" ").m_7220_((Component)PlayerMessages.Size.text()).m_130946_(": " + size + " ").m_7220_((Component)tpLink);
            sender.m_81354_((Component)message, true);
        }
    }

    private static String formatBlockPos(BlockPos size, String separator) {
        return size.m_123341_() + separator + size.m_123342_() + separator + size.m_123343_();
    }

    private static UnaryOperator<Style> makeCommandLink(String command, MutableComponent tooltip) {
        return style -> style.m_131157_(ChatFormatting.UNDERLINE).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)tooltip));
    }

    private static void runCommandFor(CommandSourceStack source, String command) {
        Commands commandManager = source.m_81377_().m_129892_();
        commandManager.m_230957_(source, command);
    }

    private static String getTeleportCommand(ResourceLocation worldId, BlockPos pos) {
        return "/execute in " + worldId + " run tp @s " + pos.m_123341_() + " " + (pos.m_123342_() + 1) + " " + pos.m_123343_();
    }

    private static SpatialStoragePlot getPlot(int plotId) {
        SpatialStoragePlot plot = SpatialStoragePlotManager.INSTANCE.getPlot(plotId);
        if (plot == null) {
            throw new CommandRuntimeException((Component)PlayerMessages.PlotNotFound.text(plotId));
        }
        return plot;
    }

    private static void sendKeyValuePair(CommandSourceStack source, MutableComponent label, Component value) {
        source.m_81354_((Component)label.m_130946_(": ").m_130940_(ChatFormatting.BOLD).m_7220_(value), true);
    }

    private static void sendKeyValuePair(CommandSourceStack source, MutableComponent label, String value) {
        SpatialStorageCommand.sendKeyValuePair(source, label, (Component)Component.m_237113_((String)value));
    }

    private static SpatialStoragePlot getCurrentPlot(CommandSourceStack source) {
        if (source.m_81372_().m_46472_() != SpatialStorageDimensionIds.WORLD_ID) {
            throw new CommandRuntimeException((Component)PlayerMessages.NotInSpatialStorageLevel.text());
        }
        BlockPos playerPos = new BlockPos(source.m_81371_());
        int x = playerPos.m_123341_();
        int z = playerPos.m_123343_();
        for (SpatialStoragePlot plot : SpatialStoragePlotManager.INSTANCE.getPlots()) {
            BlockPos origin = plot.getOrigin();
            BlockPos size = plot.getSize();
            if (x < origin.m_123341_() || x > origin.m_123341_() + size.m_123341_() || z < origin.m_123343_() || z > origin.m_123343_() + size.m_123343_()) continue;
            return plot;
        }
        throw new CommandRuntimeException((Component)PlayerMessages.PlotNotFoundForCurrentPosition.text());
    }
}

