/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.spatial.ISpatialService;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ReplicatorCardItem
extends AEBaseItem {
    public ReplicatorCardItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        if (!level.m_5776_()) {
            CompoundTag tag = playerIn.m_21120_(handIn).m_41784_();
            int replications = tag.m_128441_("r") ? (tag.m_128451_("r") + 1) % 4 : 0;
            tag.m_128405_("r", replications);
            playerIn.m_213846_((Component)Component.m_237113_((String)(replications + 1 + "\u00b3 Replications")));
        }
        return super.m_7203_(level, playerIn, handIn);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        InteractionHand hand = context.m_43724_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (InteractionUtil.isInAlternateUseMode(player)) {
            IInWorldGridNodeHost gridHost = GridHelper.getNodeHost(level, pos);
            if (gridHost != null) {
                CompoundTag tag = player.m_21120_(hand).m_41784_();
                tag.m_128405_("x", x);
                tag.m_128405_("y", y);
                tag.m_128405_("z", z);
                tag.m_128405_("side", side.ordinal());
                tag.m_128359_("w", level.m_46472_().m_135782_().toString());
                tag.m_128405_("r", 0);
                this.outputMsg((Entity)player, "Set replicator source");
            } else {
                this.outputMsg((Entity)player, "This does not host a grid node");
            }
        } else {
            CompoundTag ish = player.m_21120_(hand).m_41783_();
            if (ish != null) {
                int src_x = ish.m_128451_("x");
                int src_y = ish.m_128451_("y");
                int src_z = ish.m_128451_("z");
                int src_side = ish.m_128451_("side");
                String worldId = ish.m_128461_("w");
                ServerLevel src_w = level.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(worldId)));
                int replications = ish.m_128451_("r") + 1;
                IInWorldGridNodeHost gh = GridHelper.getNodeHost((Level)src_w, new BlockPos(src_x, src_y, src_z));
                if (gh != null) {
                    Direction sideOff = Direction.values()[src_side];
                    Direction currentSideOff = side;
                    IGridNode n = gh.getGridNode(sideOff);
                    if (n != null) {
                        IGrid g = n.getGrid();
                        ISpatialService sc = g.getSpatialService();
                        if (sc.isValidRegion()) {
                            BlockPos min = sc.getMin();
                            BlockPos max = sc.getMax();
                            int sc_size_x = max.m_123341_() - min.m_123341_();
                            int sc_size_y = max.m_123342_() - min.m_123342_();
                            int sc_size_z = max.m_123343_() - min.m_123343_();
                            int min_x = min.m_123341_();
                            int min_y = min.m_123342_();
                            int min_z = min.m_123343_();
                            int x_rot = (int)(-Math.signum(Mth.m_14177_((float)player.m_146908_())));
                            int z_rot = (int)Math.signum(Mth.m_14177_((float)(player.m_146908_() + 90.0f)));
                            for (int r_x = 0; r_x < replications; ++r_x) {
                                for (int r_y = 0; r_y < replications; ++r_y) {
                                    for (int r_z = 0; r_z < replications; ++r_z) {
                                        int rel_x = min.m_123341_() - src_x + x + r_x * sc_size_x * x_rot;
                                        int rel_y = min.m_123342_() - src_y + y + r_y * sc_size_y;
                                        int rel_z = min.m_123343_() - src_z + z + r_z * sc_size_z * z_rot;
                                        for (int i = 1; i < sc_size_x; ++i) {
                                            for (int j = 1; j < sc_size_y; ++j) {
                                                for (int k = 1; k < sc_size_z; ++k) {
                                                    BlockEntity ote;
                                                    CompoundTag data;
                                                    BlockEntity newBe;
                                                    BlockPos p = new BlockPos(min_x + i, min_y + j, min_z + k);
                                                    BlockPos d = new BlockPos(i + rel_x, j + rel_y, k + rel_z);
                                                    BlockState state = src_w.m_8055_(p);
                                                    BlockState prev = level.m_8055_(d);
                                                    level.m_46597_(d, state);
                                                    if (state.m_155947_() && (newBe = BlockEntity.m_155241_((BlockPos)d, (BlockState)state, (CompoundTag)(data = (ote = src_w.m_7702_(p)).m_187481_()))) != null) {
                                                        level.m_151523_(newBe);
                                                    }
                                                    level.m_7260_(d, prev, state, 3);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        } else {
                            this.outputMsg((Entity)player, "requires valid spatial pylon setup.");
                        }
                    } else {
                        this.outputMsg((Entity)player, "No grid node?");
                    }
                } else {
                    this.outputMsg((Entity)player, "Src is no longer a grid block?");
                }
            } else {
                this.outputMsg((Entity)player, "No Source Defined");
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private void outputMsg(Entity player, String string) {
        player.m_213846_((Component)Component.m_237113_((String)string));
    }
}

