/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.advancements;

import appeng.api.util.AEColor;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.stats.AdvancementTriggers;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.localization.LocalizationProvider;
import appeng.datagen.providers.tags.ConventionTags;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AdvancementGenerator
implements IAE2DataProvider {
    private final DataGenerator generator;
    private final LocalizationProvider localization;

    public AdvancementGenerator(DataGenerator generator, LocalizationProvider localization) {
        this.generator = generator;
        this.localization = localization;
    }

    public void m_213708_(CachedOutput cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path path1 = AdvancementGenerator.createPath(path, advancement);
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        this.generateAdvancements(consumer);
    }

    private void generateAdvancements(Consumer<Advancement> consumer) {
        Advancement root = Advancement.Builder.m_138353_().m_138371_(AEItems.CERTUS_QUARTZ_CRYSTAL, this.localization.component("achievement.ae2.Root", "Applied Energistics"), this.localization.component("achievement.ae2.Root.desc", "When a chest is simply not enough. Acquire Copper to start your AE2 adventure."), AppEng.makeId("textures/block/sky_stone_brick.png"), FrameType.TASK, false, false, false).m_138386_("copper", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_151052_})).m_138389_(consumer, "ae2:main/root");
        Advancement charger = Advancement.Builder.m_138353_().m_138371_(AEBlocks.CHARGER, this.localization.component("achievement.ae2.Charger", "It's Chargin' Time !"), this.localization.component("achievement.ae2.Charger.desc", "Craft a Charger"), null, FrameType.TASK, true, true, false).m_138398_(root).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEBlocks.CHARGER})).m_138389_(consumer, "ae2:main/charger");
        Advancement compass = Advancement.Builder.m_138353_().m_138371_(AEItems.METEORITE_COMPASS, this.localization.component("achievement.ae2.Compass", "Meteorite Hunter"), this.localization.component("achievement.ae2.Compass.desc", "Craft a Meteorite Compass"), null, FrameType.TASK, true, true, false).m_138398_(charger).m_138386_("compass", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.METEORITE_COMPASS})).m_138389_(consumer, "ae2:main/compass");
        Advancement chargedQuartz = Advancement.Builder.m_138353_().m_138371_(AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, this.localization.component("achievement.ae2.ChargedQuartz", "Shocking"), this.localization.component("achievement.ae2.ChargedQuartz.desc", "Charge Quartz with a Charger"), null, FrameType.TASK, true, true, false).m_138398_(charger).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED})).m_138389_(consumer, "ae2:main/charged_quartz");
        Advancement.Builder pressesBuilder = Advancement.Builder.m_138353_().m_138371_(AEItems.LOGIC_PROCESSOR_PRESS, this.localization.component("achievement.ae2.Presses", "Unknown Technology"), this.localization.component("achievement.ae2.Presses.desc", "Find all Processor Presses"), null, FrameType.TASK, true, true, false).m_138398_(root).m_138386_("calculation", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.CALCULATION_PROCESSOR_PRESS})).m_138386_("engineering", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.ENGINEERING_PROCESSOR_PRESS})).m_138386_("logic", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.LOGIC_PROCESSOR_PRESS})).m_138386_("silicon", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.SILICON_PRESS}));
        Advancement presses = pressesBuilder.m_138389_(consumer, "ae2:main/presses");
        Advancement controller = Advancement.Builder.m_138353_().m_138371_(AEBlocks.CONTROLLER, this.localization.component("achievement.ae2.Controller", "Networking Switchboard"), this.localization.component("achievement.ae2.Controller.desc", "Craft a Controller"), null, FrameType.TASK, true, true, false).m_138398_(presses).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEBlocks.CONTROLLER})).m_138389_(consumer, "ae2:main/controller");
        Advancement storageCell = Advancement.Builder.m_138353_().m_138371_(AEItems.ITEM_CELL_64K, this.localization.component("achievement.ae2.StorageCell", "Better Than Chests"), this.localization.component("achievement.ae2.StorageCell.desc", "Craft a Storage Cell"), null, FrameType.TASK, false, false, false).m_138398_(controller).m_138386_("c1k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.ITEM_CELL_1K})).m_138386_("c4k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.ITEM_CELL_4K})).m_138386_("c16k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.ITEM_CELL_16K})).m_138386_("c64k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.ITEM_CELL_64K})).m_138386_("c256k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.ITEM_CELL_256K})).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, "ae2:main/storage_cell");
        Advancement ioport = Advancement.Builder.m_138353_().m_138371_(AEBlocks.IO_PORT, this.localization.component("achievement.ae2.IOPort", "Storage Cell Shuffle"), this.localization.component("achievement.ae2.IOPort.desc", "Craft an IO Port"), null, FrameType.TASK, true, true, false).m_138398_(storageCell).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEBlocks.IO_PORT})).m_138389_(consumer, "ae2:main/ioport");
        Advancement craftingTerminal = Advancement.Builder.m_138353_().m_138371_(AEParts.CRAFTING_TERMINAL, this.localization.component("achievement.ae2.CraftingTerminal", "A (Much) Bigger Table"), this.localization.component("achievement.ae2.CraftingTerminal.desc", "Craft a Crafting Terminal"), null, FrameType.TASK, true, true, false).m_138398_(controller).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEParts.CRAFTING_TERMINAL})).m_138389_(consumer, "ae2:main/crafting_terminal");
        Advancement patternTerminal = Advancement.Builder.m_138353_().m_138371_(AEParts.PATTERN_ENCODING_TERMINAL, this.localization.component("achievement.ae2.PatternTerminal", "Crafting Maestro"), this.localization.component("achievement.ae2.PatternTerminal.desc", "Craft a Pattern Encoding Terminal"), null, FrameType.TASK, true, true, false).m_138398_(craftingTerminal).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEParts.PATTERN_ENCODING_TERMINAL})).m_138389_(consumer, "ae2:main/pattern_encoding_terminal");
        Advancement craftingCpu = Advancement.Builder.m_138353_().m_138371_(AEBlocks.CRAFTING_STORAGE_64K, this.localization.component("achievement.ae2.CraftingCPU", "Next Gen Crafting"), this.localization.component("achievement.ae2.CraftingCPU.desc", "Craft a Crafting Unit"), null, FrameType.TASK, false, false, false).m_138398_(patternTerminal).m_138386_("cu", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEBlocks.CRAFTING_UNIT})).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, "ae2:main/crafting_cpu");
        Advancement fluix = Advancement.Builder.m_138353_().m_138371_(AEItems.FLUIX_CRYSTAL, this.localization.component("achievement.ae2.Fluix", "Unnatural"), this.localization.component("achievement.ae2.Fluix.desc", "Create Fluix Crystals"), null, FrameType.TASK, true, true, false).m_138398_(chargedQuartz).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.FLUIX_CRYSTAL})).m_138389_(consumer, "ae2:main/fluix");
        Advancement glassCable = Advancement.Builder.m_138353_().m_138371_(AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.GlassCable", "Fluix Energy Connection"), this.localization.component("achievement.ae2.GlassCable.desc", "Craft ME Glass Cable"), null, FrameType.TASK, true, true, false).m_138398_(fluix).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(ConventionTags.GLASS_CABLE).m_45077_()})).m_138389_(consumer, "ae2:main/glass_cable");
        Advancement facade = Advancement.Builder.m_138353_().m_138362_(AEItems.FACADE.m_5456_().createFacadeForItemUnchecked(new ItemStack((ItemLike)Items.f_41905_)), this.localization.component("achievement.ae2.Facade", "Network Aesthetics"), this.localization.component("achievement.ae2.Facade.desc", "Craft a Cable Facade"), null, FrameType.TASK, true, true, false).m_138398_(glassCable).m_138386_("facade", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.FACADE})).m_138389_(consumer, "ae2:main/facade");
        Advancement growthAccelerator = Advancement.Builder.m_138353_().m_138371_(AEBlocks.QUARTZ_GROWTH_ACCELERATOR, this.localization.component("achievement.ae2.CrystalGrowthAccelerator", "Accelerator is an understatement"), this.localization.component("achievement.ae2.CrystalGrowthAccelerator.desc", "Craft a Crystal Growth Accelerator"), null, FrameType.TASK, true, true, false).m_138398_(fluix).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEBlocks.QUARTZ_GROWTH_ACCELERATOR})).m_138389_(consumer, "ae2:main/growth_accelerator");
        Advancement network1 = Advancement.Builder.m_138353_().m_138371_(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.Networking1", "Network Apprentice"), this.localization.component("achievement.ae2.Networking1.desc", "Reach 8 channels using devices on a network."), null, FrameType.TASK, true, true, false).m_138398_(glassCable).m_138386_("cable", (CriterionTriggerInstance)AdvancementTriggers.NETWORK_APPRENTICE.instance()).m_138389_(consumer, "ae2:main/network1");
        Advancement network2 = Advancement.Builder.m_138353_().m_138371_(AEParts.SMART_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.Networking2", "Network Engineer"), this.localization.component("achievement.ae2.Networking2.desc", "Reach 128 channels using devices on a network."), null, FrameType.TASK, true, true, false).m_138398_(network1).m_138386_("cable", (CriterionTriggerInstance)AdvancementTriggers.NETWORK_ENGINEER.instance()).m_138389_(consumer, "ae2:main/network2");
        Advancement network3 = Advancement.Builder.m_138353_().m_138371_(AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.Networking3", "Network Administrator"), this.localization.component("achievement.ae2.Networking3.desc", "Reach 2048 channels using devices on a network."), null, FrameType.TASK, true, true, false).m_138398_(network2).m_138386_("cable", (CriterionTriggerInstance)AdvancementTriggers.NETWORK_ADMIN.instance()).m_138389_(consumer, "ae2:main/network3");
        Advancement networkTool = Advancement.Builder.m_138353_().m_138371_(AEItems.NETWORK_TOOL, this.localization.component("achievement.ae2.NetworkTool", "Network Diagnostics"), this.localization.component("achievement.ae2.NetworkTool.desc", "Craft a Network Tool"), null, FrameType.TASK, true, true, false).m_138398_(controller).m_138386_("network_tool", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.NETWORK_TOOL})).m_138389_(consumer, "ae2:main/network_tool");
        Advancement p2p = Advancement.Builder.m_138353_().m_138371_(AEParts.ME_P2P_TUNNEL, this.localization.component("achievement.ae2.P2P", "Point to Point Networking"), this.localization.component("achievement.ae2.P2P.desc", "Craft a P2P Tunnel"), null, FrameType.TASK, true, true, false).m_138398_(glassCable).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEParts.ME_P2P_TUNNEL})).m_138389_(consumer, "ae2:main/p2p");
        Advancement portableCell = Advancement.Builder.m_138353_().m_138371_(AEItems.PORTABLE_ITEM_CELL1K, this.localization.component("achievement.ae2.PortableCell", "Storage Nomad"), this.localization.component("achievement.ae2.PortableCell.desc", "Craft a Portable Cell"), null, FrameType.TASK, false, false, false).m_138398_(storageCell).m_138386_("pc_1k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.PORTABLE_ITEM_CELL1K})).m_138386_("pc_4k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.PORTABLE_ITEM_CELL4K})).m_138386_("pc_16k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.PORTABLE_ITEM_CELL16K})).m_138386_("pc_64k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.PORTABLE_ITEM_CELL64K})).m_138386_("pc_256k", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEItems.PORTABLE_ITEM_CELL256K})).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, "ae2:main/portable_cell");
        Advancement qnb = Advancement.Builder.m_138353_().m_138371_(AEBlocks.QUANTUM_LINK, this.localization.component("achievement.ae2.QNB", "Quantum Tunneling"), this.localization.component("achievement.ae2.QNB.desc", "Craft a Quantum Link"), null, FrameType.TASK, true, true, false).m_138398_(p2p).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEBlocks.QUANTUM_LINK})).m_138389_(consumer, "ae2:main/qnb");
        Advancement spatialIoport = Advancement.Builder.m_138353_().m_138371_(AEBlocks.SPATIAL_IO_PORT, this.localization.component("achievement.ae2.SpatialIO", "Spatial Coordination"), this.localization.component("achievement.ae2.SpatialIO.desc", "Craft a Spatial IO Port"), null, FrameType.TASK, true, true, false).m_138398_(ioport).m_138386_("certus", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEBlocks.SPATIAL_IO_PORT})).m_138389_(consumer, "ae2:main/spatial_ioport");
        Advancement spatialExplorer = Advancement.Builder.m_138353_().m_138371_(AEItems.SPATIAL_128_CELL_COMPONENT, this.localization.component("achievement.ae2.SpatialIOExplorer", "To boldly go"), this.localization.component("achievement.ae2.SpatialIOExplorer.desc", "Get stored in a spatial storage cell"), null, FrameType.TASK, false, false, false).m_138398_(spatialIoport).m_138386_("explorer", (CriterionTriggerInstance)AdvancementTriggers.SPATIAL_EXPLORER.instance()).m_138389_(consumer, "ae2:main/spatial_explorer");
        Advancement storageBus = Advancement.Builder.m_138353_().m_138371_(AEParts.STORAGE_BUS, this.localization.component("achievement.ae2.StorageBus", "Limitless Potential"), this.localization.component("achievement.ae2.StorageBus.desc", "Craft a Storage Bus"), null, FrameType.TASK, true, true, false).m_138398_(glassCable).m_138386_("part", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{AEParts.STORAGE_BUS})).m_138389_(consumer, "ae2:main/storage_bus");
        Advancement storageBusOnInterface = Advancement.Builder.m_138353_().m_138371_(AEBlocks.INTERFACE, this.localization.component("achievement.ae2.Recursive", "Recursive Networking"), this.localization.component("achievement.ae2.Recursive.desc", "Place a Storage Bus on an Interface."), null, FrameType.TASK, true, true, false).m_138398_(storageBus).m_138386_("recursive", (CriterionTriggerInstance)AdvancementTriggers.RECURSIVE.instance()).m_138389_(consumer, "ae2:main/recursive");
    }

    private static Path createPath(Path basePath, Advancement advancement) {
        return basePath.resolve("data/" + advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Advancements";
    }
}

