/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.implementations.blockentities.ICrankable;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CrankBlockEntity
extends AEBaseBlockEntity
implements ServerTickingBlockEntity,
ClientTickingBlockEntity {
    public static final int POWER_PER_CRANK_TURN = 160;
    private final int ticksPerRotation = 18;
    private float visibleRotation = 0.0f;
    private int charge = 0;
    private int hits = 0;
    private int rotation = 0;

    public CrankBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Nullable
    private ICrankable getCrankable() {
        if (this.isClientSide()) {
            return null;
        }
        Direction targetDir = this.getUp().m_122424_();
        BlockPos targetPos = this.m_58899_().m_121945_(targetDir);
        return ICrankable.get(this.f_58857_, targetPos, targetDir.m_122424_());
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        this.rotation = data.readInt();
        return c;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeInt(this.rotation);
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        BlockPos pos = this.m_58899_();
        BlockState state = this.f_58857_.m_8055_(pos);
        this.f_58857_.m_213960_(state, pos, state.m_60734_(), pos, false);
    }

    public boolean power() {
        ICrankable crankable;
        if (this.isClientSide()) {
            return false;
        }
        if (this.rotation < 3 && (crankable = this.getCrankable()) != null) {
            if (crankable.canTurn()) {
                this.hits = 0;
                this.rotation += this.ticksPerRotation;
                this.markForUpdate();
                return true;
            }
            ++this.hits;
            if (this.hits > 10) {
                this.f_58857_.m_46961_(this.m_58899_(), false);
            }
        }
        return false;
    }

    public float getVisibleRotation() {
        return this.visibleRotation;
    }

    private void setVisibleRotation(float visibleRotation) {
        this.visibleRotation = visibleRotation;
    }

    @Override
    public void clientTick() {
        this.tick();
    }

    @Override
    public void serverTick() {
        this.tick();
    }

    private void tick() {
        if (this.rotation > 0) {
            float f = this.getVisibleRotation();
            Objects.requireNonNull(this);
            this.setVisibleRotation(f - 360.0f / 18.0f);
            ++this.charge;
            if (this.charge >= this.ticksPerRotation) {
                this.charge -= this.ticksPerRotation;
                ICrankable g = this.getCrankable();
                if (g != null) {
                    g.applyTurn();
                }
            }
            --this.rotation;
        }
    }
}

