/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.belts.tunnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelShapes;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BeltTunnelBlock
extends Block
implements ITE<BeltTunnelTileEntity>,
IWrenchable {
    public static final Property<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);
    public static final Property<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;

    public BeltTunnelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)Shape.STRAIGHT)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BeltTunnelShapes.getShape(state);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState blockState = worldIn.m_8055_(pos.m_7495_());
        if (!this.isValidPositionForPlacement(state, worldIn, pos)) {
            return false;
        }
        return (Boolean)blockState.m_61143_((Property)BeltBlock.CASING) != false;
    }

    public boolean isValidPositionForPlacement(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState blockState = worldIn.m_8055_(pos.m_7495_());
        if (!AllBlocks.BELT.has(blockState)) {
            return false;
        }
        return blockState.m_61143_(BeltBlock.SLOPE) == BeltSlope.HORIZONTAL;
    }

    public static boolean hasWindow(BlockState state) {
        return state.m_61143_(SHAPE) == Shape.WINDOW || state.m_61143_(SHAPE) == Shape.CLOSED;
    }

    public static boolean isStraight(BlockState state) {
        return BeltTunnelBlock.hasWindow(state) || state.m_61143_(SHAPE) == Shape.STRAIGHT;
    }

    public static boolean isJunction(BlockState state) {
        Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
        return shape == Shape.CROSS || shape == Shape.T_LEFT || shape == Shape.T_RIGHT;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getTunnelState((BlockGetter)context.m_43725_(), context.m_8083_());
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (!(world instanceof WrappedWorld) && !world.m_5776_()) {
            this.withTileEntityDo((BlockGetter)world, pos, BeltTunnelTileEntity::updateTunnelConnections);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState tunnelState;
        if (facing.m_122434_().m_122478_()) {
            return state;
        }
        if (!(worldIn instanceof WrappedWorld) && !worldIn.m_5776_()) {
            this.withTileEntityDo((BlockGetter)worldIn, currentPos, BeltTunnelTileEntity::updateTunnelConnections);
        }
        if ((tunnelState = this.getTunnelState((BlockGetter)worldIn, currentPos)).m_61143_(HORIZONTAL_AXIS) == state.m_61143_(HORIZONTAL_AXIS) && BeltTunnelBlock.hasWindow(tunnelState) == BeltTunnelBlock.hasWindow(state)) {
            return state;
        }
        return tunnelState;
    }

    public void updateTunnel(LevelAccessor world, BlockPos pos) {
        BlockState newTunnel;
        BlockState tunnel = world.m_8055_(pos);
        if (tunnel != (newTunnel = this.getTunnelState((BlockGetter)world, pos)) && !world.m_5776_()) {
            world.m_7731_(pos, newTunnel, 3);
            BlockEntity te = world.m_7702_(pos);
            if (te != null && te instanceof BeltTunnelTileEntity) {
                ((BeltTunnelTileEntity)te).updateTunnelConnections();
            }
        }
    }

    private BlockState getTunnelState(BlockGetter reader, BlockPos pos) {
        boolean canHaveWindow;
        BlockState state = this.m_49966_();
        BlockState belt = reader.m_8055_(pos.m_7495_());
        if (AllBlocks.BELT.has(belt)) {
            state = (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)((Direction)belt.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122434_());
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
        Direction left = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_122427_();
        boolean onLeft = this.hasValidOutput(reader, pos.m_7495_(), left);
        boolean onRight = this.hasValidOutput(reader, pos.m_7495_(), left.m_122424_());
        if (onLeft && onRight) {
            state = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.CROSS));
        } else if (onLeft) {
            state = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.T_LEFT));
        } else if (onRight) {
            state = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.T_RIGHT));
        }
        if (state.m_61143_(SHAPE) == Shape.STRAIGHT && (canHaveWindow = this.canHaveWindow(reader, pos, axis))) {
            state = (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW));
        }
        return state;
    }

    protected boolean canHaveWindow(BlockGetter reader, BlockPos pos, Direction.Axis axis) {
        Direction fw = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        BlockState blockState1 = reader.m_8055_(pos.m_121945_(fw));
        BlockState blockState2 = reader.m_8055_(pos.m_121945_(fw.m_122424_()));
        boolean funnel1 = blockState1.m_60734_() instanceof BeltFunnelBlock && blockState1.m_61143_(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && blockState1.m_61143_((Property)BeltFunnelBlock.HORIZONTAL_FACING) == fw.m_122424_();
        boolean funnel2 = blockState2.m_60734_() instanceof BeltFunnelBlock && blockState2.m_61143_(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && blockState2.m_61143_((Property)BeltFunnelBlock.HORIZONTAL_FACING) == fw;
        boolean valid1 = blockState1.m_60734_() instanceof BeltTunnelBlock || funnel1;
        boolean valid2 = blockState2.m_60734_() instanceof BeltTunnelBlock || funnel2;
        boolean canHaveWindow = valid1 && valid2 && (!funnel1 || !funnel2);
        return canHaveWindow;
    }

    private boolean hasValidOutput(BlockGetter world, BlockPos pos, Direction side) {
        BlockState blockState = world.m_8055_(pos.m_121945_(side));
        if (AllBlocks.BELT.has(blockState)) {
            return ((Direction)blockState.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122434_() == side.m_122434_();
        }
        DirectBeltInputBehaviour behaviour = TileEntityBehaviour.get(world, pos.m_121945_(side), DirectBeltInputBehaviour.TYPE);
        return behaviour != null && behaviour.canInsertFromSide(side);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (!BeltTunnelBlock.hasWindow(state)) {
            return InteractionResult.PASS;
        }
        Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
        shape = shape == Shape.CLOSED ? Shape.WINDOW : Shape.CLOSED;
        Level world = context.m_43725_();
        if (!world.f_46443_) {
            world.m_7731_(context.m_8083_(), (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)shape)), 2);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        Direction fromAxis = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.m_61143_(HORIZONTAL_AXIS)));
        Direction rotated = rotation.m_55954_(fromAxis);
        return (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)rotated.m_122434_());
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        if (fromPos.equals((Object)pos.m_7495_()) && !this.m_7898_(state, (LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
            return;
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_AXIS, SHAPE});
        super.m_7926_(builder);
    }

    @Override
    public Class<BeltTunnelTileEntity> getTileEntityClass() {
        return BeltTunnelTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends BeltTunnelTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.ANDESITE_TUNNEL.get();
    }

    public static enum Shape implements StringRepresentable
    {
        STRAIGHT,
        WINDOW,
        CLOSED,
        T_LEFT,
        T_RIGHT,
        CROSS;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

