/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.chassis;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class StickerBlock
extends WrenchableDirectionalBlock
implements ITE<StickerTileEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty EXTENDED = BlockStateProperties.f_61432_;

    public StickerBlock(BlockBehaviour.Properties p_i48415_1_) {
        super(p_i48415_1_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction nearestLookingDirection = context.m_7820_();
        boolean shouldPower = context.m_43725_().m_46753_(context.m_8083_());
        Direction facing = context.m_43723_() != null && context.m_43723_().m_6144_() ? nearestLookingDirection : nearestLookingDirection.m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)facing)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(shouldPower));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{POWERED, EXTENDED}));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != worldIn.m_46753_(pos)) {
            if (((Boolean)(state = (BlockState)state.m_61122_((Property)POWERED)).m_61143_((Property)POWERED)).booleanValue()) {
                state = (BlockState)state.m_61122_((Property)EXTENDED);
            }
            worldIn.m_7731_(pos, state, 2);
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    @Override
    public Class<StickerTileEntity> getTileEntityClass() {
        return StickerTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends StickerTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.STICKER.get();
    }

    private boolean isUprightSticker(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return AllBlocks.STICKER.has(blockState) && blockState.m_61143_((Property)f_52588_) == Direction.UP;
    }

    public void m_142072_(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, float p_152430_) {
        if (!this.isUprightSticker((BlockGetter)p_152426_, p_152428_) || p_152429_.m_20162_()) {
            super.m_142072_(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_);
        }
        p_152429_.m_142535_(p_152430_, 1.0f, DamageSource.f_19315_);
    }

    public void m_5548_(BlockGetter p_176216_1_, Entity p_176216_2_) {
        if (!this.isUprightSticker(p_176216_1_, p_176216_2_.m_20183_().m_7495_()) || p_176216_2_.m_20162_()) {
            super.m_5548_(p_176216_1_, p_176216_2_);
        } else {
            this.bounceUp(p_176216_2_);
        }
    }

    private void bounceUp(Entity p_226946_1_) {
        Vec3 Vector3d = p_226946_1_.m_20184_();
        if (Vector3d.f_82480_ < 0.0) {
            double d0 = p_226946_1_ instanceof LivingEntity ? 1.0 : 0.8;
            p_226946_1_.m_20334_(Vector3d.f_82479_, -Vector3d.f_82480_ * d0, Vector3d.f_82481_);
        }
    }

    public void m_141947_(Level p_152431_, BlockPos p_152432_, BlockState p_152433_, Entity p_152434_) {
        double d0 = Math.abs(p_152434_.m_20184_().f_82480_);
        if (d0 < 0.1 && !p_152434_.m_20161_() && this.isUprightSticker((BlockGetter)p_152431_, p_152432_)) {
            double d1 = 0.4 + d0 * 0.2;
            p_152434_.m_20256_(p_152434_.m_20184_().m_82542_(d1, 1.0, d1));
        }
        super.m_141947_(p_152431_, p_152432_, p_152433_, p_152434_);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        if (this.isUprightSticker((BlockGetter)worldserver, pos)) {
            worldserver.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50374_.m_49966_()), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
            return true;
        }
        return super.addLandingEffects(state1, worldserver, pos, state2, entity, numberOfParticles);
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (state.m_61143_((Property)f_52588_) == Direction.UP) {
            Vec3 Vector3d = entity.m_20184_();
            world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50374_.m_49966_()).setPos(pos), entity.m_20185_() + ((double)world.f_46441_.m_188501_() - 0.5) * (double)entity.m_20205_(), entity.m_20186_() + 0.1, entity.m_20189_() + ((double)world.f_46441_.m_188501_() - 0.5) * (double)entity.m_20205_(), Vector3d.f_82479_ * -4.0, 1.5, Vector3d.f_82481_ * -4.0);
            return true;
        }
        return super.addRunningEffects(state, world, pos, entity);
    }
}

