/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MountedFluidStorage;
import com.simibubi.create.content.contraptions.components.structureMovement.MountedStorage;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MountedStorageManager {
    protected Contraption.ContraptionInvWrapper inventory;
    protected Contraption.ContraptionInvWrapper fuelInventory;
    protected CombinedTankWrapper fluidInventory;
    protected Map<BlockPos, MountedStorage> storage = new HashMap<BlockPos, MountedStorage>();
    protected Map<BlockPos, MountedFluidStorage> fluidStorage = new HashMap<BlockPos, MountedFluidStorage>();

    public void entityTick(AbstractContraptionEntity entity) {
        this.fluidStorage.forEach((pos, mfs) -> mfs.tick(entity, (BlockPos)pos, entity.f_19853_.f_46443_));
    }

    public void createHandlers() {
        Collection<MountedStorage> itemHandlers = this.storage.values();
        this.inventory = this.wrapItems(itemHandlers.stream().map(MountedStorage::getItemHandler).toList(), false);
        this.fuelInventory = this.wrapItems(itemHandlers.stream().filter(MountedStorage::canUseForFuel).map(MountedStorage::getItemHandler).toList(), true);
        this.fluidInventory = this.wrapFluids(this.fluidStorage.values().stream().map(MountedFluidStorage::getFluidHandler).collect(Collectors.toList()));
    }

    protected Contraption.ContraptionInvWrapper wrapItems(Collection<IItemHandlerModifiable> list, boolean fuel) {
        return new Contraption.ContraptionInvWrapper((IItemHandlerModifiable[])Arrays.copyOf(list.toArray(), list.size(), IItemHandlerModifiable[].class));
    }

    protected CombinedTankWrapper wrapFluids(Collection<IFluidHandler> list) {
        return new CombinedTankWrapper((IFluidHandler[])Arrays.copyOf(list.toArray(), list.size(), IFluidHandler[].class));
    }

    public void addBlock(BlockPos localPos, BlockEntity te) {
        if (te != null && MountedStorage.canUseAsStorage(te)) {
            this.storage.put(localPos, new MountedStorage(te));
        }
        if (te != null && MountedFluidStorage.canUseAsStorage(te)) {
            this.fluidStorage.put(localPos, new MountedFluidStorage(te));
        }
    }

    public void read(CompoundTag nbt, Map<BlockPos, BlockEntity> presentTileEntities, boolean clientPacket) {
        this.storage.clear();
        NBTHelper.iterateCompoundList(nbt.m_128437_("Storage", 10), c -> this.storage.put(NbtUtils.m_129239_((CompoundTag)c.m_128469_("Pos")), MountedStorage.deserialize(c.m_128469_("Data"))));
        this.fluidStorage.clear();
        NBTHelper.iterateCompoundList(nbt.m_128437_("FluidStorage", 10), c -> this.fluidStorage.put(NbtUtils.m_129239_((CompoundTag)c.m_128469_("Pos")), MountedFluidStorage.deserialize(c.m_128469_("Data"))));
        if (clientPacket && presentTileEntities != null) {
            this.bindTanks(presentTileEntities);
        }
        ArrayList<IItemHandlerModifiable> handlers = new ArrayList<IItemHandlerModifiable>();
        ArrayList<IItemHandlerModifiable> fuelHandlers = new ArrayList<IItemHandlerModifiable>();
        for (MountedStorage mountedStorage : this.storage.values()) {
            IItemHandlerModifiable itemHandler = mountedStorage.getItemHandler();
            handlers.add(itemHandler);
            if (!mountedStorage.canUseForFuel()) continue;
            fuelHandlers.add(itemHandler);
        }
        this.inventory = this.wrapItems(handlers, false);
        this.fuelInventory = this.wrapItems(fuelHandlers, true);
        this.fluidInventory = this.wrapFluids(this.fluidStorage.values().stream().map(MountedFluidStorage::getFluidHandler).toList());
    }

    public void bindTanks(Map<BlockPos, BlockEntity> presentTileEntities) {
        this.fluidStorage.forEach((pos, mfs) -> {
            BlockEntity tileEntity = (BlockEntity)presentTileEntities.get(pos);
            if (!(tileEntity instanceof FluidTankTileEntity)) {
                return;
            }
            FluidTankTileEntity tank = (FluidTankTileEntity)tileEntity;
            IFluidTank tankInventory = tank.getTankInventory();
            if (tankInventory instanceof FluidTank) {
                ((FluidTank)tankInventory).setFluid(mfs.tank.getFluid());
            }
            tank.getFluidLevel().startWithValue(tank.getFillState());
            mfs.assignTileEntity(tank);
        });
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        ListTag storageNBT = new ListTag();
        if (!clientPacket) {
            for (BlockPos pos : this.storage.keySet()) {
                CompoundTag c = new CompoundTag();
                MountedStorage mountedStorage = this.storage.get(pos);
                if (!mountedStorage.isValid()) continue;
                c.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                c.m_128365_("Data", (Tag)mountedStorage.serialize());
                storageNBT.add((Object)c);
            }
        }
        ListTag fluidStorageNBT = new ListTag();
        for (BlockPos pos : this.fluidStorage.keySet()) {
            CompoundTag c = new CompoundTag();
            MountedFluidStorage mountedStorage = this.fluidStorage.get(pos);
            if (!mountedStorage.isValid()) continue;
            c.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            c.m_128365_("Data", (Tag)mountedStorage.serialize());
            fluidStorageNBT.add((Object)c);
        }
        nbt.m_128365_("Storage", (Tag)storageNBT);
        nbt.m_128365_("FluidStorage", (Tag)fluidStorageNBT);
    }

    public void removeStorageFromWorld() {
        this.storage.values().forEach(MountedStorage::removeStorageFromWorld);
        this.fluidStorage.values().forEach(MountedFluidStorage::removeStorageFromWorld);
    }

    public void addStorageToWorld(StructureTemplate.StructureBlockInfo block, BlockEntity tileEntity) {
        Object mountedStorage;
        if (this.storage.containsKey(block.f_74675_) && ((MountedStorage)(mountedStorage = this.storage.get(block.f_74675_))).isValid()) {
            ((MountedStorage)mountedStorage).addStorageToWorld(tileEntity);
        }
        if (this.fluidStorage.containsKey(block.f_74675_) && ((MountedFluidStorage)(mountedStorage = this.fluidStorage.get(block.f_74675_))).isValid()) {
            ((MountedFluidStorage)mountedStorage).addStorageToWorld(tileEntity);
        }
    }

    public void clear() {
        int i;
        for (i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.isSlotExternal(i)) continue;
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (i = 0; i < this.fluidInventory.getTanks(); ++i) {
            this.fluidInventory.drain(this.fluidInventory.getFluidInTank(i), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void updateContainedFluid(BlockPos localPos, FluidStack containedFluid) {
        MountedFluidStorage mountedFluidStorage = this.fluidStorage.get(localPos);
        if (mountedFluidStorage != null) {
            mountedFluidStorage.updateFluid(containedFluid);
        }
    }

    public void attachExternal(IItemHandlerModifiable externalStorage) {
        this.inventory = new Contraption.ContraptionInvWrapper(new IItemHandlerModifiable[]{externalStorage, this.inventory});
        this.fuelInventory = new Contraption.ContraptionInvWrapper(new IItemHandlerModifiable[]{externalStorage, this.fuelInventory});
    }

    public IItemHandlerModifiable getItems() {
        return this.inventory;
    }

    public IItemHandlerModifiable getFuelItems() {
        return this.fuelInventory;
    }

    public IFluidHandler getFluids() {
        return this.fluidInventory;
    }
}

