/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.tools.client.render.entity.PickarangRenderer;
import vazkii.quark.content.tools.config.PickarangType;
import vazkii.quark.content.tools.entity.rang.AbstractPickarang;
import vazkii.quark.content.tools.entity.rang.Echorang;
import vazkii.quark.content.tools.entity.rang.Flamerang;
import vazkii.quark.content.tools.entity.rang.Pickarang;
import vazkii.quark.content.tools.item.PickarangItem;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class PickarangModule
extends QuarkModule {
    @Config(name="pickarang")
    public static PickarangType<Pickarang> pickarangType = new PickarangType(Items.f_42415_, Items.f_42390_, 20, 3, 800, 20.0, 2, 10);
    @Config(name="flamerang")
    public static PickarangType<Flamerang> flamerangType = new PickarangType(Items.f_42418_, Items.f_42395_, 20, 4, 1040, 20.0, 3, 10);
    @Config(name="echorang")
    public static PickarangType<Echorang> echorangType = new PickarangType(Items.f_220224_, Items.f_42390_, 40, 3, 2000, 20.0, 2, 10);
    @Config(flag="flamerang")
    public static boolean enableFlamerang = true;
    @Config(flag="echorang")
    public static boolean enableEchorang = true;
    @Config(description="Set this to true to use the recipe without the Heart of Diamond, even if the Heart of Diamond is enabled.", flag="pickarang_never_uses_heart")
    public static boolean neverUseHeartOfDiamond = false;
    public static Item pickarang;
    public static Item flamerang;
    public static Item echorang;
    private static List<PickarangType<?>> knownTypes;
    private static boolean isEnabled;
    public static TagKey<Block> pickarangImmuneTag;
    public static TagKey<GameEvent> echorangCanListenTag;
    public static QuarkGenericTrigger throwPickarangTrigger;
    public static QuarkGenericTrigger useFlamerangTrigger;
    private static final ThreadLocal<AbstractPickarang<?>> ACTIVE_PICKARANG;

    @Override
    public void register() {
        pickarang = this.makePickarang(pickarangType, "pickarang", Pickarang::new, Pickarang::new, () -> true);
        flamerang = this.makePickarang(flamerangType, "flamerang", Flamerang::new, Flamerang::new, () -> enableFlamerang);
        echorang = this.makePickarang(echorangType, "echorang", Echorang::new, Echorang::new, () -> enableEchorang);
        throwPickarangTrigger = QuarkAdvancementHandler.registerGenericTrigger("throw_pickarang");
        useFlamerangTrigger = QuarkAdvancementHandler.registerGenericTrigger("use_flamerang");
    }

    private <T extends AbstractPickarang<T>> Item makePickarang(PickarangType<T> type, String name, EntityType.EntityFactory<T> entityFactory, PickarangType.PickarangConstructor<T> thrownFactory, BooleanSupplier condition) {
        EntityType entityType = EntityType.Builder.m_20704_(entityFactory, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.4f).m_20702_(4).m_20717_(10).setCustomClientFactory((t, l) -> (AbstractPickarang)entityFactory.m_20721_(type.getEntityType(), l)).m_20712_(name);
        RegistryHelper.register((Object)entityType, (String)name, (ResourceKey)Registry.f_122903_);
        knownTypes.add(type);
        type.setEntityType(entityType, thrownFactory);
        return new PickarangItem(name, this, this.propertiesFor(type.durability, type.isFireResistant()), type).setCondition(condition);
    }

    private Item.Properties propertiesFor(int durability, boolean fireResist) {
        Item.Properties properties = new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_);
        if (durability > 0) {
            properties.m_41503_(durability);
        }
        if (fireResist) {
            properties.m_41486_();
        }
        return properties;
    }

    @Override
    public void setup() {
        pickarangImmuneTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "pickarang_immune"));
        echorangCanListenTag = TagKey.m_203882_((ResourceKey)Registry.f_175423_, (ResourceLocation)new ResourceLocation("quark", "echorang_can_listen"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        knownTypes.forEach(t -> EntityRenderers.m_174036_(t.getEntityType(), PickarangRenderer::new));
    }

    @Override
    public void configChanged() {
        isEnabled = this.enabled;
    }

    public static void setActivePickarang(AbstractPickarang<?> pickarang) {
        ACTIVE_PICKARANG.set(pickarang);
    }

    public static DamageSource createDamageSource(Player player) {
        AbstractPickarang<?> pickarang = ACTIVE_PICKARANG.get();
        if (pickarang == null) {
            return null;
        }
        return new IndirectEntityDamageSource("player", pickarang, (Entity)player).m_19366_();
    }

    public static boolean getIsFireResistant(boolean vanillaVal, Entity entity) {
        if (!isEnabled || vanillaVal) {
            return vanillaVal;
        }
        Entity riding = entity.m_20202_();
        if (riding instanceof AbstractPickarang) {
            AbstractPickarang pick = (AbstractPickarang)riding;
            return pick.getPickarangType().isFireResistant();
        }
        return false;
    }

    static {
        knownTypes = new ArrayList();
        ACTIVE_PICKARANG = new ThreadLocal();
    }
}

