/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.client.render.be;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import vazkii.quark.addons.oddities.module.TinyPotatoModule;
import vazkii.quark.addons.oddities.util.TinyPotatoInfo;
import vazkii.quark.content.tools.item.RuneItem;
import vazkii.quark.content.tools.module.ColorRunesModule;
import vazkii.quark.mixin.client.accessor.AccessorModelManager;

@OnlyIn(value=Dist.CLIENT)
public class TinyPotatoRenderer
implements BlockEntityRenderer<TinyPotatoBlockEntity> {
    public static final String DEFAULT = "default";
    public static final String HALLOWEEN = "halloween";
    public static final String ANGRY = "angry";
    private static final Pattern ESCAPED = Pattern.compile("[^a-z0-9/._-]");
    private final BlockRenderDispatcher blockRenderDispatcher;
    private static List<ItemStack> runeStacks;

    public static boolean isTheSpookDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 10 && calendar.get(5) == 31;
    }

    public TinyPotatoRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.m_173584_();
    }

    public static BakedModel getModelFromDisplayName(Component displayName, boolean angry) {
        TinyPotatoInfo info = TinyPotatoInfo.fromComponent(displayName);
        return TinyPotatoRenderer.getModel(info.name(), angry);
    }

    private static BakedModel getModel(String name, boolean angry) {
        ModelManager bmm = Minecraft.m_91087_().m_91304_();
        Map<ResourceLocation, BakedModel> mm = ((AccessorModelManager)bmm).getBakedRegistry();
        BakedModel missing = bmm.m_119409_();
        ResourceLocation location = TinyPotatoRenderer.taterLocation(name);
        BakedModel model = mm.get(location);
        if (model == null) {
            if (TinyPotatoRenderer.isTheSpookDay()) {
                return mm.getOrDefault(TinyPotatoRenderer.taterLocation(HALLOWEEN), missing);
            }
            if (angry) {
                return mm.getOrDefault(TinyPotatoRenderer.taterLocation(ANGRY), missing);
            }
            return mm.getOrDefault(TinyPotatoRenderer.taterLocation(DEFAULT), missing);
        }
        return model;
    }

    private static ResourceLocation taterLocation(String name) {
        return new ResourceLocation("quark", "tiny_potato/" + TinyPotatoRenderer.normalizeName(name));
    }

    private static String normalizeName(String name) {
        return ESCAPED.matcher(name).replaceAll("_");
    }

    public void render(@Nonnull TinyPotatoBlockEntity potato, float partialTicks, @Nonnull PoseStack ms, @Nonnull MultiBufferSource buffers, int light, int overlay) {
        boolean render;
        if (runeStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (RuneItem item : ColorRunesModule.runes) {
                stacks.add(new ItemStack((ItemLike)item));
            }
            stacks.add(new ItemStack((ItemLike)ColorRunesModule.rainbow_rune));
            runeStacks = ImmutableList.copyOf(stacks);
        }
        ms.m_85836_();
        TinyPotatoInfo info = TinyPotatoInfo.fromComponent(potato.name);
        RenderType layer = Sheets.m_110792_();
        BakedModel model = TinyPotatoRenderer.getModel(info.name(), potato.angry);
        ms.m_85837_(0.5, 0.0, 0.5);
        Direction potatoFacing = (Direction)potato.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        float rotY = 0.0f;
        switch (potatoFacing) {
            default: {
                rotY = 180.0f;
                break;
            }
            case NORTH: {
                break;
            }
            case EAST: {
                rotY = 90.0f;
                break;
            }
            case WEST: {
                rotY = 270.0f;
            }
        }
        ms.m_85845_(Vector3f.f_122224_.m_122240_(rotY));
        float jump = potato.jumpTicks;
        if (jump > 0.0f) {
            jump -= partialTicks;
        }
        float up = (float)Math.abs(Math.sin((double)(jump / 10.0f) * Math.PI)) * 0.2f;
        float rotZ = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 2.0f;
        float wiggle = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 0.05f;
        ms.m_85837_((double)wiggle, (double)up, 0.0);
        ms.m_85845_(Vector3f.f_122227_.m_122240_(rotZ));
        boolean bl = render = !info.name().equals("mami") && !info.name().equals("soaryn") && (!info.name().equals("eloraam") || jump == 0.0f);
        if (render) {
            ms.m_85836_();
            ms.m_85837_(-0.5, 0.0, -0.5);
            if (0 <= info.runeColor() && info.runeColor() < 17) {
                ColorRunesModule.setTargetStack(runeStacks.get(info.runeColor()));
            } else {
                ColorRunesModule.setTargetStack(ItemStack.f_41583_);
            }
            VertexConsumer buffer = ItemRenderer.m_115211_((MultiBufferSource)buffers, (RenderType)layer, (boolean)true, (boolean)info.enchanted());
            this.renderModel(ms, buffer, light, overlay, model);
            ms.m_85849_();
        }
        ms.m_85837_(0.0, 1.5, 0.0);
        ms.m_85836_();
        ms.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        this.renderItems(potato, potatoFacing, ms, buffers, light, overlay);
        ms.m_85849_();
        ms.m_85845_(Vector3f.f_122227_.m_122240_(-rotZ));
        ms.m_85845_(Vector3f.f_122224_.m_122240_(-rotY));
        this.renderName(potato, info.name(), ms, buffers, light);
        ms.m_85849_();
    }

    private void renderName(TinyPotatoBlockEntity potato, String name, PoseStack ms, MultiBufferSource buffers, int light) {
        Minecraft mc = Minecraft.m_91087_();
        HitResult pos = mc.f_91077_;
        if (Minecraft.m_91404_() && !name.isEmpty() && pos != null && pos.m_6662_() == HitResult.Type.BLOCK && potato.m_58899_().equals((Object)((BlockHitResult)pos).m_82425_())) {
            ms.m_85836_();
            ms.m_85837_(0.0, (double)-0.6f, 0.0);
            ms.m_85845_(mc.m_91290_().m_114470_());
            float f1 = 0.02666667f;
            ms.m_85841_(-f1, -f1, f1);
            int halfWidth = mc.f_91062_.m_92895_(potato.name.getString()) / 2;
            float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int opacityRGB = (int)(opacity * 255.0f) << 24;
            mc.f_91062_.m_92841_(potato.name, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.m_85850_().m_85861_(), buffers, true, opacityRGB, light);
            mc.f_91062_.m_92841_(potato.name, (float)(-halfWidth), 0.0f, -1, false, ms.m_85850_().m_85861_(), buffers, false, 0, light);
            if (name.equals("pahimar") || name.equals("soaryn")) {
                ms.m_85837_(0.0, 14.0, 0.0);
                String str = name.equals("pahimar") ? "[WIP]" : "(soon)";
                halfWidth = mc.f_91062_.m_92895_(str) / 2;
                mc.f_91062_.m_92811_(str, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.m_85850_().m_85861_(), buffers, true, opacityRGB, light);
                mc.f_91062_.m_92811_(str, (float)(-halfWidth), 0.0f, -1, false, ms.m_85850_().m_85861_(), buffers, true, 0, light);
            }
            ms.m_85849_();
        }
    }

    private void renderItems(TinyPotatoBlockEntity potato, Direction facing, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.m_85836_();
        ms.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        ms.m_85837_(0.0, -1.0, 0.0);
        float s = 0.2857143f;
        ms.m_85841_(s, s, s);
        for (int i = 0; i < potato.m_6643_(); ++i) {
            ItemStack stack = potato.m_8020_(i);
            if (stack.m_41619_()) continue;
            ms.m_85836_();
            Direction side = Direction.values()[i];
            if (side.m_122434_() != Direction.Axis.Y) {
                float sideAngle = side.m_122435_() - facing.m_122435_();
                side = Direction.m_122364_((double)sideAngle);
            }
            boolean block = stack.m_41720_() instanceof BlockItem;
            boolean mySon = stack.m_41720_() == TinyPotatoModule.tiny_potato.m_5456_();
            switch (side) {
                case UP: {
                    if (mySon) {
                        ms.m_85837_(0.0, -0.375, 0.5);
                    } else if (block) {
                        ms.m_85837_(0.0, (double)0.3f, 0.5);
                    }
                    ms.m_85837_(0.0, -0.5, (double)-0.4f);
                    break;
                }
                case DOWN: {
                    ms.m_85837_(0.0, (double)-2.3f, (double)-0.88f);
                    if (mySon) {
                        ms.m_85837_(0.0, 1.25, 0.5);
                        break;
                    }
                    if (!block) break;
                    ms.m_85837_(0.0, 1.0, (double)0.6f);
                    break;
                }
                case NORTH: {
                    ms.m_85837_(0.0, (double)-1.9f, (double)0.02f);
                    if (mySon) {
                        ms.m_85837_(0.0, (double)-0.29f, (double)0.6f);
                        break;
                    }
                    if (!block) break;
                    ms.m_85837_(0.0, 1.0, (double)0.6f);
                    break;
                }
                case SOUTH: {
                    ms.m_85837_(0.0, (double)-1.6f, (double)-0.89f);
                    if (mySon) {
                        ms.m_85837_(0.0, (double)-0.59f, (double)0.26f);
                        break;
                    }
                    if (!block) break;
                    ms.m_85837_(0.0, 1.0, 0.5);
                    break;
                }
                case EAST: {
                    if (mySon) {
                        ms.m_85837_((double)-0.35f, (double)-0.29f, (double)-0.06f);
                    } else if (block) {
                        ms.m_85837_((double)-0.4f, (double)0.8f, 0.0);
                    } else {
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                    }
                    ms.m_85837_((double)-0.3f, (double)-1.9f, (double)0.04f);
                    break;
                }
                case WEST: {
                    if (mySon) {
                        ms.m_85837_((double)0.95f, (double)-0.29f, (double)0.9f);
                    } else if (block) {
                        ms.m_85837_(1.0, (double)0.8f, 1.0);
                    } else {
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                    }
                    ms.m_85837_((double)-0.3f, (double)-1.9f, (double)-0.92f);
                }
            }
            if (mySon) {
                ms.m_85841_(1.1f, 1.1f, 1.1f);
            } else if (block) {
                ms.m_85841_(0.5f, 0.5f, 0.5f);
            }
            if (block && side == Direction.NORTH) {
                ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
            this.renderItem(ms, buffers, light, overlay, stack);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    private void renderModel(PoseStack ms, VertexConsumer buffer, int light, int overlay, BakedModel model) {
        this.blockRenderDispatcher.m_110937_().m_111067_(ms.m_85850_(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    private void renderItem(PoseStack ms, MultiBufferSource buffers, int light, int overlay, ItemStack stack) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.HEAD, light, overlay, ms, buffers, 0);
    }
}

