/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl;

import java.io.PrintStream;
import java.util.function.Consumer;
import net.coderbot.iris.Iris;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.opengl.GLDebugMessageAMDCallbackI;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.APIUtil;

public final class GLDebug {
    public static int setupDebugMessageCallback() {
        return GLDebug.setupDebugMessageCallback(APIUtil.DEBUG_STREAM);
    }

    private static void trace(Consumer<String> output) {
        StackTraceElement[] elems;
        for (StackTraceElement ste : elems = GLDebug.filterStackTrace(new Throwable(), 4).getStackTrace()) {
            output.accept(ste.toString());
        }
    }

    public static Throwable filterStackTrace(Throwable throwable, int offset) {
        StackTraceElement[] elems = throwable.getStackTrace();
        StackTraceElement[] filtered = new StackTraceElement[elems.length];
        int j = 0;
        for (int i = offset; i < elems.length; ++i) {
            String className = elems[i].getClassName();
            if (className == null) {
                className = "";
            }
            filtered[j++] = elems[i];
        }
        StackTraceElement[] newElems = new StackTraceElement[j];
        System.arraycopy(filtered, 0, newElems, 0, j);
        throwable.setStackTrace(newElems);
        return throwable;
    }

    private static void printTrace(final PrintStream stream) {
        GLDebug.trace(new Consumer<String>(){
            boolean first = true;

            @Override
            public void accept(String str) {
                if (this.first) {
                    GLDebug.printDetail(stream, "Stacktrace", str);
                    this.first = false;
                } else {
                    GLDebug.printDetailLine(stream, "Stacktrace", str);
                }
            }
        });
    }

    public static int setupDebugMessageCallback(PrintStream stream) {
        GLCapabilities caps = GL.getCapabilities();
        if (caps.OpenGL43) {
            Iris.logger.info("[GL] Using OpenGL 4.3 for error logging.");
            GLDebugMessageCallback proc = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> {
                stream.println("[LWJGL] OpenGL debug message");
                GLDebug.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebug.printDetail(stream, "Source", GLDebug.getDebugSource(source));
                GLDebug.printDetail(stream, "Type", GLDebug.getDebugType(type));
                GLDebug.printDetail(stream, "Severity", GLDebug.getDebugSeverity(severity));
                GLDebug.printDetail(stream, "Message", GLDebugMessageCallback.getMessage((int)length, (long)message));
                GLDebug.printTrace(stream);
            });
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)37190, (int[])null, (boolean)true);
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)37191, (int[])null, (boolean)false);
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)37192, (int[])null, (boolean)false);
            GL43C.glDebugMessageControl((int)4352, (int)4352, (int)33387, (int[])null, (boolean)false);
            GL43C.glDebugMessageCallback((GLDebugMessageCallbackI)proc, (long)0L);
            if ((GL43C.glGetInteger((int)33310) & 2) == 0) {
                Iris.logger.warn("[GL] Warning: A non-debug context may not produce any debug output.");
                GL43C.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (caps.GL_KHR_debug) {
            Iris.logger.info("[GL] Using KHR_debug for error logging.");
            GLDebugMessageCallback proc = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> {
                stream.println("[LWJGL] OpenGL debug message");
                GLDebug.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebug.printDetail(stream, "Source", GLDebug.getDebugSource(source));
                GLDebug.printDetail(stream, "Type", GLDebug.getDebugType(type));
                GLDebug.printDetail(stream, "Severity", GLDebug.getDebugSeverity(severity));
                GLDebug.printDetail(stream, "Message", GLDebugMessageCallback.getMessage((int)length, (long)message));
                GLDebug.printTrace(stream);
            });
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37190, (int[])null, (boolean)true);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37191, (int[])null, (boolean)false);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)37192, (int[])null, (boolean)false);
            KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)33387, (int[])null, (boolean)false);
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)proc, (long)0L);
            if (caps.OpenGL30 && (GL43C.glGetInteger((int)33310) & 2) == 0) {
                Iris.logger.warn("[GL] Warning: A non-debug context may not produce any debug output.");
                GL43C.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (caps.GL_ARB_debug_output) {
            Iris.logger.info("[GL] Using ARB_debug_output for error logging.");
            GLDebugMessageARBCallback proc = GLDebugMessageARBCallback.create((source, type, id, severity, length, message, userParam) -> {
                stream.println("[LWJGL] ARB_debug_output message");
                GLDebug.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebug.printDetail(stream, "Source", GLDebug.getSourceARB(source));
                GLDebug.printDetail(stream, "Type", GLDebug.getTypeARB(type));
                GLDebug.printDetail(stream, "Severity", GLDebug.getSeverityARB(severity));
                GLDebug.printDetail(stream, "Message", GLDebugMessageARBCallback.getMessage((int)length, (long)message));
                GLDebug.printTrace(stream);
            });
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37190, (int[])null, (boolean)true);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37191, (int[])null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37192, (int[])null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)33387, (int[])null, (boolean)false);
            ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)proc, (long)0L);
            return 1;
        }
        if (caps.GL_AMD_debug_output) {
            Iris.logger.info("[GL] Using AMD_debug_output for error logging.");
            GLDebugMessageAMDCallback proc = GLDebugMessageAMDCallback.create((id, category, severity, length, message, userParam) -> {
                stream.println("[LWJGL] AMD_debug_output message");
                GLDebug.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebug.printDetail(stream, "Category", GLDebug.getCategoryAMD(category));
                GLDebug.printDetail(stream, "Severity", GLDebug.getSeverityAMD(severity));
                GLDebug.printDetail(stream, "Message", GLDebugMessageAMDCallback.getMessage((int)length, (long)message));
                GLDebug.printTrace(stream);
            });
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37190, (int[])null, (boolean)true);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37191, (int[])null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37192, (int[])null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)33387, (int[])null, (boolean)false);
            AMDDebugOutput.glDebugMessageCallbackAMD((GLDebugMessageAMDCallbackI)proc, (long)0L);
            return 1;
        }
        Iris.logger.info("[GL] No debug output implementation is available, cannot return debug info.");
        return 0;
    }

    public static int disableDebugMessages() {
        GLCapabilities caps = GL.getCapabilities();
        if (caps.OpenGL43) {
            GL43C.glDebugMessageCallback(null, (long)0L);
            return 1;
        }
        if (caps.GL_KHR_debug) {
            KHRDebug.glDebugMessageCallback(null, (long)0L);
            if (caps.OpenGL30 && (GL43C.glGetInteger((int)33310) & 2) == 0) {
                GL43C.glDisable((int)37600);
            }
            return 1;
        }
        if (caps.GL_ARB_debug_output) {
            ARBDebugOutput.glDebugMessageCallbackARB(null, (long)0L);
            return 1;
        }
        if (caps.GL_AMD_debug_output) {
            AMDDebugOutput.glDebugMessageCallbackAMD(null, (long)0L);
            return 1;
        }
        Iris.logger.info("[GL] No debug output implementation is available, cannot disable debug info.");
        return 0;
    }

    private static void printDetail(PrintStream stream, String type, String message) {
        stream.printf("\t%s: %s\n", type, message);
    }

    private static void printDetailLine(PrintStream stream, String type, String message) {
        stream.append("    ");
        for (int i = 0; i < type.length(); ++i) {
            stream.append(" ");
        }
        stream.append(message).append("\n");
    }

    private static String getDebugSource(int source) {
        switch (source) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken((int)source);
    }

    private static String getDebugType(int type) {
        switch (type) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return APIUtil.apiUnknownToken((int)type);
    }

    private static String getDebugSeverity(int severity) {
        switch (severity) {
            case 33387: {
                return "NOTIFICATION";
            }
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return APIUtil.apiUnknownToken((int)severity);
    }

    private static String getSourceARB(int source) {
        switch (source) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken((int)source);
    }

    private static String getTypeARB(int type) {
        switch (type) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken((int)type);
    }

    private static String getSeverityARB(int severity) {
        switch (severity) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return APIUtil.apiUnknownToken((int)severity);
    }

    private static String getCategoryAMD(int category) {
        switch (category) {
            case 37193: {
                return "API ERROR";
            }
            case 37194: {
                return "WINDOW SYSTEM";
            }
            case 37195: {
                return "DEPRECATION";
            }
            case 37196: {
                return "UNDEFINED BEHAVIOR";
            }
            case 37197: {
                return "PERFORMANCE";
            }
            case 37198: {
                return "SHADER COMPILER";
            }
            case 37199: {
                return "APPLICATION";
            }
            case 37200: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken((int)category);
    }

    private static String getSeverityAMD(int severity) {
        switch (severity) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return APIUtil.apiUnknownToken((int)severity);
    }
}

