/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.arguments;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Objects;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class ArgumentUtils {
    public static <A extends ArgumentType<?>> JsonObject serializeToJson(ArgumentTypeInfo.Template<A> template) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "argument");
        object.addProperty("parser", ForgeRegistries.COMMAND_ARGUMENT_TYPES.getKey((Object)template.m_213709_()).toString());
        JsonObject properties = new JsonObject();
        ArgumentUtils.serializeToJson(properties, template.m_213709_(), template);
        if (properties.size() > 0) {
            object.add("properties", (JsonElement)properties);
        }
        return object;
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeToJson(JsonObject jsonObject, ArgumentTypeInfo<A, T> argumentTypeInfo, ArgumentTypeInfo.Template<A> template) {
        argumentTypeInfo.m_213719_(template, jsonObject);
    }

    public static <A extends ArgumentType<?>> void serializeToNetwork(FriendlyByteBuf buffer, ArgumentTypeInfo.Template<A> template) {
        ArgumentUtils.serializeToNetwork(buffer, template.m_213709_(), template);
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeToNetwork(FriendlyByteBuf buffer, ArgumentTypeInfo<A, T> type, ArgumentTypeInfo.Template<A> template) {
        buffer.writeRegistryIdUnsafe(ForgeRegistries.COMMAND_ARGUMENT_TYPES, type);
        type.m_214155_(template, buffer);
    }

    public static ArgumentTypeInfo.Template<?> deserialize(FriendlyByteBuf buffer) {
        ArgumentTypeInfo type = (ArgumentTypeInfo)buffer.readRegistryIdUnsafe(ForgeRegistries.COMMAND_ARGUMENT_TYPES);
        Objects.requireNonNull(type, "Unknown argument type");
        return type.m_213618_(buffer);
    }

    public static Component getMessage(Message message) {
        MutableComponent mutableComponent;
        if (message instanceof Component) {
            Component component = (Component)message;
            mutableComponent = component;
        } else {
            mutableComponent = Component.m_237113_((String)message.getString());
        }
        return mutableComponent;
    }

    public static Component getMessage(SimpleCommandExceptionType exception) {
        return ArgumentUtils.getMessage(exception.create().getRawMessage());
    }
}

