/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries.forge;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarBuilder;
import dev.architectury.registry.registries.Registries;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.registry.registries.options.RegistrarOption;
import dev.architectury.registry.registries.options.StandardRegistrarOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistriesImpl {
    private static final Logger LOGGER = LogManager.getLogger(RegistriesImpl.class);
    private static final Multimap<RegistryEntryId<?>, Consumer<?>> LISTENERS = HashMultimap.create();

    private static void listen(ResourceKey<?> resourceKey, ResourceLocation id, Consumer<?> listener, boolean vanilla) {
        LISTENERS.put(new RegistryEntryId(resourceKey, id), listener);
    }

    public static Registries.RegistryProvider _get(String modId) {
        return new RegistryProviderImpl(modId);
    }

    public record RegistryEntryId<T>(ResourceKey<T> registryKey, ResourceLocation id) {
        @Override
        public String toString() {
            return "Registry Entry [%s / %s]".formatted(this.registryKey.m_135782_(), this.id);
        }
    }

    public static class RegistryProviderImpl
    implements Registries.RegistryProvider {
        private static final Map<ResourceKey<Registry<?>>, Registrar<?>> CUSTOM_REGS = new HashMap();
        private final String modId;
        private final Supplier<IEventBus> eventBus;
        private final Map<ResourceKey<? extends Registry<?>>, Data<?>> registry = new HashMap();
        private final Multimap<ResourceKey<Registry<?>>, Consumer<Registrar<?>>> listeners = HashMultimap.create();
        @Nullable
        private List<RegistryBuilderEntry> builders = new ArrayList<RegistryBuilderEntry>();

        public RegistryProviderImpl(String modId) {
            this.modId = modId;
            this.eventBus = Suppliers.memoize(() -> {
                IEventBus eventBus = EventBuses.getModEventBus(modId).orElseThrow(() -> new IllegalStateException("Can't get event bus for mod '" + modId + "' because it was not registered!"));
                eventBus.register((Object)new EventListener());
                return eventBus;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEventBus() {
            Supplier<IEventBus> supplier = this.eventBus;
            synchronized (supplier) {
                this.eventBus.get();
            }
        }

        @Override
        public <T> Registrar<T> get(ResourceKey<Registry<T>> registryKey) {
            this.updateEventBus();
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryKey.m_135782_());
            if (registry == null) {
                Registry ts = (Registry)Registry.f_122897_.m_7745_(registryKey.m_135782_());
                if (ts == null) {
                    ts = (Registry)BuiltinRegistries.f_123858_.m_7745_(registryKey.m_135782_());
                }
                if (ts != null) {
                    return this.get(ts);
                }
                Registrar<?> customReg = CUSTOM_REGS.get(registryKey);
                if (customReg != null) {
                    return customReg;
                }
                throw new IllegalArgumentException("Registry " + registryKey + " does not exist!");
            }
            return this.get((IForgeRegistry<T>)registry);
        }

        public <T> Registrar<T> get(IForgeRegistry<T> registry) {
            this.updateEventBus();
            return new ForgeBackedRegistryImpl<T>(this.modId, this.registry, registry);
        }

        @Override
        public <T> Registrar<T> get(Registry<T> registry) {
            this.updateEventBus();
            return new VanillaBackedRegistryImpl<T>(this.modId, this.registry, registry);
        }

        @Override
        public <T> void forRegistry(ResourceKey<Registry<T>> key, Consumer<Registrar<T>> consumer) {
            this.listeners.put(key, consumer);
        }

        @Override
        public <T> RegistrarBuilder<T> builder(Class<T> type, ResourceLocation registryId) {
            return new RegistryBuilderWrapper(this, new RegistryBuilder().setName(registryId), registryId);
        }

        public class EventListener {
            @SubscribeEvent
            public void handleEvent(RegisterEvent event) {
                for (Map.Entry<ResourceKey<Registry<?>>, Data<?>> typeDataEntry : RegistryProviderImpl.this.registry.entrySet()) {
                    if (!typeDataEntry.getKey().equals((Object)event.getRegistryKey())) continue;
                    this.registerFor(event, typeDataEntry.getKey(), typeDataEntry.getValue());
                }
            }

            public <T> void registerFor(RegisterEvent event, ResourceKey<? extends Registry<T>> resourceKey, Data<T> data) {
                event.register(resourceKey, registry -> {
                    Registrar archRegistry;
                    data.registered = true;
                    for (Map.Entry entry : data.objects.entrySet()) {
                        ResourceLocation location = entry.getKey();
                        Object value = entry.getValue().get();
                        registry.register(location, value);
                        RegistryEntryId registryEntryId = new RegistryEntryId(resourceKey, location);
                        for (Consumer consumer : LISTENERS.get(registryEntryId)) {
                            consumer.accept(value);
                        }
                        LISTENERS.removeAll(registryEntryId);
                    }
                    data.objects.clear();
                    if (event.getForgeRegistry() != null) {
                        archRegistry = RegistryProviderImpl.this.get(event.getForgeRegistry());
                    } else if (event.getVanillaRegistry() != null) {
                        archRegistry = RegistryProviderImpl.this.get(event.getVanillaRegistry());
                    } else {
                        LOGGER.error("Unable to find registry from RegisterEvent as both vanilla and forge registries are null! " + event.getRegistryKey());
                        return;
                    }
                    for (Map.Entry entry : RegistryProviderImpl.this.listeners.entries()) {
                        if (!((ResourceKey)entry.getKey()).m_135782_().equals((Object)resourceKey.m_135782_())) continue;
                        ((Consumer)entry.getValue()).accept(archRegistry);
                    }
                });
            }

            @SubscribeEvent(priority=EventPriority.LOWEST)
            public void handleEventPost(RegisterEvent event) {
                Registrar archRegistry;
                if (event.getForgeRegistry() != null) {
                    archRegistry = RegistryProviderImpl.this.get(event.getForgeRegistry());
                } else if (event.getVanillaRegistry() != null) {
                    archRegistry = RegistryProviderImpl.this.get(event.getVanillaRegistry());
                } else {
                    LOGGER.error("Unable to find registry from RegisterEvent as both vanilla and forge registries are null! " + event.getRegistryKey());
                    return;
                }
                ArrayList<RegistryEntryId> toRemove = new ArrayList<RegistryEntryId>();
                for (Map.Entry entry : LISTENERS.asMap().entrySet()) {
                    if (!((RegistryEntryId)entry.getKey()).registryKey.equals((Object)event.getRegistryKey())) continue;
                    if (archRegistry.contains(((RegistryEntryId)entry.getKey()).id)) {
                        Object value = archRegistry.get(((RegistryEntryId)entry.getKey()).id);
                        for (Consumer consumer : (Collection)entry.getValue()) {
                            consumer.accept(value);
                        }
                        toRemove.add((RegistryEntryId)entry.getKey());
                        continue;
                    }
                    LOGGER.warn("Registry entry listened {} was not realized!", entry.getKey());
                }
                for (RegistryEntryId id : toRemove) {
                    LISTENERS.removeAll((Object)id);
                }
            }

            @SubscribeEvent
            public void handleEvent(NewRegistryEvent event) {
                if (RegistryProviderImpl.this.builders != null) {
                    for (RegistryBuilderEntry builder : RegistryProviderImpl.this.builders) {
                        event.create(builder.builder(), builder.forgeRegistry());
                    }
                    RegistryProviderImpl.this.builders = null;
                }
            }
        }

        record RegistryBuilderEntry(RegistryBuilder<?> builder, Consumer<IForgeRegistry<?>> forgeRegistry) {
        }
    }

    public static class DelegatedRegistrar<T>
    implements Registrar<T> {
        private final String modId;
        private final Supplier<Registrar<T>> delegate;
        private final ResourceLocation registryId;
        private List<Runnable> onRegister = new ArrayList<Runnable>();

        public DelegatedRegistrar(String modId, Supplier<Registrar<T>> delegate, ResourceLocation registryId) {
            this.modId = modId;
            this.delegate = delegate;
            this.registryId = registryId;
        }

        public void onRegister() {
            if (this.onRegister != null) {
                for (Runnable runnable : this.onRegister) {
                    runnable.run();
                }
            }
            this.onRegister = null;
        }

        public boolean isReady() {
            return this.onRegister == null;
        }

        @Override
        public RegistrySupplier<T> delegate(final ResourceLocation id) {
            if (this.isReady()) {
                return this.delegate.get().delegate(id);
            }
            return new RegistrySupplier<T>(){

                @Override
                public Registries getRegistries() {
                    return Registries.get(modId);
                }

                @Override
                public Registrar<T> getRegistrar() {
                    return this;
                }

                @Override
                public ResourceLocation getRegistryId() {
                    return this.key().m_135782_();
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.isReady() && delegate.get().contains(id);
                }

                @Override
                public T get() {
                    return this.isReady() ? (Object)delegate.get().get(id) : null;
                }
            };
        }

        @Override
        public <E extends T> RegistrySupplier<E> register(ResourceLocation id, Supplier<E> supplier) {
            if (this.isReady()) {
                return this.delegate.get().register(id, supplier);
            }
            this.onRegister.add(() -> this.delegate.get().register(id, supplier));
            return this.delegate(id);
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return !this.isReady() ? null : this.delegate.get().getId(obj);
        }

        @Override
        public int getRawId(T obj) {
            return !this.isReady() ? -1 : this.delegate.get().getRawId(obj);
        }

        @Override
        public Optional<ResourceKey<T>> getKey(T obj) {
            return !this.isReady() ? Optional.empty() : this.delegate.get().getKey(obj);
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return !this.isReady() ? null : (T)this.delegate.get().get(id);
        }

        @Override
        @Nullable
        public T byRawId(int rawId) {
            return !this.isReady() ? null : (T)this.delegate.get().byRawId(rawId);
        }

        @Override
        public boolean contains(ResourceLocation id) {
            return this.isReady() && this.delegate.get().contains(id);
        }

        @Override
        public boolean containsValue(T obj) {
            return this.isReady() && this.delegate.get().containsValue(obj);
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.isReady() ? this.delegate.get().getIds() : Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
            return this.isReady() ? this.delegate.get().entrySet() : Collections.emptySet();
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return this.isReady() ? this.delegate.get().key() : ResourceKey.m_135788_((ResourceLocation)this.registryId);
        }

        @Override
        public void listen(ResourceLocation id, Consumer<T> callback) {
            if (this.isReady()) {
                this.delegate.get().listen(id, callback);
            } else {
                this.onRegister.add(() -> this.delegate.get().listen(id, callback));
            }
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.isReady() ? this.delegate.get().iterator() : Collections.emptyIterator();
        }
    }

    public static class ForgeBackedRegistryImpl<T>
    implements Registrar<T> {
        private final String modId;
        private IForgeRegistry<T> delegate;
        private Map<ResourceKey<? extends Registry<?>>, Data<?>> registry;

        public ForgeBackedRegistryImpl(String modId, Map<ResourceKey<? extends Registry<?>>, Data<?>> registry, IForgeRegistry<T> delegate) {
            this.modId = modId;
            this.registry = registry;
            this.delegate = delegate;
        }

        @Override
        public RegistrySupplier<T> delegate(final ResourceLocation id) {
            com.google.common.base.Supplier value = Suppliers.memoize(() -> this.get(id));
            final ForgeBackedRegistryImpl registrar = this;
            return new RegistrySupplier<T>((Supplier)value){
                final /* synthetic */ Supplier val$value;
                {
                    this.val$value = supplier;
                }

                @Override
                public Registries getRegistries() {
                    return Registries.get(modId);
                }

                @Override
                public Registrar<T> getRegistrar() {
                    return registrar;
                }

                @Override
                public ResourceLocation getRegistryId() {
                    return delegate.getRegistryName();
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return this.val$value.get();
                }

                public int hashCode() {
                    return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        public <E extends T> RegistrySupplier<E> register(final ResourceLocation id, Supplier<E> supplier) {
            final Object[] objectArr = new Object[]{null};
            Data data = this.registry.computeIfAbsent(this.key(), type -> new Data());
            data.registerForForge(this.delegate, id, objectArr, supplier);
            final ForgeBackedRegistryImpl registrar = this;
            return new RegistrySupplier<E>(){

                @Override
                public Registries getRegistries() {
                    return Registries.get(modId);
                }

                @Override
                public Registrar<E> getRegistrar() {
                    return registrar;
                }

                @Override
                public ResourceLocation getRegistryId() {
                    return delegate.getRegistryName();
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return objectArr[0] != null;
                }

                @Override
                public E get() {
                    Object value = objectArr[0];
                    if (value == null) {
                        throw new NullPointerException("Value missing: " + this.getId() + "@" + this.getRegistryId());
                    }
                    return value;
                }

                public int hashCode() {
                    return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.getKey(obj);
        }

        @Override
        public int getRawId(T obj) {
            return ((ForgeRegistry)this.delegate).getID(obj);
        }

        @Override
        public Optional<ResourceKey<T>> getKey(T t) {
            return Optional.ofNullable(this.getId(t)).map(id -> ResourceKey.m_135785_(this.key(), (ResourceLocation)id));
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.getValue(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)((ForgeRegistry)this.delegate).getValue(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.containsKey(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.containsValue(t);
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.getKeys();
        }

        @Override
        public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
            return this.delegate.getEntries();
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return ResourceKey.m_135788_((ResourceLocation)this.delegate.getRegistryName());
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public void listen(ResourceLocation id, Consumer<T> callback) {
            if (this.contains(id)) {
                callback.accept(this.get(id));
            } else {
                RegistriesImpl.listen(this.key(), id, callback, false);
            }
        }
    }

    public static class VanillaBackedRegistryImpl<T>
    implements Registrar<T> {
        private final String modId;
        private Registry<T> delegate;
        private Map<ResourceKey<? extends Registry<?>>, Data<?>> registry;

        public VanillaBackedRegistryImpl(String modId, Map<ResourceKey<? extends Registry<?>>, Data<?>> registry, Registry<T> delegate) {
            this.modId = modId;
            this.registry = registry;
            this.delegate = delegate;
        }

        @Override
        public RegistrySupplier<T> delegate(final ResourceLocation id) {
            com.google.common.base.Supplier value = Suppliers.memoize(() -> this.get(id));
            final VanillaBackedRegistryImpl registrar = this;
            return new RegistrySupplier<T>((Supplier)value){
                final /* synthetic */ Supplier val$value;
                {
                    this.val$value = supplier;
                }

                @Override
                public Registries getRegistries() {
                    return Registries.get(modId);
                }

                @Override
                public Registrar<T> getRegistrar() {
                    return registrar;
                }

                @Override
                public ResourceLocation getRegistryId() {
                    return delegate.m_123023_().m_135782_();
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return this.val$value.get();
                }

                public int hashCode() {
                    return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId() + "@" + id.toString();
                }
            };
        }

        @Override
        public <E extends T> RegistrySupplier<E> register(ResourceLocation id, Supplier<E> supplier) {
            Data data = this.registry.computeIfAbsent(this.key(), type -> new Data());
            data.register(this.delegate, id, supplier);
            return this.delegate(id);
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.m_7981_(obj);
        }

        @Override
        public int getRawId(T obj) {
            return this.delegate.m_7447_(obj);
        }

        @Override
        public Optional<ResourceKey<T>> getKey(T t) {
            return this.delegate.m_7854_(t);
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.m_7745_(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)this.delegate.m_7942_(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.m_6566_().contains(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.m_7854_(t).isPresent();
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.m_6566_();
        }

        @Override
        public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
            return this.delegate.m_6579_();
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return this.delegate.m_123023_();
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public void listen(ResourceLocation id, Consumer<T> callback) {
            if (this.contains(id)) {
                callback.accept(this.get(id));
            } else {
                RegistriesImpl.listen(this.key(), id, callback, true);
            }
        }
    }

    public static class RegistryBuilderWrapper<T>
    implements RegistrarBuilder<T> {
        private final RegistryProviderImpl provider;
        private final RegistryBuilder<?> builder;
        private final ResourceLocation registryId;
        private boolean saveToDisk = false;
        private boolean syncToClients = false;

        public RegistryBuilderWrapper(RegistryProviderImpl provider, RegistryBuilder<?> builder, ResourceLocation registryId) {
            this.provider = provider;
            this.builder = builder;
            this.registryId = registryId;
        }

        @Override
        public Registrar<T> build() {
            if (!this.syncToClients) {
                this.builder.disableSync();
            }
            if (!this.saveToDisk) {
                this.builder.disableSaving();
            }
            if (this.provider.builders == null) {
                throw new IllegalStateException("Cannot create registries when registries are already aggregated!");
            }
            Registrar[] registrarRef = new Registrar[1];
            DelegatedRegistrar registrar = new DelegatedRegistrar(this.provider.modId, () -> Objects.requireNonNull(registrarRef[0], "Registry not yet initialized!"), this.registryId);
            RegistryProviderImpl.RegistryBuilderEntry entry = new RegistryProviderImpl.RegistryBuilderEntry(this.builder, forgeRegistry -> {
                registrarRef[0] = this.provider.get(forgeRegistry);
                registrar.onRegister();
            });
            this.provider.builders.add(entry);
            RegistryProviderImpl.CUSTOM_REGS.put(registrar.key(), registrar);
            return registrar;
        }

        @Override
        public RegistrarBuilder<T> option(RegistrarOption option) {
            if (option == StandardRegistrarOption.SAVE_TO_DISC) {
                this.saveToDisk = true;
            } else if (option == StandardRegistrarOption.SYNC_TO_CLIENTS) {
                this.syncToClients = true;
            }
            return this;
        }
    }

    public static class Data<T> {
        private boolean registered = false;
        private final Map<ResourceLocation, Supplier<? extends T>> objects = new LinkedHashMap<ResourceLocation, Supplier<? extends T>>();

        public void registerForForge(IForgeRegistry<T> registry, ResourceLocation location, Object[] objectArr, Supplier<? extends T> reference) {
            if (!this.registered) {
                this.objects.put(location, () -> {
                    Object value = reference.get();
                    objectArr[0] = value;
                    return value;
                });
            } else {
                ResourceKey resourceKey = ResourceKey.m_135788_((ResourceLocation)registry.getRegistryName());
                T value = reference.get();
                registry.register(location, value);
                objectArr[0] = value;
                RegistryEntryId registryEntryId = new RegistryEntryId(resourceKey, location);
                for (Consumer consumer : LISTENERS.get(registryEntryId)) {
                    consumer.accept(value);
                }
                LISTENERS.removeAll(registryEntryId);
            }
        }

        public void register(Registry<T> registry, ResourceLocation location, Supplier<? extends T> reference) {
            if (!this.registered) {
                this.objects.put(location, reference);
            } else {
                T value = reference.get();
                Registry.m_122965_(registry, (ResourceLocation)location, value);
                RegistryEntryId registryEntryId = new RegistryEntryId(registry.m_123023_(), location);
                for (Consumer consumer : LISTENERS.get(registryEntryId)) {
                    consumer.accept(value);
                }
                LISTENERS.removeAll(registryEntryId);
            }
        }
    }
}

