/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.blur;

import com.google.common.collect.Lists;
import de.cheaterpaul.blur.BlurClient;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="reblured", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlurConfig {
    private static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static int colorFirst;
    public static int colorSecond;
    public static Set<String> guiExlusions;

    public static void registerConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent configEvent) {
        BlurConfig.updateColors();
    }

    private static void updateColors() {
        int colorFirst = Integer.parseUnsignedInt((String)BlurConfig.CLIENT.colorFirstRaw.get(), 16);
        BlurConfig.colorFirst = BlurConfig.convertColor(colorFirst);
        int colorSecond = Integer.parseUnsignedInt((String)BlurConfig.CLIENT.colorSecondRaw.get(), 16);
        BlurConfig.colorSecond = BlurConfig.convertColor(colorSecond);
        guiExlusions.clear();
        guiExlusions.addAll((Collection)BlurConfig.CLIENT.guiExclusions.get());
        Minecraft.m_91087_().execute(() -> BlurClient.updateUniform("Radius", ((Integer)BlurConfig.CLIENT.radius.get()).intValue()));
    }

    private static int convertColor(int rgba) {
        return (rgba & 0xFF) << 24 | (rgba >> 24 & 0xFF) << 16 | (rgba >> 16 & 0xFF) << 8 | (rgba >> 8 & 0xFF) << 0;
    }

    static {
        guiExlusions = new HashSet<String>();
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> guiExclusions;
        public final ForgeConfigSpec.IntValue fadeTime;
        public final ForgeConfigSpec.IntValue radius;
        public final ForgeConfigSpec.ConfigValue<String> colorFirstRaw;
        public final ForgeConfigSpec.ConfigValue<String> colorSecondRaw;

        private Client(ForgeConfigSpec.Builder builder) {
            this.guiExclusions = builder.comment("A list of classes to be excluded from the blur shader.").defineList("guiExclusions", (List)Lists.newArrayList((Object[])new String[]{ChatScreen.class.getName(), InBedChatScreen.class.getName()}), o -> {
                try {
                    return o instanceof String && Class.forName((String)o) != null;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            });
            this.fadeTime = builder.comment("The time it takes for the blur to fade in, in ms.").defineInRange("fadeTime", 100, 0, 10000);
            this.radius = builder.comment("The radius of the blur effect. This controls how \"strong\" the blur is.").defineInRange("radius", 12, 1, 100);
            this.colorFirstRaw = builder.comment("The top color of the background gradient. Given in RGBA hex.").define("gradientStartColor", (Object)"0000003f", this::isHexValue);
            this.colorSecondRaw = builder.comment("The bottom color of the background gradient. Given in RGBA hex.").define("gradientEndColor", (Object)"0000003f", this::isHexValue);
        }

        private boolean isHexValue(Object o) {
            if (o instanceof String) {
                try {
                    Integer.parseUnsignedInt((String)o, 16);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

