/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.screen.sync;

import dev.ftb.mods.ftbic.screen.sync.SyncedDataValue;
import java.util.function.DoubleSupplier;

public class DoubleValue
extends SyncedDataValue<Double> {
    private final DoubleSupplier value;

    public DoubleValue(DoubleSupplier v) {
        this.value = v;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public void write(int[] data) {
        long bits = Double.doubleToLongBits(this.value.getAsDouble());
        data[this.index] = (int)(bits >> 0 & 0xFFFFL);
        data[this.index + 1] = (int)(bits >> 16 & 0xFFFFL);
        data[this.index + 2] = (int)(bits >> 32 & 0xFFFFL);
        data[this.index + 3] = (int)(bits >> 48 & 0xFFFFL);
    }

    @Override
    public Double read(int[] data) {
        long b0 = (long)data[this.index] & 0xFFFFL;
        long b1 = ((long)data[this.index + 1] & 0xFFFFL) << 16;
        long b2 = ((long)data[this.index + 2] & 0xFFFFL) << 32;
        long b3 = ((long)data[this.index + 3] & 0xFFFFL) << 48;
        return Double.longBitsToDouble(b0 | b1 | b2 | b3);
    }
}

